package com.biz.crm.tpm.business.daily.sales.data.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 分子公司日销售报表
 *
 * @author hd
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_sap_day_sales")
@Table(name = "tpm_sap_day_sales", indexes = {
        @Index(name = "tpm_sap_day_sales_index1", columnList = "id", unique = true),
        @Index(name = "tpm_daily_sales_data_index2", columnList = "ds"),
        @Index(name = "tpm_daily_sales_data_index3", columnList = "sales_org_code"),
        @Index(name = "tpm_daily_sales_data_index4", columnList = "channel_code"),
        @Index(name = "tpm_daily_sales_data_index5", columnList = "service_code"),
})
@ApiModel(value = "TpmSapDaySalesEntity", description = "分子公司日销售报表")
@org.hibernate.annotations.Table(appliesTo = "tpm_sap_day_sales", comment = "分子公司日销售报表")
public class TpmSapDaySalesEntity extends TenantFlagOpEntity {

    /**
     * 产品组
     * (例：常温、奶酪)
     */
    @ApiModelProperty("业态")
    @Column(name = "spart_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String spartCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售机构编码'")
    private String salesOrgCode;
    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_org", length = 32, columnDefinition = "varchar(32) COMMENT '销售机构名称'")
    private String salesOrg;
    /**
     * 分销渠道编码
     */
    @ApiModelProperty("分销渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道编码'")
    private String channelCode;
    /**
     * 分销渠道名称
     */
    @ApiModelProperty("分销渠道名称")
    @Column(name = "channel_name", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道名称'")
    private String channelName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    @Column(name = "dealer_code", length = 32, columnDefinition = "varchar(32) COMMENT '售达方编码'")
    private String dealerCode;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    @Column(name = "dealer_name", length = 255, columnDefinition = "varchar(255) COMMENT '售达方名称'")
    private String dealerName;

    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    @Column(name = "service_code", length = 32, columnDefinition = "varchar(32) COMMENT '送达方编码'")
    private String serviceCode;
    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    @Column(name = "service_name", length = 255, columnDefinition = "varchar(255) COMMENT '送达方名称'")
    private String serviceName;
    /**
     * 品牌
     */
    @ApiModelProperty(name = "品牌编码")
    @Column(name = "brand", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String brand;
    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称")
    @Column(name = "brand_txt", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品牌名称'")
    private String brandTxt;
    /**
     * 品类
     */
    @ApiModelProperty(name = "品类编码")
    @Column(name = "category_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码'")
    private String categoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty(name = "品类名称")
    @Column(name = "category", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品类名称'")
    private String category;
    /**
     * 品项
     */
    @ApiModelProperty(name = "品项编码")
    @Column(name = "item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码'")
    private String itemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty(name = "品项名称")
    @Column(name = "item", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品项名称'")
    private String item;
    /**
     * 物料编码
     * (产品编码(37码))
     */
    @ApiModelProperty("产品编码")
    @Column(name = "material_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String materialCode;

    /**
     * 物料描述
     * (产品名称)
     */
    @ApiModelProperty("产品名称")
    @Column(name = "material_name", length = 256, columnDefinition = "varchar(256) COMMENT '产品名称'")
    private String materialName;

    /**
     * 标准供货价
     */
    @ApiModelProperty("标准供货价")
    @Column(name = "order_rebate_regular_price", columnDefinition = "decimal(20,4) COMMENT '标准供货价'")
    private BigDecimal orderRebateRegularPrice;
    /**
     * 订单类型
     */
    @ApiModelProperty("订单类型")
    @Column(name = "sale_vou_type", length = 32, columnDefinition = "varchar(32) COMMENT '订单类型'")
    private String saleVouType;

    /**
     * 发货过账日期
     */
    @ApiModelProperty("发货过账日期")
    @Column(name = "shipping_account_date", length = 32, columnDefinition = "varchar(32) COMMENT '发货过账日期'")
    private String shippingAccountDate;

    /**
     * 交货单数量/基本单位
     */
    @ApiModelProperty("交货单数量/基本单位")
    @Column(name = "delivery_order_num", length = 32, columnDefinition = "varchar(32) COMMENT '交货单数量/基本单位'")
    private String deliveryOrderNum;

    /**
     * 交货单数量
     */
    @ApiModelProperty("交货单数量")
    @Column(name = "delivery_order_num1", length = 32, columnDefinition = "int(10) COMMENT '交货单数量'")
    private Integer deliveryOrderNum1;

    /**
     * 基本单位
     */
    @ApiModelProperty("基本单位")
    @Column(name = "basic_unit", length = 32, columnDefinition = "varchar(32) COMMENT '基本单位'")
    private String basicUnit;

    /**
     * 理论收入(折前含税)
     */
    @ApiModelProperty("理论收入(折前含税)")
    @Column(name = "income_tax_included", columnDefinition = "decimal(20,4) COMMENT '理论收入(折前含税)'")
    private BigDecimal incomeTaxIncluded;

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "decimal(20,4) COMMENT '税率'")
    private BigDecimal taxRate;

    /**
     * 理论收入(折前未税)
     */
    @ApiModelProperty("理论收入(折前未税)")
    @Column(name = "income_untaxed", columnDefinition = "decimal(20,4) COMMENT '理论收入(折前未税)'")
    private BigDecimal incomeUntaxed;

    /**
     * 到岸价
     */
    @ApiModelProperty("到岸价")
    @Column(name = "cost_and_freight", columnDefinition = "decimal(20,4) COMMENT '到岸价'")
    private BigDecimal costAndFreight;
    /**
     * 理论成本(折前含税)
     */
    @ApiModelProperty("理论成本(折前含税)")
    @Column(name = "cost_tax_included", columnDefinition = "decimal(20,4) COMMENT '理论成本(折前含税)'")
    private BigDecimal costTaxIncluded;

    /**
     * 实际收入(折后含税)
     */
    @ApiModelProperty("实际收入(折后含税)")
    @Column(name = "invoice_amt", columnDefinition = "decimal(20,4) COMMENT '实际收入(折后含税)'")
    private BigDecimal invoiceAmt;

    /**
     * 发票税金额
     */
    @ApiModelProperty("发票税金额")
    @Column(name = "invoice_tax_amt", columnDefinition = "decimal(20,4) COMMENT '发票税金额'")
    private BigDecimal invoiceTaxAmt;
    /**
     * 实际收入(折后不含税)
     */
    @ApiModelProperty("实际收入(折后不含税)")
    @Column(name = "invoice_after_tax", columnDefinition = "decimal(20,4) COMMENT '实际收入(折后不含税)'")
    private BigDecimal invoiceAfterTax;
    /**
     * 交货单发出重量(毛重)
     */
    @ApiModelProperty("交货单发出重量(毛重)")
    @Column(name = "delivery_order_weight", columnDefinition = "decimal(20,4) COMMENT '交货单发出重量(毛重)'")
    private BigDecimal deliveryOrderWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    @Column(name = "weight", length = 32, columnDefinition = "varchar(32) COMMENT '重量单位'")
    private String weight;
    /**
     * 时间分区
     */
    @ApiModelProperty("时间分区")
    @Column(name = "ds", length = 16, columnDefinition = "varchar(16) COMMENT '时间分区'")
    private String ds;
    /**
     * 发票状态
     */
    @Column(name = "invoice_status", length = 32, columnDefinition = "varchar(32) COMMENT '发票状态'")
    private String invoiceStatus;
    @ApiModelProperty("订单常规价格(ZP01)")
    private BigDecimal orderRegularPrice;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty(value = "salesRegionCode", name = "销售部门编码", notes = "销售部门编码")
    @Column(name = "sales_region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码'")
    private String salesRegionCode;

    @ApiModelProperty(value = "salesRegionName", name = "销售部门名称", notes = "销售部门名称")
    @Column(name = "sales_region_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售部门名称'")
    private String salesRegionName;

    @ApiModelProperty(value = "salesRegionErpCode", name = "销售部门erp编码", notes = "销售部门erp编码")
    @Column(name = "sales_region_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门erp编码'")
    private String salesRegionErpCode;

    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "tpm_sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String tpmSalesOrgCode;

    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String salesOrgName;

    @ApiModelProperty("销售组织erp编码")
    @Column(name = "sales_org_erp_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '销售组织erp编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("年月")
    @Column(name = "year_month_ly", length = 10, nullable = true, columnDefinition = "varchar(64) COMMENT '年月'")
    private String yearMonthLy;

}
