package com.biz.crm.tpm.business.daily.sales.data.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.daily.sales.data.local.entity.TpmSapDaySalesEntity;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesExamineCircularSearchDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesExamineCircularSearchVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**
 * 分子公司日销售
 *
 * @author hd
 */
public interface TpmSapDaySalesMapper extends BaseMapper<TpmSapDaySalesEntity> {
    /**
     * 根据id查询
     *
     * @param list
     * @return
     */
    List<String> getByIds(@Param("list") List<String> list);

    /**
     * 考核通报管理查询分摊数据
     *
     * @param dto
     * @return
     */
    List<TpmSapDaySalesExamineCircularSearchVo> findExamineCircularDataList(@Param("dto") TpmSapDaySalesExamineCircularSearchDto dto);

    List<TpmSapDaySalesVo> findListByCondition(@Param("dto") TpmSapDaySalesDto dto);

    long findTotalByCondition(@Param("dto") TpmSapDaySalesDto dto);

    Page<TpmSapDaySalesVo> findPageByCondition(@Param("page") Page<TpmSapDaySalesVo> page,@Param("dto") TpmSapDaySalesDto dto);

    /**
     * 批量保存日销售数据
     *
     * @param saveList
     */
    void saveBatchData(@Param("saveList") Collection<TpmSapDaySalesEntity> saveList);

    List<TpmSapDaySalesVo> listForVariable(@Param("dto") TpmSapDaySalesDto dto);

    List<TpmSapDaySalesVo> findListByCondition2(@Param("dtos") List<TpmSapDaySalesDto> dtos);

    List<TpmSapDaySalesVo> findListForSubSaleMonitor(@Param("list") List<TpmSapDaySalesDto> dtos);

    List<TpmSapDaySalesVo> findListForSaleAndFeeMonitoring(@Param("list") List<TpmSapDaySalesDto> dtos);

    Page<TpmSapDaySalesVo> findPageItemForSonCompanyBudgetWarn(@Param("page") Page<TpmSapDaySalesVo> page,@Param("list") List<String> yearMonthList,@Param("orgCode") String orgCode,@Param("saleCompanyCode") String saleCompanyCode,@Param("channelCode") String channelCode,@Param("saleGroupCode") String saleGroupCode,@Param("customerCode") String customerCode,@Param("budgetItemCode") String budgetItemCode);
}
