package com.biz.crm.tpm.business.daily.sales.data.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author hd
 * @create 2023-02-06 15:01:38
 * @description：日销售数据
 */
@Component
@Slf4j
public class TpmDailySalesDataRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_daily_sales_data_data_view";
    }

    @Override
    public String desc() {
        return "TPM-主体销售日报表";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_daily_sales_data t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode()+"'";
    }
}
