package com.biz.crm.tpm.business.daily.sales.data.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.daily.sales.data.local.entity.TpmDailySalesDataEntity;
import com.biz.crm.tpm.business.daily.sales.data.local.mapper.TpmDailySalesDataMapper;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataTotalDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataTotalVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;


/**
 * 日销售数据(TpmDailySalesData)表数据库访问层
 *
 * @author hd
 * @create 2023-02-06 15:01:38
 */
@Component
public class TpmDailySalesDataRepository extends ServiceImpl<TpmDailySalesDataMapper, TpmDailySalesDataEntity> {
    @Autowired(required = false)
    private TpmDailySalesDataMapper tpmDailySalesDataMapper;

    /**
     * 查询存在数据
     *
     * @param verifyCodeList
     * @return
     */
    public List<TpmDailySalesDataEntity> findByVerifyCodes(List<String> verifyCodeList) {
        if (CollectionUtils.isEmpty(verifyCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(TpmDailySalesDataEntity::getVerifyCode, verifyCodeList)
                .eq(TpmDailySalesDataEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 批量存储数据
     *
     * @param sapEntities
     */
    public void saveBatchData(Collection<TpmDailySalesDataEntity> sapEntities) {
        tpmDailySalesDataMapper.saveBatchData(sapEntities);
    }

    /**
     * 根据条件统计 订单数量，单价*订单数量
     *
     * @param dto 参数
     * @return TpmDailySalesDataTotalVo
     */
    public TpmDailySalesDataTotalVo statisticsByCondition(TpmDailySalesDataTotalDto dto) {
        return this.tpmDailySalesDataMapper.statisticsByCondition(dto, TenantUtils.getTenantCode());
    }
    public List<TpmDailySalesDataVo> statisticsListByCondition(TpmDailySalesDataTotalDto dto) {
        return this.tpmDailySalesDataMapper.statisticsListByCondition(dto, TenantUtils.getTenantCode());
    }
    public List<TpmDailySalesDataVo> afterDiscountAmtByCondition(TpmDailySalesDataTotalDto dto) {
        return this.tpmDailySalesDataMapper.afterDiscountAmtByCondition(dto, TenantUtils.getTenantCode());
    }

    public List<TpmDailySalesDataVo> findByCondition(TpmDailySalesDataTotalDto dto) {
        return this.tpmDailySalesDataMapper.findByCondition(dto, TenantUtils.getTenantCode());
    }
}
