package com.biz.crm.tpm.business.daily.sales.data.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.daily.sales.data.local.entity.TpmSapDaySalesEntity;
import com.biz.crm.tpm.business.daily.sales.data.local.mapper.TpmSapDaySalesMapper;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 分子公司日销售
 *
 * @author hd
 */
@Component
public class TpmSapDaySalesRepository extends ServiceImpl<TpmSapDaySalesMapper, TpmSapDaySalesEntity> {
    @Autowired(required = false)
    private TpmSapDaySalesMapper tpmSapDaySalesMapper;

    public List<String> getByIds(List<String> list) {
        if (CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        return tpmSapDaySalesMapper.getByIds(list);
    }

    public List<TpmSapDaySalesVo> findListByCondition(TpmSapDaySalesDto dto) {

        return tpmSapDaySalesMapper.findListByCondition(dto);
    }

    public long findTotalByCondition(TpmSapDaySalesDto dto) {
        if(dto == null){
            return 0;
        }
        return this.getBaseMapper().findTotalByCondition(dto);
    }

    public Page<TpmSapDaySalesVo> findPageByCondition(Page<TpmSapDaySalesVo> page, TpmSapDaySalesDto dto) {
        if(Objects.isNull(dto)){
            return new Page<>();
        }
        return this.getBaseMapper().findPageByCondition(page,dto);
    }
    /**
     * 批量保存日销售数据
     *
     * @param saveBatchData
     */
    public void saveBatchData(Collection<TpmSapDaySalesEntity> saveBatchData) {
        tpmSapDaySalesMapper.saveBatchData(saveBatchData);
    }

    public List<TpmSapDaySalesVo> listForVariable(TpmSapDaySalesDto dto) {
        return tpmSapDaySalesMapper.listForVariable(dto);
    }

    public List<TpmSapDaySalesVo> findListByCondition2(List<TpmSapDaySalesDto> dtos) {
        if(CollectionUtils.isEmpty(dtos)){
            return Lists.newArrayList();
        }
        return tpmSapDaySalesMapper.findListByCondition2(dtos);
    }

    public List<TpmSapDaySalesVo> findListForSubSaleMonitor(List<TpmSapDaySalesDto> dtos) {
        if(CollectionUtils.isEmpty(dtos)){
            return Lists.newArrayList();
        }
        return tpmSapDaySalesMapper.findListForSubSaleMonitor(dtos);
    }

    public List<TpmSapDaySalesVo> findListForSaleAndFeeMonitoring(List<TpmSapDaySalesDto> dtos) {
        if(CollectionUtils.isEmpty(dtos)){
            return Lists.newArrayList();
        }
        return tpmSapDaySalesMapper.findListForSaleAndFeeMonitoring(dtos);
    }

    public Page<TpmSapDaySalesVo> findPageItemForSonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<TpmSapDaySalesVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if(CollectionUtils.isEmpty(yearMonthList)){
            return page;
        }
        return this.baseMapper.findPageItemForSonCompanyBudgetWarn(page,yearMonthList,orgCode,saleCompanyCode,channelCode,saleGroupCode,customerCode,budgetItemCode);
    }
}
