package com.biz.crm.tpm.business.daily.sales.data.local.service.internal;

import com.biz.crm.tpm.business.daily.sales.data.local.entity.TpmDailySalesDataEntity;
import com.biz.crm.tpm.business.daily.sales.data.local.repository.TpmDailySalesDataRepository;
import com.biz.crm.tpm.business.daily.sales.data.local.service.TpmDailySalesDataTransService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;

@Service("tpmDailySalesDataTransService")
public class TpmDailySalesDataTransServiceImpl implements TpmDailySalesDataTransService {
    @Autowired(required = false)
    private TpmDailySalesDataRepository tpmDailySalesDataRepository;

    /**
     * 批量保存日销售数据
     *
     * @param sapEntities
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveBatchData(Collection<TpmDailySalesDataEntity> sapEntities) {
        if (CollectionUtils.isEmpty(sapEntities) || sapEntities.size() == 0) {
            return;
        }
        tpmDailySalesDataRepository.saveBatchData(sapEntities);
    }
}
