package com.biz.crm.tpm.business.daily.sales.data.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.google.common.collect.Maps;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapDto;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditSapVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.daily.sales.data.local.entity.TpmSapDaySalesEntity;
import com.biz.crm.tpm.business.daily.sales.data.local.mapper.TpmSapDaySalesMapper;
import com.biz.crm.tpm.business.daily.sales.data.local.repository.TpmSapDaySalesRepository;
import com.biz.crm.tpm.business.daily.sales.data.local.service.TpmSapDaySalesTransService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.constant.DailySalesDataConstant;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesExamineCircularSearchDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesExamineCircularSearchVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分子公司日销售
 *
 * @author hd
 */
@Slf4j
@Service("tpmSapDaySalesService")
public class TpmSapDaySalesServiceImpl implements TpmSapDaySalesService {

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private AuditSapVoService auditSapVoService;
    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private TpmSapDaySalesTransService tpmSapDaySalesTransService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private TpmSapDaySalesRepository tpmSapDaySalesRepository;
    @Autowired(required = false)
    private TpmSapDaySalesMapper tpmSapDaySalesMapper;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private LoginUserService loginUserService;
    @Autowired(required = false)
    private RedisService redisService;
    @Autowired(required = false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required = false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    @Override
    @Transactional(propagation = Propagation.NOT_SUPPORTED, rollbackFor = Exception.class)
    public void synchronizationSap(String ds) {
        if (StringUtils.isEmpty(ds)) {
            ds = this.defaultDate();
        }
        if (!DateUtil.isDate(ds, DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH)) {
            log.error("=====>    同步KMS[{}]105数据时,时间格式不合法    <=====", ds);
            return;
        }
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
        log.info("=====>    同步KMS[{}]105数据 start    <=====", ds);
        List<DictDataVo> dictData = dictDataVoService.findByDictTypeCode(DailySalesDataConstant.SAP_SALE_VOU_TYPE);
        Validate.notEmpty(dictData, "同步日销售数据的订单类型的数据字典未配置!");
        List<String> saleVouTypeList = dictData.stream().map(DictDataVo::getDictCode)
                .collect(Collectors.toList());
        AuditSapDto dto = new AuditSapDto();
        dto.setCodeList(saleVouTypeList);
        dto.setDs(ds);
        Pageable pageable = PageRequest.of(1, 1000);
        log.info("=====>    查询105参数页码[{}]每页大小[{}][{}]    <=====", pageable.getPageNumber(),
                pageable.getPageSize(), JSON.toJSONString(dto));
        Page<AuditSapVo> pageResult = auditSapVoService.findByConditions(pageable, dto);
        log.info("=====>    查询到105结果[{}/{}][{}]条    <=====", pageResult.getCurrent(), pageResult.getPages(), pageResult.getSize());
        buildAndSaveData(pageResult.getRecords(), loginUser);
        while (pageResult.hasNext()) {
            pageable = PageRequest.of(pageable.getPageNumber() + 1, pageable.getPageSize());
            log.info("=====>    查询105参数页码[{}]每页大小[{}][{}]    <=====", pageable.getPageNumber(),
                    pageable.getPageSize(), JSON.toJSONString(dto));
            pageResult = auditSapVoService.findByConditions(pageable, dto);
            log.info("=====>    查询到105结果[{}/{}][{}]条    <=====", pageResult.getCurrent(), pageResult.getPages(), pageResult.getSize());
            if (CollectionUtils.isEmpty(pageResult.getRecords())) {
                log.info("=====>    同步KMS[{}]105数据 end    <=====", ds);
                return;
            }
            buildAndSaveData(pageResult.getRecords(), loginUser);
        }
        log.info("=====>    同步KMS[{}]105数据 end    <=====", ds);
    }

    /**
     * 构建并保存数据
     *
     * @param list
     */
    private void buildAndSaveData(List<AuditSapVo> list, AbstractCrmUserIdentity loginUser) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        Collection<TpmSapDaySalesEntity> tpmSapDaySalesEntities = nebulaToolkitService.copyCollectionByWhiteList(list, AuditSapVo.class, TpmSapDaySalesEntity.class, HashSet.class, ArrayList.class);
        this.buildDataList(tpmSapDaySalesEntities, loginUser);
        tpmSapDaySalesTransService.saveBatchData(tpmSapDaySalesEntities);
    }

    @Override
    public List<TpmSapDaySalesVo> findListByCondition(TpmSapDaySalesDto dto) {

        if (Objects.nonNull(dto)) {
            return Lists.newArrayList();
        }
        return tpmSapDaySalesRepository.findListByCondition(dto);
    }

    @Override
    public long findTotalByCondition(TpmSapDaySalesDto dto) {
        if (Objects.isNull(dto)) {
            return 0;
        }
        return tpmSapDaySalesRepository.findTotalByCondition(dto);
    }

    @Override
    public Page<TpmSapDaySalesVo> findPageByCondition(Page<TpmSapDaySalesVo> page, TpmSapDaySalesDto dto) {
        if (Objects.isNull(dto)) {
            return new Page<>();
        }
        return tpmSapDaySalesRepository.findPageByCondition(page, dto);
    }

    /**
     * 数据转换保存
     *
     * @param condition
     * @return
     */
    private void buildDataList(Collection<TpmSapDaySalesEntity> condition, AbstractCrmUserIdentity loginUser) {
        Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(condition)) {
            List<String> salesOrgCodes = condition.stream().map(TpmSapDaySalesEntity::getSalesOrgCode).distinct().collect(Collectors.toList());
            List<SalesOrgSubComOrgVo> salesOrgList = salesOrgSubComOrgService.listBySalesOrgCodeList(salesOrgCodes);
            if (CollectionUtils.isNotEmpty(salesOrgList)) {
                salesOrgSubComOrgMap = salesOrgList.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSalesOrgCode, Function.identity(), (v1, v2) -> v2));
            }
        }
        for (TpmSapDaySalesEntity sapVo : condition) {
            if (!CollectionUtil.isEmpty(salesOrgSubComOrgMap)) {
                SalesOrgSubComOrgVo salesOrgSubComOrgVo = salesOrgSubComOrgMap.get(sapVo.getSalesOrgCode());
                if (!Objects.isNull(salesOrgSubComOrgVo)) {
                    sapVo.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                    sapVo.setOrgName(salesOrgSubComOrgVo.getOrgName());
                }
            }
        }
        condition.forEach(sapVo -> {
            sapVo.setCreateName(loginUser.getRealName());
            sapVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            sapVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            // 理论收入(折前含税)
            String channelCode = sapVo.getChannelCode();
            BigDecimal orderRebateRegularPrice = sapVo.getOrderRegularPrice();
            Integer deliveryOrderNum = sapVo.getDeliveryOrderNum1();
            orderRebateRegularPrice = ObjectUtils.isEmpty(orderRebateRegularPrice) ? BigDecimal.ZERO : orderRebateRegularPrice.abs();
            BigDecimal orderNum = Objects.isNull(deliveryOrderNum) ? BigDecimal.ZERO : new BigDecimal(deliveryOrderNum);
            sapVo.setOrderRebateRegularPrice(orderRebateRegularPrice);
            BigDecimal decimal = orderRebateRegularPrice.multiply(orderNum).setScale(4, BigDecimal.ROUND_HALF_UP);
            sapVo.setIncomeTaxIncluded(decimal);
            String materialCode = sapVo.getMaterialCode();
            ProductQueryDto productQueryDto = new ProductQueryDto();
            productQueryDto.setProductCode(materialCode);
            List<ProductVo> byQueryDto = productVoService.findByQueryDto(productQueryDto);
            // 税率
            BigDecimal taxRate = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(byQueryDto) && byQueryDto.size() > 0) {
                ProductVo productVo = byQueryDto.get(0);
                if (ObjectUtils.isNotEmpty(productVo.getRate())) {
                    taxRate = productVo.getRate();
                }
                if (StringUtils.isEmpty(sapVo.getMaterialName())) {
                    sapVo.setMaterialName(productVo.getProductName());
                }
                sapVo.setBrand(productVo.getProductBrandCode());
                sapVo.setBrandTxt(productVo.getProductBrandName());
            }
            sapVo.setTaxRate(taxRate);
            // 理论收入(折前未税)
            sapVo.setIncomeUntaxed(decimal.divide(BigDecimal.ONE.add(taxRate).setScale(4, BigDecimal.ROUND_HALF_UP), 4, BigDecimal.ROUND_HALF_UP));
            //  到岸价  理论成本
            SearchPriceDto searchPriceDto = new SearchPriceDto();
            searchPriceDto.setPriceTypeCode(PriceTypeEnum.ZMN1.getDictCode());
            List<SearchPriceDimensionItemDto> list = new ArrayList<>(4);
            String spartCode = sapVo.getSpartCode();
            list.add(this.getParameter(PriceDimensionEnum.PRODUCT_GROUP.getDictCode(), spartCode));
            list.add(this.getParameter(PriceDimensionEnum.CHANNEL.getDictCode(), channelCode));
            list.add(this.getParameter(PriceDimensionEnum.PRODUCT.getDictCode(), materialCode));
            String salesOrgCode = sapVo.getSalesOrgCode();
            //询价以及找客户都应该使用mdg编码也就是未拼接过的编码
//            salesOrgCode = channelCode + spartCode + salesOrgCode;
            list.add(this.getParameter(PriceDimensionEnum.SALES_ORG_CODE.getDictCode(), salesOrgCode));
            List<SalesOrgSubComOrgVo> bySaleOrgErpCode = salesOrgSubComOrgService.findBySaleOrgErpCode(salesOrgCode);
            if (CollectionUtils.isNotEmpty(bySaleOrgErpCode) && bySaleOrgErpCode.size() > 0) {
                list.add(this.getParameter(PriceDimensionEnum.CUSTOMER.getDictCode(), bySaleOrgErpCode.get(0).getSubComOrgCode()));
            }
            searchPriceDto.setDimensionItems(list);
            log.info("=====>    查询到岸价参数[{}]    <=====", searchPriceDto.toString());
            Map<String, PriceModelVo> stringPriceModelVoMap = priceModelVoService.handleSearchPrice(searchPriceDto);
            if (ObjectUtils.isNotEmpty(stringPriceModelVoMap)) {
                log.info("=====>    查询到岸价结果[{}]    <=====", stringPriceModelVoMap.toString());
                PriceModelVo priceModelVo = stringPriceModelVoMap.get(materialCode);
                if (ObjectUtils.isNotEmpty(priceModelVo)) {
                    BigDecimal price = priceModelVo.getPrice();
                    price = ObjectUtils.isEmpty(price) ? BigDecimal.ZERO : price;
                    sapVo.setCostAndFreight(price);
                    sapVo.setCostTaxIncluded(price.multiply(orderNum).setScale(4, BigDecimal.ROUND_HALF_UP));
                }
            }
            // 实际收入(折后不含税)
            BigDecimal invoiceAmt = sapVo.getInvoiceAmt();
            invoiceAmt = ObjectUtils.isEmpty(invoiceAmt) ? BigDecimal.ZERO : invoiceAmt;
            BigDecimal invoiceTaxAmt = sapVo.getInvoiceTaxAmt();
            invoiceTaxAmt = ObjectUtils.isEmpty(invoiceTaxAmt) ? BigDecimal.ZERO : invoiceTaxAmt;
            sapVo.setInvoiceAfterTax(invoiceAmt.subtract(invoiceTaxAmt).setScale(4, BigDecimal.ROUND_HALF_UP));
            CustomerChannelVo byCode = customerChannelVoService.findByCode(channelCode);
            if (ObjectUtils.isNotEmpty(byCode)) {
                sapVo.setChannelName(byCode.getCustomerChannelName());
            }
            // 重量转换  吨
            sapVo.setWeight(DailySalesDataConstant.WEIGHT);
            BigDecimal deliveryOrderWeight = sapVo.getDeliveryOrderWeight();
            deliveryOrderWeight = ObjectUtils.isEmpty(deliveryOrderWeight) ? BigDecimal.ZERO : deliveryOrderWeight;
            sapVo.setDeliveryOrderWeight(deliveryOrderWeight.divide(new BigDecimal(DailySalesDataConstant.THOUSAND), 4, BigDecimal.ROUND_HALF_UP));
            sapVo.setCustomerCode(sapVo.getDealerCode() + sapVo.getSalesOrgCode() + sapVo.getChannelCode() + sapVo.getSpartCode());
            sapVo.setSalesInstitutionErpCode(sapVo.getSalesOrgCode());
            sapVo.setSalesInstitutionCode(sapVo.getChannelCode() + sapVo.getSpartCode() + sapVo.getSalesOrgCode());
        });
        setExtandInfo(condition);
    }



    private void setExtandInfo(Collection<TpmSapDaySalesEntity> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List<String> salesInstitutionCodeList = list.stream()
                .filter(item -> StringUtils.isNotEmpty(item.getSalesInstitutionCode()))
                .map(TpmSapDaySalesEntity::getSalesInstitutionCode)
                .distinct().collect(Collectors.toList());

        List<String> customerCodeList = list.stream()
                .filter(item -> StringUtils.isNotEmpty(item.getCustomerCode()))
                .map(TpmSapDaySalesEntity::getCustomerCode)
                .distinct().collect(Collectors.toList());

        Map<String, CustomerVo> customerVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(customerCodeList)) {
            List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(customerCodeList);
            if (CollectionUtil.isNotEmpty(customerVos)) {
                customerVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (n, o) -> n)));
            }

        }
        Map<String, SalesOrgVo> salesOrgVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(salesInstitutionCodeList)) {
            Map<String, SalesOrgVo> salesOrgMap = salesOrgVoService.getSalesMapByTpmCodes(salesInstitutionCodeList);
            if (CollectionUtil.isNotEmpty(salesOrgMap)) {
                salesOrgVoMap.putAll(salesOrgMap);
            }
        }

        for (TpmSapDaySalesEntity entity : list) {
            if (StringUtils.isNotEmpty(entity.getSalesInstitutionCode())) {
                SalesOrgVo salesOrgVo = salesOrgVoMap.get(entity.getSalesInstitutionCode());
                if (null != salesOrgVo) {
                    entity.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                }
            }
            if (StringUtils.isNotEmpty(entity.getCustomerCode())) {
                CustomerVo customerVo = customerVoMap.get(entity.getCustomerCode());
                if (null != customerVo) {
                    entity.setSalesRegionName(customerVo.getSalesRegionName());
                    entity.setSalesRegionCode(customerVo.getSalesRegionCode());
                    entity.setSalesRegionErpCode(customerVo.getSalesRegionErpCode());

                    entity.setSalesOrgName(customerVo.getSalesOrgName());
                    entity.setTpmSalesOrgCode(customerVo.getSalesOrgCode());
                    entity.setSalesOrgErpCode(customerVo.getSalesOrgErpCode());
                }
            }

        }
    }

    /**
     * 封装查询参数
     *
     * @param dictCode
     * @param spartCode
     * @return
     */
    private SearchPriceDimensionItemDto getParameter(String dictCode, String spartCode) {
        SearchPriceDimensionItemDto itemDto = new SearchPriceDimensionItemDto();
        itemDto.setDimensionCode(dictCode);
        Set<String> set = new HashSet<>(1);
        set.add(spartCode);
        itemDto.setRelateCodeSet(set);
        return itemDto;
    }

    /**
     * 获取前一天日期
     *
     * @return
     */
    private String defaultDate() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(Calendar.DATE, -1);
        String date = DateUtil.date_yyyyMMdd.format(ca.getTime());
        return date;
    }

    /**
     * 考核通报管理查询分摊数据
     *
     * @param dto
     * @return
     */
    @Override
    public List<TpmSapDaySalesExamineCircularSearchVo> findExamineCircularDataList(TpmSapDaySalesExamineCircularSearchDto dto, String cacheKey) {
        if (StringUtils.isNotEmpty(dto.getStartDate()) && StringUtils.isNotEmpty(dto.getEndDate())) {
            Validate.isTrue(StringUtils.equals(dto.getStartDate().substring(0, 7), dto.getEndDate().substring(0, 7)), "查询时间不能跨月！");
        }
        cacheKey = "TPM:EXAMINE_SALES_DATE_SPLIT:" + cacheKey;
        if (StringUtils.isNotEmpty(cacheKey)) {
            redisService.del(cacheKey);
        }
        if (StringUtils.isEmpty(dto.getBusinessFormatCode())
                || StringUtils.isEmpty(dto.getBusinessUnitCode())
                || StringUtils.isEmpty(dto.getSaleOrgCode())
                || StringUtils.isEmpty(dto.getCustomerCode())
                || StringUtils.isEmpty(dto.getStartDate())
                || StringUtils.isEmpty(dto.getEndDate())) {
            return Lists.newArrayList();
        }
        //用的MDG客户编码查询
        List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(Lists.newArrayList(dto.getCustomerCode()));
        Validate.notEmpty(customerVos, "客户编码[%s]客户信息不存在！", dto.getCustomerCode());

        //销售公司
        List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllParentBySalesOrgCode(dto.getSaleOrgCode());
        salesOrgVos = salesOrgVos.stream().filter(e -> StringUtils.equals(SalesOrgLevelTypeEnum.MECHANISM.getCode(), e.getSalesOrgLevel())).collect(Collectors.toList());
        Validate.notEmpty(salesOrgVos, "销售组织编码[%s]，未查询到销售公司！", dto.getSaleOrgCode());
        String companyCode = salesOrgVos.get(0).getErpCode();

        dto.setSaleOrgCode(companyCode);
        dto.setCustomerCode(customerVos.get(0).getErpCode());
        dto.setStartDate(dto.getStartDate().replaceAll("-", ""));
        dto.setEndDate(dto.getEndDate().replaceAll("-", ""));
        List<TpmSapDaySalesExamineCircularSearchVo> dataList = this.tpmSapDaySalesMapper.findExamineCircularDataList(dto);

        //数据处理
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(dataList)) {
            List<String> productCodeList = dataList.stream().map(TpmSapDaySalesExamineCircularSearchVo::getProductCode).distinct().collect(Collectors.toList());
            List<ProductVo> productVoList = productVoService.findMainDetailsByProductCodes(productCodeList);
            Map<String, ProductVo> productMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v2));

            for (TpmSapDaySalesExamineCircularSearchVo searchVo : dataList) {
                if (productMap.containsKey(searchVo.getProductCode())) {
                    ProductVo productVo = productMap.get(searchVo.getProductCode());
                    searchVo.setProductName(productVo.getProductName());
                    searchVo.setProductBrandCode(productVo.getProductBrandCode());
                    searchVo.setProductBrandName(productVo.getProductBrandName());
                    searchVo.setProductLevelCode(productVo.getProductCategoryCode());
                    searchVo.setProductLevelName(productVo.getProductCategoryName());
                    searchVo.setSubProductLevelCode(productVo.getProductLevelCode());
                    searchVo.setSubProductLevelName(productVo.getProductLevelName());
                }
                if (Objects.isNull(searchVo.getSplitAmount())) {
                    searchVo.setSplitAmount(BigDecimal.ZERO);
                }
            }
        }
        dataList = dataList.stream().filter(e -> Objects.nonNull(e.getSplitAmount()) && BigDecimal.ZERO.compareTo(e.getSplitAmount()) < 0).collect(Collectors.toList());
        //均摊计算用
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dataList) && StringUtils.isNotEmpty(cacheKey)) {
            Map<String, BigDecimal> map = dataList.stream().collect(Collectors.toMap(TpmSapDaySalesExamineCircularSearchVo::getProductCode, TpmSapDaySalesExamineCircularSearchVo::getSplitAmount, (v1, v2) -> v2));
            redisService.set(cacheKey, JSONObject.toJSONString(map), 60 * 60 * 12);
        }
        return dataList;
    }

    /**
     * 变量计算查询
     *
     * @param dto
     * @return
     */
    @Override
    public List<TpmSapDaySalesVo> listForVariable(TpmSapDaySalesDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        log.info("分子日销售报表=====》{}", JSONObject.toJSONString(dto));
        return tpmSapDaySalesRepository.listForVariable(dto);
    }

    @Override
    public List<TpmSapDaySalesVo> findListByCondition2(List<TpmSapDaySalesDto> dtos) {
        if(CollectionUtils.isEmpty(dtos)){
            return Lists.newArrayList();
        }
        return tpmSapDaySalesRepository.findListByCondition2(dtos);
    }

    @Override
    public List<TpmSapDaySalesVo> findListForSubSaleMonitor(List<TpmSapDaySalesDto> dtos) {
        if(CollectionUtils.isEmpty(dtos)){
            return Lists.newArrayList();
        }
        return tpmSapDaySalesRepository.findListForSubSaleMonitor(dtos);
    }

    @Override
    public List<TpmSapDaySalesVo> findListForSaleAndFeeMonitoring(List<TpmSapDaySalesDto> dtos) {
        if(CollectionUtils.isEmpty(dtos)){
            return Lists.newArrayList();
        }
        log.info("销售与费用进度报表查询分子日销售数据:dtos{}", JsonUtils.obj2JsonString(dtos));
        return tpmSapDaySalesRepository.findListForSaleAndFeeMonitoring(dtos);
    }

    @Override
    public Page<TpmSapDaySalesVo> findPageItemForSonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        if(org.springframework.util.CollectionUtils.isEmpty(yearMonthList)){
            return new Page<>(0,0);
        }
        return this.tpmSapDaySalesRepository.findPageItemForSonCompanyBudgetWarn(pageable,yearMonthList,orgCode,saleCompanyCode,channelCode,saleGroupCode,customerCode,budgetItemCode);
    }
}
