package com.biz.crm.tpm.business.deduction.detail.mapping.local.controller;


import com.biz.crm.tpm.business.deduction.detail.mapping.local.service.internal.TpmDeductionDetailMappingImportsProcess;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingImportsVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.LinkedHashMap;
import java.util.List;

/**
 * TPM-商超扣费明细映射表(TpmDeductionDetailMapping)表相关的http接口
 *
 * @author duyiran
 * @since 2022-11-07 19:04:47
 */
@RestController
@RequestMapping("/v1/tpmDeductionDetailMapping")
@Slf4j
@Api(tags = "TPM-商超扣费明细映射表")
public class TpmDeductionDetailMappingController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private TpmDeductionDetailMappingService tpmDeductionDetailMappingService;

    @Autowired(required = false)
    private TpmDeductionDetailMappingImportsProcess tpmDeductionDetailMappingImportsProcess;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据", notes = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmDeductionDetailMappingVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                      @ApiParam(name = "tpmDeductionDetailMapping", value = "TPM-商超扣费明细映射表") TpmDeductionDetailMappingDto dto) {
        try {
            Page<TpmDeductionDetailMappingVo> page = this.tpmDeductionDetailMappingService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("findById")
    @ApiOperation(value = "通过主键查询单条数据", notes = "通过主键查询单条数据")
    public Result<TpmDeductionDetailMappingVo> queryById(@RequestParam("id") String id) {
        try {
            return Result.ok(this.tpmDeductionDetailMappingService.queryById(id));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param dto dto对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<TpmDeductionDetailMappingVo> create(@ApiParam(name = "tpmDeductionDetailMapping", value = "TPM-商超扣费明细映射表") @RequestBody TpmDeductionDetailMappingDto dto) {
        try {
            TpmDeductionDetailMappingVo result = this.tpmDeductionDetailMappingService.create(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param dto dto对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<TpmDeductionDetailMappingVo> update(@ApiParam(name = "tpmDeductionDetailMapping", value = "TPM-商超扣费明细映射表") @RequestBody TpmDeductionDetailMappingDto dto) {
        try {
            TpmDeductionDetailMappingVo result = this.tpmDeductionDetailMappingService.update(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
        try {
            this.tpmDeductionDetailMappingService.delete(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @PostMapping("/testImport")
    public Result<?> testImport(@RequestBody LinkedHashMap<Integer, TpmDeductionDetailMappingImportsVo> data){
        this.tpmDeductionDetailMappingImportsProcess.execute(data,null,null);
        return Result.ok();
    }
}
