package com.biz.crm.tpm.business.deduction.detail.mapping.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 商超扣费明细映射表 实体
 *
 * @author duyiran
 * @create 2022-11-07 17:42
 */
@Data
@TableName("tpm_deduction_detail_mapping")
@Entity(name = "tpm_deduction_detail_mapping")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmDeductionDetailMapping", description = "TPM-商超扣费明细映射表")
@org.hibernate.annotations.Table(appliesTo = "tpm_deduction_detail_mapping", comment = "TPM-商超扣费明细映射表")
@Table(name = "tpm_deduction_detail_mapping", indexes = {@Index(name = "tpm_deduction_detail_mapping_index1", columnList = "tenant_code, code", unique = true)})
public class TpmDeductionDetailMapping extends TenantFlagOpEntity {

    /**
     * 商超扣费明细映射表编码
     */
    @ApiModelProperty(name = "商超扣费明细映射表编码", notes = "商超扣费明细映射表编码")
    @Column(name = "code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商超扣费明细映射表编码'")
    private String code;

    /**
     * 商超扣费明细映射表名称
     */
    @ApiModelProperty(name = "商超扣费明细映射表名称", notes = "商超扣费明细映射表名称")
    @Column(name = "name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '商超扣费明细映射表名称'")
    private String name;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format]'")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit]'")
    private String businessUnitCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    /**
     * 销售组织erp编码
     */
    @ApiModelProperty(name = "销售组织erp编码", notes = "销售组织erp编码")
    @Column(name = "sales_org_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织erp编码'")
    private String salesOrgErpCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售组织名称 '")
    private String salesOrgName;

    /**
     * 零售商
     */
    @ApiModelProperty(name = "零售商", notes = "零售商")
    @Column(name = "resale_commercial_code", length = 32,columnDefinition = "VARCHAR(32) COMMENT '零售商'")
    private String resaleCommercialCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    @Column(name = "resale_commercial_name", columnDefinition = "VARCHAR(255) COMMENT '零售商名称'")
    private String resaleCommercialName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    /************************************ 新增字段 03/15 **************************************************/

    /**
     * 销售机构名称
     */
    @ApiModelProperty(name = "salesInstitutionName",value = "销售机构名称",notes = "销售机构名称")
    @Column(name = "sales_institution_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 销售机构ERP编码
     */
    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构ERP编码",notes = "销售机构ERP编码")
    @Column(name = "sales_institution_erp_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码",notes = "销售机构编码")
    @Column(name = "sales_institution_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 核销方式
     */
    @ApiModelProperty(name = "auditType",value = "核销方式",notes = "核销方式")
    @Column(name = "audit_type",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销方式'")
    private String auditType;

    /**
     * 渠道编码
     */
    @ApiModelProperty(name = "channelCode",value = "渠道编码",notes = "渠道编码")
    @Column(name = "channel_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(name = "channelCode",value = "渠道名称",notes = "渠道名称")
    @Column(name = "channel_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '渠道名称'")
    private String channelName;

    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code", length = 128, columnDefinition = "varchar(128) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;

    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    @Column(name = "second_channel_code", length = 128, columnDefinition = "varchar(128) COMMENT '二级管理渠道编码'")
    private String secondChannelCode;

    /**
     * 购买方式
     */
    @ApiModelProperty(name = "buyWay",value = "购买方式",notes = "购买方式")
    @Column(name = "buy_way",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '购买方式'")
    private String buyWay;


}
