package com.biz.crm.tpm.business.deduction.detail.mapping.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 数据视图注册器
 * 基于nebula的数据视图提供列表查询功能
 *
 * @author duyiran
 * @create 2022-11-07 20:01
 */
@Component
@Slf4j
public class TpmDeductionDetailMappingRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_deduction_detail_mapping_data_view";
    }

    @Override
    public String desc() {
        return "TPM-商超扣费明细映射表";
    }

    @Override
    public String buildSql() {
        return "select " +
                "t.*, " +
                "group_concat(distinct t1.text) as text, " +
                "group_concat(distinct t2.activity_form_name) as activity_form, " +
                "group_concat(distinct t2.activity_type_name) as activity_type, " +
                "group_concat(distinct t3.erp_code) as customer_code, " +
                "group_concat(distinct t3.customer_name) as customer_name " +
                "from " +
                "tpm_deduction_detail_mapping t " +
                "left join tpm_deduction_detail_mapping_text t1 on t.code = t1.code " +
                "left join tpm_deduction_detail_mapping_relation_activity_config t2 on t.code = t2.code " +
                "left join tpm_deduction_detail_mapping_customer t3 on t.code = t3.code " +
                "where t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "and t.tenant_code = :tenantCode " +
                "group by t.code, t.id, t.create_account, t.create_name, t.create_time, t.modify_account, t.modify_name, t.modify_time, t.del_flag, t.enable_status, t.remark, t.tenant_code, t.activity_form_code, t.activity_form_name, t.business_format_code, t.business_unit_code, t.name, t.resale_commercial_code, t.resale_commercial_name, t.sales_org_code, t.sales_org_name ";

    }

}
