package com.biz.crm.tpm.business.deduction.detail.mapping.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.entity.TpmDeductionDetailMapping;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.mapper.TpmDeductionDetailMappingMapper;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;


/**
 * TPM-商超扣费明细映射表(TpmDeductionDetailMapping)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-07 19:04:49
 */
@Component
public class TpmDeductionDetailMappingRepository extends ServiceImpl<TpmDeductionDetailMappingMapper, TpmDeductionDetailMapping> {

    @Autowired(required = false)
    private TpmDeductionDetailMappingMapper tpmDeductionDetailMappingMapper;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return 全部数据
     */
    public Page<TpmDeductionDetailMappingVo> findByConditions(Pageable pageable, TpmDeductionDetailMappingDto dto) {
        Page<TpmDeductionDetailMappingVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmDeductionDetailMappingVo> pageList = this.tpmDeductionDetailMappingMapper.findByConditions(page, dto);
        return pageList;
    }

    /**
     * 根据编码查询数据
     *
     * @param codeList   codeList
     * @param tenantCode 租户编号
     * @return 全部数据
     */
    public List<TpmDeductionDetailMappingVo> findByCodes(List<String> codeList, String tenantCode) {
        return this.tpmDeductionDetailMappingMapper.findByCodes(codeList, tenantCode);
    }

    public TpmDeductionDetailMapping findByCode(String applyMappingCode) {
        return this.lambdaQuery().eq(TpmDeductionDetailMapping::getCode, applyMappingCode)
                .eq(TpmDeductionDetailMapping::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDeductionDetailMapping::getTenantCode, TenantUtils.getTenantCode()).one();
    }

    public List<TpmDeductionDetailMapping> findByDto(TpmDeductionDetailMappingDto dto) {
        if (Objects.isNull(dto)) {
            dto = new TpmDeductionDetailMappingDto();
        }
        return this.tpmDeductionDetailMappingMapper.findByDto(dto, TenantUtils.getTenantCode());
    }

}

