package com.biz.crm.tpm.business.deduction.detail.mapping.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.entity.TpmDeductionDetailMappingText;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.mapper.TpmDeductionDetailMappingTextMapper;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingTextVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/1 21:24
 * @description：商超扣费映射文本
 */
@Component
public class TpmDeductionDetailMappingTextRepository extends ServiceImpl<TpmDeductionDetailMappingTextMapper, TpmDeductionDetailMappingText> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据编码查询数据
     *
     * @param codeList   codeList
     * @param tenantCode 租户编号
     * @return 全部数据
     */
    public List<TpmDeductionDetailMappingTextVo> findByCodes(List<String> codeList, String tenantCode) {
        List<TpmDeductionDetailMappingText> textList = this.lambdaQuery()
                .eq(TpmDeductionDetailMappingText::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDeductionDetailMappingText::getTenantCode, tenantCode)
                .in(TpmDeductionDetailMappingText::getCode, codeList)
                .list();
        Collection<TpmDeductionDetailMappingTextVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(textList, TpmDeductionDetailMappingText.class, TpmDeductionDetailMappingTextVo.class, LinkedHashSet.class, ArrayList.class);
        return Lists.newArrayList(vos);
    }

}
