package com.biz.crm.tpm.business.distribution.fees.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.distribution.fees.feign.feign.internal.DistributionFeesFeignFallbackImpl;
import com.biz.crm.tpm.business.distribution.fees.sdk.dto.DistributionFeesDto;
import com.biz.crm.tpm.business.distribution.fees.sdk.service.DistributionFeesService;
import com.biz.crm.tpm.business.distribution.fees.sdk.vo.DistributionFeesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author xiaoyoujun
 * @date 2022年12月2日 17:20
 */
@FeignClient(
        name = "${feign.urlip:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = DistributionFeesFeignFallbackImpl.class)
public interface DistributionFeesFeign {


    /**
     * 分页查询所有数据
     *
     * @param distributionFeesDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByDistributions")
    public Result<Page<DistributionFeesVo>> findByDistributions(@RequestParam("page") Integer page,
                                                                @RequestParam("size") Integer size,
                                                                @SpringQueryMap DistributionFeesDto distributionFeesDto);

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @DeleteMapping("delete")
    public Result<?> delete(@RequestParam("ids") List<String> ids);


}