package com.biz.crm.tpm.business.distribution.fees.feign.feign.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.distribution.fees.feign.feign.DistributionFeesFeign;
import com.biz.crm.tpm.business.distribution.fees.sdk.dto.DistributionFeesDto;
import com.biz.crm.tpm.business.distribution.fees.sdk.vo.DistributionFeesVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 分销客户投放费用表feign接口熔断类
 *
 * @author: xiaoyoujun
 * @date: 2022.12.2
 */
@Slf4j
@Component
public class DistributionFeesFeignFallbackImpl implements FallbackFactory<DistributionFeesFeign> {
    @Override
    public DistributionFeesFeign create(Throwable cause) {
        return new DistributionFeesFeign() {
            @Override
            public Result<Page<DistributionFeesVo>> findByDistributions(Integer page, Integer size, DistributionFeesDto distributionFeesDto) {
                throw new UnsupportedOperationException("根据分页信息获取数据熔断");
            }

            @Override
            public Result<?> delete(List<String> ids) {
                throw new UnsupportedOperationException("删除数据熔断");
            }
        };
    }
}
