package com.biz.crm.tpm.business.distribution.fees.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.distribution.fees.feign.feign.DistributionFeesFeign;
import com.biz.crm.tpm.business.distribution.fees.sdk.dto.DistributionFeesDto;
import com.biz.crm.tpm.business.distribution.fees.sdk.service.DistributionFeesService;
import com.biz.crm.tpm.business.distribution.fees.sdk.vo.DistributionFeesVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.util.*;

/**
 * 分销客户人员工资表(DistributionFeesEntity)表服务实现类
 *
 * @author youjun
 * @date 2022年11月14日 14:16
 */
@Service("distributionFeesService")
public class DistributionFeesServiceImpl implements DistributionFeesService {

    @Autowired(required = false)
    private DistributionFeesFeign distributionFeesFeign;


    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param distributionFeesDto 实体对象
     * @return
     */
    @Override
    public Page<DistributionFeesVo> findByDistributions(Pageable pageable, DistributionFeesDto distributionFeesDto) {
        Result<Page<DistributionFeesVo>> result = this.distributionFeesFeign.findByDistributions(pageable.getPageNumber(), pageable.getPageSize(), distributionFeesDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 删除数据
     * @param ids 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "删除数据时，主键集合不能为空！");
        this.distributionFeesFeign.delete(ids);
    }

    /**
     * 批量导入新增
     * @param importList
     * @return 批量导入新增
     */
    @Override
    public void importSave(List<DistributionFeesDto> importList) {
        throw new UnsupportedOperationException();
    }


}
