package com.biz.crm.tpm.business.event.prepayment.local.constant;


/**
 * 预付编码常量
 *
 * @author : youjun
 * @date : 2022-11-17
 */
public interface EventPrepaymentConstant {

    /**
     * 预付编码前缀
     */
    String EVENT_PREPAYMENT_CODE = "YF";
    /**
     * 预付信息编码前缀
     */
    String MATERIAL_INFORMATION_CODE = "MI";
    /**
     * processKey
     */
    String EVENT_PREPAYMENT_PROCESS = "event_prepayment_process";

    String LOCK_EVENT_PREPAYMENT_APPROVE = "event_prepayment:lock:approve:";


    /**
     * 核销费用上账
     */
    public static final String AUDIT_FEE_UP_ACCOUNT = "SI_TPM70_EXPENSES_HQ_ASYN_OUT";

    /**
     * 核销费用上账分子公司
     */
    public static final String AUDIT_FEE_UP_ACCOUNT_SON = "SI_TPM80_HXFYSZ_FGS_ASYN_OUT";


    /**
     * 活动预付推送数据TOPIC
     */
    String TPM_EVENT_PRE_PAYMENT_PUSH_DATA_TOPIC = "TPM_EVENT_PRE_PAYMENT_PUSH_DATA_TOPIC";

    /**
     * 活动预付推送数据TAG
     */
    String TPM_EVENT_PRE_PAYMENT_PUSH_DATA_TAG = "TPM_EVENT_PRE_PAYMENT_PUSH_DATA_TAG";

    /**
     * 活动预付查询活动预付状态TOPIC
     */
    String TPM_EVENT_PRE_PAYMENT_QUERY_DATA_TOPIC = "TPM_EVENT_PRE_PAYMENT_QUERY_DATA_TOPIC";

    /**
     * 活动预付查询活动预付状态TAG
     */
    String TPM_EVENT_PRE_PAYMENT_QUERY_DATA_TAG = "TPM_EVENT_PRE_PAYMENT_QUERY_DATA_TAG";

    /**
     * 发送者
     */
    String SENDER = "TPM";

    /**
     * 接受者
     */
    String RECEIVER = "ECC";

    /**
     * 核销单类型
     */
    String ZFHXDLX = "ZSC1";

    /**
     * 批复类型
     */
    String ZFLAG = "A";

    /**
     * 货币码
     */
    String WAERS = "CNY";


    /**
     * 数据来源 固定
     */
    String DATA_FROM = "4";

    /**
     * 利润中心前缀
     */
    String PROFIT_CENTER_PREFIX = "000000";

    /**
     * 业务大类 付款单固定
     */
    String TITLE = "300204";

    /**
     * 客商类型 付款单固定
     */
    String ACCOUNT_TYPE = "K";

    /**
     * 上账编码前缀
     */
    String AUDIT_UP_ACCOUNT_DETAIL_PREFIX = "Y";

    /**
     * 上账编码前缀
     */
    String AUDIT_CUSTOMER_PREPAYMENT_DETAIL_PREFIX = "CP";

    /**
     * 推送redis锁定
     */
    String EVENT_PREPAYMENT_PUSH_REDIS_LOCK = "EVENT:PREPAYMENT:PUSH:REDIS:LOCK:";

}
