package com.biz.crm.tpm.business.event.prepayment.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 *  活动预付管理 DataView
 *  * @author xiaoyoujun
 *  * @since 2022-11-21
 */
@Component
public class EventPrepaymentDateView implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_event_prepayment";
    }

    @Override
    public String desc() {
        return "TPM-活动预付管理";
    }

    @Override
    public String buildSql() {
        return "SELECT t.* FROM tpm_event_prepayment t" +
                "  WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' "+
                "  AND t.tenant_code = :tenantCode ";
    }
}
