package com.biz.crm.tpm.business.event.prepayment.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author youjun
 * @date 2022年11月17日 16:48
 */
@ApiModel(value = "CustomerPrepaymentEntity", description = "TPM-活动明细数据")
@TableName("tpm_customer_prepayment")
@Data
@Entity(name = "tpm_customer_prepayment")
@Table(name = "tpm_customer_prepayment", indexes = {
        @Index(name = "tpm_customer_prepayment_idx1", columnList = "activity_detail_item_code", unique = false),
        @Index(name = "tpm_customer_prepayment_idx2", columnList = "prepaid_coding", unique = false),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_customer_prepayment", comment = "TPM-活动明细数据")
public class CustomerPrepaymentEntity extends TenantFlagOpEntity {

    /**
     * 预付编码
     */
    @ApiModelProperty(name = "prepaidCoding",value = "预付编码",notes = "预付编码")
    @Column(name = "prepaid_coding", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付编码 '")
    private String prepaidCoding;
    /**
     * 活动细案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    @Column(name = "activity_detail_item_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '活动细案明细编码'")
    private String activityDetailItemCode;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @Column(name = "activity_begin_date", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动开始时间'")
    private String activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @Column(name = "activity_end_date", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动结束时间'")
    private String activityEndDate;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '客户编码'")
    private String customerCode;
    /**
     * 客户MDG编码
     */
    @ApiModelProperty("客户MDG编码")
    @Column(name = "customer_mdg_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户MDG编码'")
    private String customerMdgCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;
    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '门店编码'")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;
    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @Column(name = "audit_form", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '结案形式'")
    private String auditForm;
    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    @Column(name = "fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '申请金额'")
    private BigDecimal feeAmount;
    /**
     * 本次预付金额
     */
    @ApiModelProperty(name = "prepaidAmount",value = "本次预付金额",notes = "本次预付金额")
    @Column(name = "prepaid_amount", columnDefinition = "decimal(24,6) COMMENT '本次预付金额'")
    private BigDecimal prepaidAmount;

    /**
     * 已申请预付金额
     */
    @ApiModelProperty(name = "prepaidAmountApplied",value = "已申请预付金额",notes = "已申请预付金额")
    @Column(name = "prepaid_amount_applied", columnDefinition = "decimal(24,6) COMMENT '已申请预付金额'")
    private BigDecimal prepaidAmountApplied;
    /**
     * 系统
     */
    @ApiModelProperty(name = "systemName",value = "系统",notes = "系统")
    @Column(name = "system_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '系统 '")
    private String systemName;
    /**
     * 系统编码
     */
    @ApiModelProperty(name = "systemCode",value = "系统编码",notes = "系统编码")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码 '")
    private String systemCode;
    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "customerRetailerCode", notes = "零售商编码")
    @Column(name = "customer_retailer_code", columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String customerRetailerCode;
    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "customerRetailerName", notes = "零售商名称")
    @Column(name = "customer_retailer_name", columnDefinition = "varchar(256) COMMENT '零售商名称'")
    private String customerRetailerName;
    /**
     * 活动申请编码
     */
    @ApiModelProperty(name = "活动申请编码", notes = "活动申请编码")
    @Column(name = "activity_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动申请编码'")
    private String activityCode;
    /**
     * 活动申请名称
     */
    @ApiModelProperty(name = "活动申请名称", notes = "活动申请名称")
    @Column(name = "activity_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动申请名称'")
    private String activityName;
    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    @Column(name = "supplier_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码'")
    private String supplierCode;
    /**
     * 供应商
     */
    @ApiModelProperty(name = "supplierName",value = "供应商",notes = "供应商")
    @Column(name = "supplier_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '供应商 '")
    private String supplierName;
    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "salesOrgCode",value = "销售组织编码",notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "supplierName",value = "销售组织名称",notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 200, columnDefinition = "VARCHAR(200) COMMENT '销售组织名称 '")
    private String salesOrgName;
    /**
     * 区域
     */
    @ApiModelProperty(name = "region",value = "区域",notes = "区域")
    @Column(name = "region", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域 '")
    private String region;

    /**
     * 客户预付明细编码
     */
    @ApiModelProperty(name = "customerPrepaymentDetailCode",value = "客户预付明细编码",notes = "客户预付明细编码")
    @Column(name = "customer_prepayment_detail_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户预付明细编码'")
    private String customerPrepaymentDetailCode;

    /**
     * 总公司上账编码
     */
    @ApiModelProperty(name = "upAccountCode",value = "总公司上账编码",notes = "总公司上账编码")
    @Column(name = "up_account_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '总公司上账编码'")
    private String upAccountCode;

    /**
     * 上账状态
     */
    @ApiModelProperty(name = "sapCommitStatus",value = "上账状态",notes = "上账状态")
    @Column(name = "sap_commit_status", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '上账状态'")
    private String sapCommitStatus;

    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;
}
