package com.biz.crm.tpm.business.event.prepayment.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月15日 16:48
 */
@ApiModel(value = "EventPrepaymentEntity", description = "TPM-活动预付管理")
@TableName("tpm_event_prepayment")
@Data
@Entity(name = "tpm_event_prepayment")
@Table(
        name = "tpm_event_prepayment",
        indexes = {
                @Index(name = "tpm_event_prepayment_idx1", columnList = "prepaid_coding", unique = true),
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_event_prepayment", comment = "TPM-活动预付管理")
public class EventPrepaymentEntity extends TenantFlagOpEntity {

    /**
     * 审批状态
     */
    @ApiModelProperty(name = "processStatus",value = "审批状态",notes = "审批状态")
    @Column(name = "process_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批状态 '")
    private String processStatus;

    @ApiModelProperty("审批时间")
    @Column(name = "process_date", columnDefinition = "DATETIME COMMENT '审批时间'")
    private Date processDate;

    /**
     * 流程编码
     */
    @ApiModelProperty(name = "processInstanceId",value = "流程编码",notes = "流程编码")
    @Column(name = "process_instance_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '流程编码 '")
    private String processInstanceId;
    /**
     * 预付编码
     */
    @ApiModelProperty(name = "prepaidCoding",value = "预付编码",notes = "预付编码")
    @Column(name = "prepaid_coding", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付编码 '")
    private String prepaidCoding;
    /**
     * 返回单据编码
     */
    @ApiModelProperty(name = "returnDocCode",value = "返回单据编码",notes = "返回单据编码")
    @Column(name = "return_doc_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '返回单据编码 '")
    private String returnDocCode;
    /**
     * 预付类型
     */
    @ApiModelProperty(name = "prepaymentType",value = "预付类型",notes = "预付类型")
    @Column(name = "prepayment_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预付类型 '")
    private String prepaymentType;
    /**
     * 预付名称
     */
    @ApiModelProperty(name = "prepaymentName",value = "预付名称",notes = "预付名称")
    @Column(name = "prepayment_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预付名称 '")
    private String prepaymentName;
    /**
     * 预付年月
     */
    @ApiModelProperty(name = "prepaymentDate",value = "预付年月", notes = "预付年月")
    @Column(name = "prepayment_date", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付年月 '")
    private String prepaymentDate;

    /**
     * 业务单元
     */
    @ApiModelProperty(name = "businessUnitName",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元 '")
    private String businessUnitName;
    /**
     * 业务单元编码
     */
    @ApiModelProperty(name = "businessUnitCode",value = "业务单元编码",notes = "业务单元编码")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元编码 '")
    private String businessUnitCode;
    /**
     * 业态
     */
    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    @Column(name = "business_format_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态 '")
    private String businessFormatCode;

    /**
     * 活动编号
     */
    @ApiModelProperty(name = "activityNo",value = "活动编号",notes = "活动编号")
    @Column(name = "activity_no", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动编号 '")
    private String activityNo;
    /**
     * 活动申请金额
     */
    @ApiModelProperty(name = "activityApplicationAmount",value = "活动申请金额",notes = "活动申请金额")
    @Column(name = "activity_application_amount", columnDefinition = "decimal(24,6) COMMENT '活动申请金额'")
    private BigDecimal activityApplicationAmount;
    /**
     * 本次申请预付总额
     */
    @ApiModelProperty(name = "currentAmount",value = "本次申请预付总额",notes = "本次申请预付总额")
    @Column(name = "current_amount", columnDefinition = "decimal(24,6) COMMENT '本次申请预付总额'")
    private BigDecimal currentAmount;

    /**
     * 已冲销金额
     */
    @ApiModelProperty(name = "reversedAmount",value = "已冲销金额",notes = "已冲销金额")
    @Column(name = "reversed_amount", columnDefinition = "decimal(24,6) COMMENT '已冲销金额'")
    private BigDecimal reversedAmount;
    /**
     * 待冲销金额
     */
    @ApiModelProperty(name = "amountWrittenOff",value = "待冲销金额",notes = "待冲销金额")
    @Column(name = "amount_written_off", columnDefinition = "decimal(24,6) COMMENT '待冲销金额'")
    private BigDecimal amountWrittenOff;


    /**
     * 成本中心编码
     */
    @ApiModelProperty(name = "costCenter",value = "成本中心编码",notes = "成本中心编码")
    @Column(name = "cost_center_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '成本中心编码 '")
    private String costCenterCode;
    /**
     * 利润中心编码
     */
    @ApiModelProperty(name = "creatorCode",value = "利润中心编码",notes = "利润中心编码")
    @Column(name = "profit_center_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '利润中心编码 '")
    private String profitCenterCode;
    /**
     * 利润中心
     */
    @ApiModelProperty(name = "profitCenter",value = "利润中心",notes = "利润中心")
    @Column(name = "profit_center", length = 64, columnDefinition = "VARCHAR(64) COMMENT '利润中心 '")
    private String profitCenter;
    /**
     * 付款方式
     */
    @ApiModelProperty(name = "paymentMethod",value = "付款方式",notes = "付款方式")
    @Column(name = "payment_method", length = 64, columnDefinition = "varchar(64) COMMENT '付款方式'")
    private String paymentMethod;
    /**
     * 是否有合同
     */
    @ApiModelProperty(name = "whetherContract",value = "是否有合同",notes = "是否有合同")
    @Column(name = "whether_contract", length = 10, columnDefinition = "varchar(10) COMMENT '是否有合同'")
    private String whetherContract;
    /**
     * 付款金额汇总
     */
    @ApiModelProperty(name = "amountSummary",value = "付款金额汇总",notes = "付款金额汇总")
    @Column(name = "amount_summary", columnDefinition = "decimal(24,6) COMMENT '付款金额汇总'")
    private BigDecimal amountSummary;
    /**
     * 开支内容
     */
    @ApiModelProperty(name = "expenseContent",value = "开支内容",notes = "开支内容")
    @Column(name = "expense_content", length = 64, columnDefinition = "varchar(64) COMMENT '开支内容'")
    private String expenseContent;

    /**
     * 公司编码
     */
    @ApiModelProperty(name = "公司编码", notes = "公司编码")
    @Column(name = "company_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '公司编码'")
    private String companyCode;
    /**
     * 公司名称
     */
    @ApiModelProperty(name = "公司名称", notes = "公司名称")
    @Column(name = "company_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '公司名称'")
    private String companyName;
    /**
     * 业务大类
     */
    @ApiModelProperty(name = "业务大类", notes = "业务大类")
    @Column(name = "business_title", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务大类'")
    private String businessTitle;
    /**
     * 业务细类
     */
    @ApiModelProperty(name = "业务细类", notes = "业务细类")
    @Column(name = "business_exp_item", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务细类'")
    private String businessExpItem;
    /**
     * 交易货币
     */
    @ApiModelProperty(name = "交易货币", notes = "交易货币")
    @Column(name = "trade_currency", length = 64, columnDefinition = "VARCHAR(64) COMMENT '交易货币'")
    private String tradeCurrency;
    /**
     * 汇率
     */
    @ApiModelProperty(name = "汇率", notes = "汇率")
    @Column(name = "exchange_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '汇率'")
    private String exchangeRate;
    /**
     * 经办人工号
     */
    @ApiModelProperty(name = "经办人工号", notes = "经办人工号")
    @Column(name = "operator_work_no", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经办人工号'")
    private String operatorWorkNo;
    /**
     * 报账人工号
     */
    @ApiModelProperty(name = "报账人工号", notes = "报账人工号")
    @Column(name = "reimburser_work_no", length = 64, columnDefinition = "VARCHAR(64) COMMENT '报账人工号'")
    private String reimburserWorkNo;
    /**
     * FSSC审核部门
     */
    @ApiModelProperty(name = "FSSC审核部门", notes = "FSSC审核部门")
    @Column(name = "audit_depart", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'FSSC审核部门'")
    private String auditDepart;
    /**
     * 本次预付金额
     */
    @ApiModelProperty(name = "prepaidAmount",value = "本次预付金额",notes = "本次预付金额")
    @Column(name = "prepaid_amount", columnDefinition = "decimal(24,6) COMMENT '本次预付金额'")
    private BigDecimal prepaidAmount;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "组织编码")
    @Column(name = "org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "组织名称")
    @Column(name = "org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

    @ApiModelProperty("CE上账状态")
    @Column(name = "ce_commit_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'CE上账状态'")
    private String ceCommitStatus;

    @ApiModelProperty("费用池上账状态")
    @Column(name = "sap_transfer_commit_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '费用池上账状态'")
    private String sapTransferCommitStatus;

    @ApiModelProperty("费用池上账信息")
    @Column(name = "sap_transfer_commit_message", length = 64, columnDefinition = "VARCHAR(64) COMMENT '费用池上账信息'")
    private String sapTransferCommitMessage;

    @ApiModelProperty("SAP转款凭证编码")
    @Column(name = "sap_transfer_cert_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'SAP转款凭证编码'")
    private String sapTransferCertCode;

    @ApiModelProperty("上账编码")
    @Column(name = "up_account_code", length = 10, columnDefinition = "VARCHAR(10) COMMENT '上账编码'")
    private String upAccountCode;

    @ApiModelProperty("付款编码")
    @Column(name = "eas_order_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款编码'")
    private String easOrderId;

    @ApiModelProperty("付款流水号")
    @Column(name = "flow_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款流水号'")
    private String flowId;

    @ApiModelProperty("付款账号")
    @Column(name = "pay_account_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款账号'")
    private String payAccountCode;

    @ApiModelProperty("付款编码")
    @Column(name = "eas_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款编码'")
    private String easCode;

    @ApiModelProperty("付款描述")
    @Column(name = "eas_desc", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款描述'")
    private String easDesc;

    @ApiModelProperty("EAS返回信息")
    @Column(name = "eas_message", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'EAS返回信息'")
    private String easMessage;

    @ApiModelProperty("付款成功日期")
    @Column(name = "pay_success_date", length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款成功日期'")
    private String paySuccessDate;

    @ApiModelProperty("SAP付款凭证号")
    @Column(name = "sap_voucher_no", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'SAP付款凭证号'")
    private String sapVoucherNo;

    @ApiModelProperty("CE流程状态")
    @Column(name = "ce_process_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'CE流程状态'")
    private String ceProcessStatus;



}
