package com.biz.crm.tpm.business.event.prepayment.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author xiaoyoujun
 * @date 2022年11月30日
 */
@ApiModel(value = "MaterialInformationEntity", description = "TPM-供应商数据")
@TableName("tpm_material_information")
@Data
@Entity(name = "tpm_material_information")
@Table(
        name = "tpm_material_information",
        indexes = {
                @Index(name = "tpm_material_information_idx1", columnList = "prepaid_coding"),
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_material_information", comment = "TPM-供应商数据")
public class MaterialInformationEntity extends TenantFlagOpEntity {
    /**
     * 客商类型
     */
    @ApiModelProperty(name = "passengerType",value = "客商类型",notes = "客商类型")
    @Column(name = "passenger_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客商类型 '")
    private String passengerType;
    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "supplierCode",value = "供应商编码",notes = "供应商编码")
    @Column(name = "supplier_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码 '")
    private String supplierCode;
    /**
     * 供应商
     */
    @ApiModelProperty(name = "supplierName",value = "供应商",notes = "供应商")
    @Column(name = "supplier_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '供应商 '")
    private String supplierName;
    /**
     * 户名
     */
    @ApiModelProperty(name = "accountName",value = "户名",notes = "户名")
    @Column(name = "account_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '户名 '")
    private String accountName;
    /**
     * 开户行
     */
    @ApiModelProperty(name = "bankAccount",value = "开户行",notes = "开户行")
    @Column(name = "bank_account", length = 64, columnDefinition = "VARCHAR(64) COMMENT '开户行 '")
    private String bankAccount;
    /**
     * 银联行号
     */
    @ApiModelProperty(name = "unionPayBankCard",value = "银联行号",notes = "银联行号")
    @Column(name = "union_pay_bank_card",  length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 银联行号 '")
    private String unionPayBankCard;
    /**
     * 银行卡号
     */
    @ApiModelProperty(name = "bankCard",value = "银行卡号",notes = "银行卡号")
    @Column(name = "bank_card",  length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 银行卡号 '")
    private String bankCard;
    /**
     * 收款方账号
     */
    @ApiModelProperty("收款方账号")
    @Column(name = "receipt_account", length = 64, columnDefinition = "VARCHAR(64) COMMENT '收款方账号'")
    private String receiptAccount;
    /**
     * 申请金额
     */
    @ApiModelProperty(name = "feeAmount",value ="申请金额",notes = "申请金额")
    @Column(name = "fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '申请金额'")
    private BigDecimal feeAmount;
    /**
     * 已预付金额
     */
    @ApiModelProperty(name = "amountPaid",value ="已预付金额",notes = "已预付金额")
    @Column(name = "amount_paid", length = 24, columnDefinition = "decimal(24,6) COMMENT '已预付金额'")
    private BigDecimal amountPaid;

    /**
     * 本次预付金额
     */
    @ApiModelProperty(name = "prepaidAmount",value = "本次预付金额",notes = "本次预付金额")
    @Column(name = "prepaid_amount", columnDefinition = "decimal(24,6) COMMENT '本次预付金额'")
    private BigDecimal prepaidAmount;

    /**
     * 期望付款日期
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @ApiModelProperty(name = "expectedDate",value = "期望付款日期", notes = "期望付款日期")
    @Column(name = "expected_date", columnDefinition = "datetime COMMENT '期望付款日期 '")
    private Date expectedDate;
    /**
     * 汇票期限（天）
     */
    @ApiModelProperty(name = "term",value = "汇票期限（天）",notes = "汇票期限（天）")
    @Column(name = "term", length = 64, columnDefinition = "VARCHAR(64) COMMENT '汇票期限（天） '")
    private String term;
    /**
     * 预付编码
     */
    @ApiModelProperty(name = "prepaidCoding",value = "预付编码",notes = "预付编码")
    @Column(name = "prepaid_coding", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付编码 '")
    private String prepaidCoding;
    /**
     * 合同编号
     */
    @ApiModelProperty(name = "合同编号")
    @Column(name = "contract_no", length = 32, columnDefinition = "VARCHAR(32) COMMENT '合同编号'")
    private String contractNo;
    /**
     * 合同名称
     */
    @ApiModelProperty(name = "合同名称")
    @Column(name = "contract_name", columnDefinition = "VARCHAR(255) COMMENT '合同名称'")
    private String contractName;
    /**
     * 预付明细编码
     */
    @ApiModelProperty(name = "预付明细编码", notes = "预付明细编码")
    @Column(name = "pay_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付明细编码'")
    private String payCode;
    /**
     * 报销项目
     */
    @ApiModelProperty(name = "报销项目", notes = "报销项目")
    @Column(name = "reimburse_item",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '报销项目'")
    private String reimburseItem;
    /**
     * 报销项目名称
     */
    @ApiModelProperty("报销项目名称")
    @Column(name = "reimburse_item_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '报销项目名称'")
    private String reimburseItemName;
}
