package com.biz.crm.tpm.business.event.prepayment.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author xiaoyoujun
 * @date 2022年11月26日 13:45
 */
@ApiModel(value = "MaterialProcurementEntity", description = "TPM-采购单数据")
@TableName("tpm_material_procurement")
@Data
@Entity(name = "tpm_material_procurement")
@Table(name = "tpm_material_procurement",
        indexes = {
                @Index(name = "tpm_material_procurement_index1", columnList = "code"),
                @Index(name = "tpm_material_procurement_index2", columnList = "prepaid_coding"),
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_material_procurement", comment = "TPM-采购单数据")
public class MaterialProcurementEntity extends TenantFlagOpEntity {

    /**
     * 采购单编码
     */
    @ApiModelProperty(name = "采购单编码", notes = "采购单编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '采购单编码'")
    private String code;
    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "supplierCode",value = "供应商编码",notes = "供应商编码")
    @Column(name = "supplier_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码 '")
    private String supplierCode;
    /**
     * 供应商
     */
    @ApiModelProperty(name = "supplierName",value = "供应商",notes = "供应商")
    @Column(name = "supplier_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '供应商 '")
    private String supplierName;

    /**
     * 采购单金额（元）
     */
    @ApiModelProperty(name = "采购单金额（元）", notes = "采购单金额（元）")
    @Column(name = "amount", length = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '采购单金额（元）'")
    private BigDecimal amount;
    /**
     * 预付编码
     */
    @ApiModelProperty(name = "prepaidCoding",value = "预付编码",notes = "预付编码")
    @Column(name = "prepaid_coding", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付编码 '")
    private String prepaidCoding;

    /**
     * 本次预付金额
     */
    @ApiModelProperty(name = "prepaidAmount",value = "本次预付金额",notes = "本次预付金额")
    @Column(name = "prepaid_amount", columnDefinition = "decimal(24,6) COMMENT '本次预付金额'")
    private BigDecimal prepaidAmount;

    /**
     * 已申请预付金额
     */
    @ApiModelProperty(name = "prepaidAmountApplied",value = "已申请预付金额",notes = "已申请预付金额")
    @Column(name = "prepaid_amount_applied", columnDefinition = "decimal(24,6) COMMENT '已申请预付金额'")
    private BigDecimal prepaidAmountApplied;

    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @Column(name = "audit_form", length = 32, columnDefinition = "varchar(32) COMMENT '结案形式'")
    private String auditForm;

}
