package com.biz.crm.tpm.business.event.prepayment.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * @author: yaoyongming
 * @date: 2023/1/3 14:34
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PaymentDetailEntity", description = "付款明细实体类")
@Entity
@TableName("tpm_payment_detail")
@Table(
        name = "tpm_payment_detail",
        indexes = {
                @Index(name = "tpm_payment_detail1", columnList = "prepaid_coding"),
                @Index(name = "tpm_payment_detail2", columnList = "pay_code")
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_payment_detail", comment = "付款明细实体类")
public class PaymentDetailEntity extends TenantFlagOpEntity {

    /**
     * 预付编码
     */
    @ApiModelProperty(name = "prepaidCoding", value = "预付编码", notes = "预付编码")
    @Column(name = "prepaid_coding", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付编码 '")
    private String prepaidCoding;

    /**
     * 预付明细编码
     */
    @ApiModelProperty(name = "预付明细编码", notes = "预付明细编码")
    @Column(name = "pay_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付明细编码'")
    private String payCode;

    /**
     * 付款摘要
     */
    @ApiModelProperty(name = "付款摘要", notes = "付款摘要")
    @Column(name = "payment_digest", columnDefinition = "VARCHAR(255) COMMENT '付款摘要'")
    private String paymentDigest;

    /**
     * 利润中心
     */
    @ApiModelProperty(name = "利润中心", notes = "利润中心")
    @Column(name = "profit_center", length = 64, columnDefinition = "VARCHAR(64) COMMENT '利润中心'")
    private String profitCenter;

    /**
     * 资金流出项目
     */
    @ApiModelProperty(name = "资金流出项目", notes = "资金流出项目")
    @Column(name = "capital_outflow_project", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资金流出项目'")
    private String capitalOutflowProject;

    /**
     * 原因代码
     */
    @ApiModelProperty(name = "原因代码", notes = "原因代码")
    @Column(name = "reason_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '原因代码'")
    private String reasonCode;

    /**
     * 序号
     */
    @ApiModelProperty(name = "序号", notes = "序号")
    @Column(name = "sort_no", length = 24, columnDefinition = "decimal(24,6) COMMENT '序号'")
    private Integer sortNo;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "组织编码")
    @Column(name = "org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "组织名称")
    @Column(name = "org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

    /**
     * 资金流出项目
     */
    @ApiModelProperty(name = "资金流出项目名称", notes = "资金流出项目名称")
    @Column(name = "capital_outflow_project_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '资金流出项目名称'")
    private String capitalOutflowProjectName;

    /**
     * 原因代码
     */
    @ApiModelProperty(name = "原因代码名称", notes = "原因代码名称")
    @Column(name = "reason_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '原因代码名称'")
    private String reasonName;

    @ApiModelProperty("报销项目编码")
    @Column(name = "reimburse_item", length = 32, columnDefinition = "VARCHAR(32) COMMENT '报销项目编码'")
    private String reimburseItem;

    @ApiModelProperty("报销项目名称")
    @Column(name = "reimburse_item_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '报销项目名称'")
    private String reimburseItemName;

    @ApiModelProperty("原因代码名称")
    @Column(name = "reason_code_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '原因代码名称'")
    private String reasonCodeName;

    @ApiModelProperty("资金流出项目")
    @Column(name = "funds_outflow_item", length = 32, columnDefinition = "VARCHAR(32) COMMENT '资金流出项目'")
    private String fundsOutflowItem;

    @ApiModelProperty("资金流出项目名称")
    @Column(name = "funds_outflow_item_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '资金流出项目名称'")
    private String fundsOutflowItemName;

}
