package com.biz.crm.tpm.business.event.prepayment.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author xiaoyoujun
 * @date 2022年11月17日 17:33
 */
@ApiModel(value = "PrepaidBySupplierEntity", description = "TPM-促销规划数据")
@TableName("tpm_prepaid_by_supplier")
@Data
@Entity(name = "tpm_prepaid_by_supplier")
@Table(
        name = "tpm_prepaid_by_supplier",
        indexes = {
                @Index(name = "tpm_prepaid_by_supplier_idx1", columnList = "prepaid_coding"),
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_prepaid_by_supplier", comment = "TPM-促销规划数据")
public class PrepaidBySupplierEntity extends TenantFlagOpEntity {

    /**
     * 促销规划明细编号
     */
    @ApiModelProperty(name = "planningDetailsNo",value = "促销规划明细编号",notes = "促销规划明细编号")
    @Column(name = "planning_details_no", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '促销规划明细编号 '")
    private String planningDetailsNo;
    /**
     * 销售部门
     */
    @ApiModelProperty(name = "salesOrgName",value = "销售部门",notes = "销售部门")
    @Column(name = "sales_org_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售部门 '")
    private String salesOrgName;
    /**
     * 销售部门编码
     */
    @ApiModelProperty(name = "salesOrgCode",value = "销售部门编码",notes = "销售部门编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码 '")
    private String salesOrgCode;
    /**
     * 销售组
     */
    @ApiModelProperty(name = "salesGroupName",value = "销售组",notes = "销售组")
    @Column(name = "sales_group_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组 '")
    private String salesGroupName;
    /**
     * 销售组编码
     */
    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    @Column(name = "sales_group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码 '")
    private String salesGroupCode;
    /**
     * 销售机构
     */
    @ApiModelProperty(name = "salesInstitutionName",value = "销售机构",notes = "销售机构")
    @Column(name = "sales_institution_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售机构 '")
    private String salesInstitutionName;
    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码",notes = "销售机构编码")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码 '")
    private String salesInstitutionCode;
    /**
     * 平台
     */
    @ApiModelProperty(name = "platformName",value = "平台",notes = "平台")
    @Column(name = "platform_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '平台 '")
    private String platformName;
    /**
     * 平台编码
     */
    @ApiModelProperty(name = "platformCode",value = "平台编码",notes = "平台编码")
    @Column(name = "platform_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '平台编码 '")
    private String platformCode;
    /**
     * 客户
     */
    @ApiModelProperty(name = "customer",value = "客户",notes = "客户")
    @Column(name = "customer", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户 '")
    private String customer;
    /**
     * 客户MDG编码
     */
    @ApiModelProperty("客户MDG编码")
    @Column(name = "customer_mdg_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户MDG编码'")
    private String customerMdgCode;
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName",value = "客户名称",notes = "客户名称")
    @Column(name = "customer_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户名称 '")
    private String customerName;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;
    /**
     * 电商渠道
     */
    @ApiModelProperty(name = "commerceChannel",value = "电商渠道",notes = "电商渠道")
    @Column(name = "commerce_channel", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '电商渠道 '")
    private String commerceChannel;
    /**
     * 销售进度
     */
    @ApiModelProperty(name = "salesProgress",value = "销售进度",notes = "销售进度")
    @Column(name = "sales_progress", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售进度 '")
    private String salesProgress;
    /**
     * GMV
     */
    @ApiModelProperty(name = "gmv",value = "GMV",notes = "GMV")
    @Column(name = "gmv", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT 'GMV '")
    private String gmv;
    /**
     * 折扣费率
     */
    @ApiModelProperty(name = "discountRate",value = "折扣费率",notes = "折扣费率")
    @Column(name = "discount_rate", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '折扣费率 '")
    private String discountRate;
    /**
     * 价格力度
     */
    @ApiModelProperty(name = "priceDynamics",value = "价格力度",notes = "价格力度")
    @Column(name = "price_dynamics", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '价格力度 '")
    private String priceDynamics;
    /**
     * 申请金额
     */
    @ApiModelProperty(name = "requestedAmount",value = "申请金额",notes = "申请金额")
    @Column(name = "requested_amount", columnDefinition = "decimal(24,6) COMMENT '申请金额'")
    private BigDecimal requestedAmount;
    /**
     * 支付方式
     */
    @ApiModelProperty(name = "payType",value = "支付方式",notes = "支付方式")
    @Column(name = "pay_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '支付方式 '")
    private String payType;
    /**
     * 本次预付金额
     */
    @ApiModelProperty(name = "prepaidAmount",value = "本次预付金额",notes = "本次预付金额")
    @Column(name = "prepaid_amount", columnDefinition = "decimal(24,6) COMMENT '本次预付金额'")
    private BigDecimal prepaidAmount;
    /**
     * 已申请预付金额
     */
    @ApiModelProperty(name = "prepaidAmountApplied",value = "已申请预付金额",notes = "已申请预付金额")
    @Column(name = "prepaid_amount_applied", columnDefinition = "decimal(24,6) COMMENT '已申请预付金额'")
    private BigDecimal prepaidAmountApplied;
    /**
     * 预付编码
     */
    @ApiModelProperty(name = "prepaidCoding",value = "预付编码",notes = "预付编码")
    @Column(name = "prepaid_coding", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付编码 '")
    private String prepaidCoding;
    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    @Column(name = "supplier_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码'")
    private String supplierCode;
    /**
     * 供应商
     */
    @ApiModelProperty(name = "supplierName",value = "供应商",notes = "供应商")
    @Column(name = "supplier_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '供应商 '")
    private String supplierName;

    /**
     * 总公司上账编码
     */
    @ApiModelProperty(name = "upAccountCode",value = "总公司上账编码",notes = "总公司上账编码")
    @Column(name = "up_account_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '总公司上账编码'")
    private String upAccountCode;

    /**
     * 上账状态
     */
    @ApiModelProperty(name = "sapCommitStatus",value = "上账状态",notes = "上账状态")
    @Column(name = "sap_commit_status", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '上账状态'")
    private String sapCommitStatus;

}
