package com.biz.crm.tpm.business.event.prepayment.local.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

public enum PayInAdvanceEnum {
    ACTIVITY("0000","客户预付"),
    CUSTOMER("0001", "活动预付"),
    SUPPLIER("0002","电商预付"),
    MATERIAL("0003","供应商物料预付");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private PayInAdvanceEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        PayInAdvanceEnum[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            PayInAdvanceEnum calculationRulesEnum = var1[var3];
            codes.add(calculationRulesEnum.getCode());
        }

        return codes;
    }

    public static PayInAdvanceEnum codeToEnum(String code) {
        PayInAdvanceEnum calculationRules = null;
        PayInAdvanceEnum[] var2 = values();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            PayInAdvanceEnum calculationRulesEnum = var2[var4];
            if (calculationRulesEnum.code.equals(code)) {
                calculationRules = calculationRulesEnum;
            }
        }

        return calculationRules;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            PayInAdvanceEnum[] values = values();
            PayInAdvanceEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                PayInAdvanceEnum value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        } else {
            PayInAdvanceEnum[] values = values();
            PayInAdvanceEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                PayInAdvanceEnum value = var2[var4];
                if (value.getCode().equals(code)) {
                    return true;
                }
            }

            return false;
        }
    }

}
