package com.biz.crm.tpm.business.event.prepayment.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.event.prepayment.local.entity.CustomerPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.entity.EventPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.CustomerPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.CustomerPrepaymentVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 客户活动预付(CustomerPrepaymentEntity)表mybatis访问层
 *
 * @author youjun
 * @date 2022年11月17日 20：13
 */
public interface CustomerPrepaymentMapper extends BaseMapper<CustomerPrepaymentEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param customerPrepaymentDto 查询实体
     * @return 所有数据
     */
    Page<CustomerPrepaymentVo> findByPrepayments(@Param("page") Page<CustomerPrepaymentVo> page, @Param("dto") CustomerPrepaymentDto customerPrepaymentDto);

    List<CustomerPrepaymentEntity> findByActivityDetailItemCode(@Param("codeList") List<String> activityDetailItemCodeList, @Param("tenantCode") String tenantCode);

    List<CustomerPrepaymentVo> findTotalPrepaidAmountByDetailPlanItemList(@Param("detailPlanItemCodeList") List<String> detailPlanItemCodeList,
                                                                          @Param("processStatus") String processStatus,
                                                                          @Param("tenantCode") String tenantCode);

    List<CustomerPrepaymentEntity> findByActivityDetailItemCodeListAndProcessStatus(@Param("detailPlanItemCodeList") List<String> detailPlanItemCodeList,
                                                                                    @Param("processStatus") String processStatus,
                                                                                    @Param("tenantCode") String tenantCode);
}
