package com.biz.crm.tpm.business.event.prepayment.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.event.prepayment.local.entity.EventPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.CustomerPrepaymentVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentVo;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;


/**
 * 活动预付(EventPrepaymentEntity)表mybatis访问层
 *
 * @author youjun
 * @date 2022年11月15日 19：35
 */
public interface EventPrepaymentMapper extends BaseMapper<EventPrepaymentEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param eventPrepaymentDto 查询实体
     * @return 所有数据
     */
    public Page<EventPrepaymentVo> findByPrepayments(@Param("page") Page<EventPrepaymentVo> page, @Param("dto") EventPrepaymentDto eventPrepaymentDto);

    List<CustomerPrepaymentVo> findActivityPrepaymentByDetailPlanItemCodes(@Param("list") List<String> detailPlanItemCodes);

    List<Date> findProcessDateByActivityDetailCodes(@Param("detailPlanItemCode") String detailPlanItemCode);
}
