package com.biz.crm.tpm.business.event.prepayment.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.event.prepayment.local.entity.MaterialInformationEntity;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.MaterialInformationDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.MaterialInformationVo;
import org.apache.ibatis.annotations.Param;


/**
 * 活动预付客户(PrepaidCustomerEntity)表mybatis访问层
 *
 * @author xiaoyoujun
 * @date 2022年11月30日 20：15
 */
public interface MaterialInformationMapper extends BaseMapper<MaterialInformationEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param prepaidCustomerDto 查询实体
     * @return 所有数据
     */
    public Page<MaterialInformationVo> findBySuppliers(@Param("page") Page<MaterialInformationVo> page, @Param("dto") MaterialInformationDto prepaidCustomerDto);
}
