package com.biz.crm.tpm.business.event.prepayment.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.event.prepayment.local.entity.MaterialProcurementEntity;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.MaterialProcurementDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.MaterialProcurementVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 供应商物料预付(MaterialProcurementEntity)表mybatis访问层
 *
 * @author youjun
 * @date 2022年11月26日 13：59
 */
public interface MaterialProcurementMapper extends BaseMapper<MaterialProcurementEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param materialProcurementDto 查询实体
     * @return 所有数据
     */
    public Page<MaterialProcurementVo> findByPrepayments(@Param("page") Page<MaterialProcurementVo> page, @Param("dto") MaterialProcurementDto materialProcurementDto);

    List<MaterialProcurementEntity> findByCodeList(@Param("codeList") List<String> codeList, @Param("tenantCode") String tenantCode);

    List<MaterialProcurementVo> findTotalPrepaidAmountByDetailPlanItemList(@Param("detailPlanItemCodeList") List<String> detailPlanItemCodeList,
                                                                           @Param("processCode") String processCode,
                                                                           @Param("tenantCode") String tenantCode);

    List<MaterialProcurementEntity> findByActivityDetailItemCodeListAndProcessStatus(@Param("detailPlanItemCodeList") List<String> detailPlanItemCodeList,
                                                                                     @Param("processCode") String processCode,
                                                                                     @Param("tenantCode") String tenantCode);
}
