package com.biz.crm.tpm.business.event.prepayment.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.event.prepayment.local.entity.PrepaidBySupplierEntity;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.PrepaidBySupplierDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.PrepaidBySupplierVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 供应商预付(PrepaidBySupplierEntity)表mybatis访问层
 *
 * @author youjun
 * @date 2022年11月17日 20：15
 */
public interface PrepaidBySupplierMapper extends BaseMapper<PrepaidBySupplierEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param prepaidBySupplierDto 查询实体
     * @return 所有数据
     */
    public Page<PrepaidBySupplierVo> findBySuppliers(@Param("page") Page<PrepaidBySupplierVo> page, @Param("dto") PrepaidBySupplierDto prepaidBySupplierDto);

    List<PrepaidBySupplierEntity> findByPlanningDetailsNo(@Param("planningDetailsNo") String planningDetailsNo, @Param("tenantCode") String tenantCode);

    List<PrepaidBySupplierVo> findTotalPrepaidAmountByDetailPlanItemList(@Param("detailPlanItemCodeList") List<String> detailPlanItemCodeList,
                                                                         @Param("processCode") String processCode,
                                                                         @Param("tenantCode") String tenantCode);

    List<PrepaidBySupplierEntity> findByPlanningDetailsNoListAndProcessStatus(@Param("detailPlanItemCodeList") List<String> detailPlanItemCodeList,
                                                                              @Param("processCode") String processCode,
                                                                              @Param("tenantCode") String tenantCode);
}
