package com.biz.crm.tpm.business.event.prepayment.local.repository;


import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.event.prepayment.local.entity.CustomerPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.mapper.CustomerPrepaymentMapper;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.CustomerPrepaymentVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;


@Component
public class CustomerPrepaymentRepository extends ServiceImpl<CustomerPrepaymentMapper, CustomerPrepaymentEntity> {

    /**
     * 根据id删除 not in
     *
     * @param idList
     * @param code
     */
    public void deleteByIdNotInList(List<String> idList, String code) {
        idList = CollectionUtils.isEmpty(idList) ? new ArrayList<String>(){{add("");}} : idList;
        this.lambdaUpdate()
                .eq(CustomerPrepaymentEntity::getPrepaidCoding, code)
                .notIn(CustomerPrepaymentEntity::getId, idList)
                .remove();
    }

    public List<CustomerPrepaymentEntity> findByActivityDetailItemCode(List<String> activityDetailItemCodeList) {
        if (CollectionUtil.isEmpty(activityDetailItemCodeList)) {
            return Collections.emptyList();
        }
        return this.baseMapper.findByActivityDetailItemCode(activityDetailItemCodeList, TenantUtils.getTenantCode());
    }

    public List<CustomerPrepaymentVo> findTotalPrepaidAmountByDetailPlanItemList(List<String> detailPlanItemCodeList, String processStatus) {
        return this.baseMapper.findTotalPrepaidAmountByDetailPlanItemList(detailPlanItemCodeList, processStatus, TenantUtils.getTenantCode());
    }

    public List<CustomerPrepaymentEntity> findByActivityDetailItemCodeListAndProcessStatus(List<String> detailPlanItemCodeList, String processStatus) {
        return this.baseMapper.findByActivityDetailItemCodeListAndProcessStatus(detailPlanItemCodeList, processStatus, TenantUtils.getTenantCode());
    }
}
