package com.biz.crm.tpm.business.event.prepayment.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.event.prepayment.local.entity.EventPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.enums.CommitStatusEnum;
import com.biz.crm.tpm.business.event.prepayment.local.mapper.EventPrepaymentMapper;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.CustomerPrepaymentVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Component
public class EventPrepaymentRepository extends ServiceImpl<EventPrepaymentMapper, EventPrepaymentEntity> {

    @Resource
    private EventPrepaymentMapper eventPrepaymentMapper;

    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param eventPrepaymentDto 实体对象
     * @return
     */
    public Page<EventPrepaymentVo> findByPrepayments(Pageable pageable, EventPrepaymentDto eventPrepaymentDto) {
        Page<EventPrepaymentVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<EventPrepaymentVo> pageList = this.eventPrepaymentMapper.findByPrepayments(page, eventPrepaymentDto);
        return pageList;
    }

    /**
     * 根据编码查询
     *
     * @param code
     * @return
     */
    public EventPrepaymentEntity findByCode(String code) {
        return this.lambdaQuery().eq(EventPrepaymentEntity::getPrepaidCoding, code)
                .eq(EventPrepaymentEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }

    /**
     * 根据编码批量查询
     *
     * @param codes
     * @return
     */
    public List<EventPrepaymentEntity> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)){
            return null;
        }
        return this.lambdaQuery().in(EventPrepaymentEntity::getPrepaidCoding, codes)
                .eq(EventPrepaymentEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据上账编码批量查询
     *
     * @param codes
     * @return
     */
    public List<EventPrepaymentEntity> findByUpAccountCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)){
            return null;
        }
        return this.lambdaQuery().in(EventPrepaymentEntity::getUpAccountCode, codes)
                .eq(EventPrepaymentEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据ID批量查询
     *
     * @param ids
     * @return
     */
    public List<EventPrepaymentEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return null;
        }
        return this.lambdaQuery().in(EventPrepaymentEntity::getId, ids)
                .eq(EventPrepaymentEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public void updateSapTransferCommitMessage(EventPrepaymentVo eventPrepaymentVo, String errorMsg){
        this.lambdaUpdate()
                .eq(EventPrepaymentEntity::getPrepaidCoding,eventPrepaymentVo.getPrepaidCoding())
                .eq(EventPrepaymentEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(EventPrepaymentEntity::getTenantCode, TenantUtils.getTenantCode())
                .set(EventPrepaymentEntity::getSapTransferCommitMessage,errorMsg)
                .set(EventPrepaymentEntity::getSapTransferCommitStatus, CommitStatusEnum.COMMIT_FAIL.getCode())
                .update();

    }

    public List<CustomerPrepaymentVo> findActivityPrepaymentByDetailPlanItemCodes(List<String> detailPlanItemCodes) {

        if(CollectionUtils.isEmpty(detailPlanItemCodes)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findActivityPrepaymentByDetailPlanItemCodes(detailPlanItemCodes);
    }

    public List<Date> findProcessDateByActivityDetailCodes(String detailPlanItemCode) {
        if(StringUtils.isEmpty(detailPlanItemCode)){
            return Lists.newArrayList();
        }

        return this.getBaseMapper().findProcessDateByActivityDetailCodes(detailPlanItemCode);
    }
}
