package com.biz.crm.tpm.business.event.prepayment.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.event.prepayment.local.entity.MaterialInformationEntity;
import com.biz.crm.tpm.business.event.prepayment.local.mapper.MaterialInformationMapper;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;


@Component
public class MaterialInformationRepository extends ServiceImpl<MaterialInformationMapper, MaterialInformationEntity> {

    /**
     * 根据id删除 not in
     *
     * @param codeList
     * @param code
     */
    public void deleteByIdNotInList(List<String> codeList, String code) {
        codeList = CollectionUtils.isEmpty(codeList) ? new ArrayList<String>(){{add("");}} : codeList;
        this.lambdaUpdate()
                .eq(MaterialInformationEntity::getPrepaidCoding, code)
                .notIn(MaterialInformationEntity::getPayCode, codeList)
                .remove();
    }
}
