package com.biz.crm.tpm.business.event.prepayment.local.repository;


import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.event.prepayment.local.entity.MaterialProcurementEntity;
import com.biz.crm.tpm.business.event.prepayment.local.mapper.MaterialProcurementMapper;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.MaterialProcurementVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


@Component
public class MaterialProcurementRepository extends ServiceImpl<MaterialProcurementMapper, MaterialProcurementEntity> {

    /**
     * 根据id删除 not in
     *
     * @param idList
     * @param code
     */
    public void deleteByIdNotInList(List<String> idList, String code) {
        idList = CollectionUtils.isEmpty(idList) ? new ArrayList<String>(){{add("");}} : idList;
        this.lambdaUpdate()
                .eq(MaterialProcurementEntity::getPrepaidCoding, code)
                .notIn(MaterialProcurementEntity::getId, idList)
                .remove();
    }

    public List<MaterialProcurementEntity> findByCodeList(List<String> codeList) {
        if (CollectionUtil.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return this.baseMapper.findByCodeList(codeList, TenantUtils.getTenantCode());
    }

    public List<MaterialProcurementVo> findTotalPrepaidAmountByDetailPlanItemList(List<String> detailPlanItemCodeList, String processCode) {
        return this.baseMapper.findTotalPrepaidAmountByDetailPlanItemList(detailPlanItemCodeList, processCode, TenantUtils.getTenantCode());
    }

    public List<MaterialProcurementEntity> findByActivityDetailItemCodeListAndProcessStatus(List<String> detailPlanItemCodeList, String processStatus) {
        return this.baseMapper.findByActivityDetailItemCodeListAndProcessStatus(detailPlanItemCodeList, processStatus, TenantUtils.getTenantCode());
    }
}
