package com.biz.crm.tpm.business.event.prepayment.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.event.prepayment.local.entity.PaymentDetailEntity;
import com.biz.crm.tpm.business.event.prepayment.local.mapper.PaymentDetailMapper;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.MaterialInformationDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;


@Component
public class PaymentDetailRepository extends ServiceImpl<PaymentDetailMapper, PaymentDetailEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据id删除 not in
     *
     * @param codeList
     * @param code
     */
    public void deleteByIdNotInList(List<String> codeList, String code) {
        codeList = CollectionUtils.isEmpty(codeList) ? new ArrayList<String>(){{add("");}} : codeList;
        this.lambdaUpdate()
                .eq(PaymentDetailEntity::getPrepaidCoding, code)
                .notIn(PaymentDetailEntity::getPayCode, codeList)
                .remove();
    }

    /**
     * 批量修改
     *
     * @param list
     */
    public void updateList(List<MaterialInformationDto> list) {
        list.forEach(e -> {
            this.lambdaUpdate().eq(PaymentDetailEntity::getPayCode, e.getPayCode())
                    .set(PaymentDetailEntity::getPaymentDigest, e.getPaymentDigest())
                    .set(PaymentDetailEntity::getCapitalOutflowProject, e.getCapitalOutflowProject())
                    .set(PaymentDetailEntity::getProfitCenter, e.getProfitCenter())
                    .set(PaymentDetailEntity::getReasonCode, e.getReasonCode())
                    .set(PaymentDetailEntity::getSortNo, e.getSortNo()).update();
        });
    }
}
