package com.biz.crm.tpm.business.event.prepayment.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.event.prepayment.local.entity.PrepaidBySupplierEntity;
import com.biz.crm.tpm.business.event.prepayment.local.mapper.PrepaidBySupplierMapper;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.PrepaidBySupplierVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;


@Component
public class PrepaidBySupplierRepository extends ServiceImpl<PrepaidBySupplierMapper, PrepaidBySupplierEntity> {

    /**
     * 根据id删除 not in
     *
     * @param idList
     * @param code
     */
    public void deleteByIdNotInList(List<String> idList, String code) {
        idList = CollectionUtils.isEmpty(idList) ? new ArrayList<String>(){{add("");}} : idList;
        this.lambdaUpdate()
                .eq(PrepaidBySupplierEntity::getPrepaidCoding, code)
                .notIn(PrepaidBySupplierEntity::getId, idList)
                .remove();
    }

    public List<PrepaidBySupplierEntity> findByPlanningDetailsNo(String planningDetailsNo) {
        return this.baseMapper.findByPlanningDetailsNo(planningDetailsNo, TenantUtils.getTenantCode());
    }

    public List<PrepaidBySupplierVo> findTotalPrepaidAmountByDetailPlanItemList(List<String> detailPlanItemCodeList, String processCode) {
        return this.baseMapper.findTotalPrepaidAmountByDetailPlanItemList(detailPlanItemCodeList, processCode, TenantUtils.getTenantCode());
    }

    public List<PrepaidBySupplierEntity> findByPlanningDetailsNoListAndProcessStatus(List<String> detailPlanItemCodeList, String processCode) {
        return this.baseMapper.findByPlanningDetailsNoListAndProcessStatus(detailPlanItemCodeList, processCode, TenantUtils.getTenantCode());
    }
}
