package com.biz.crm.tpm.business.event.prepayment.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.*;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.mn.third.system.sd.sdk.vo.PaymentReceiptResultVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.PaymentReceiptStatusResultVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.event.prepayment.local.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.event.prepayment.local.constant.EventPrepaymentConstant;
import com.biz.crm.tpm.business.event.prepayment.local.entity.*;
import com.biz.crm.tpm.business.event.prepayment.local.enums.CommitStatusEnum;
import com.biz.crm.tpm.business.event.prepayment.local.enums.PayInAdvanceEnum;
import com.biz.crm.tpm.business.event.prepayment.local.enums.RequestCERespCodeEnum;
import com.biz.crm.tpm.business.event.prepayment.local.enums.SucessOrFailEnum;
import com.biz.crm.tpm.business.event.prepayment.local.repository.*;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.*;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.log.EventPrepaymentLogEventDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.EventPrepaymentLogEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.*;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.*;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.biz.crm.tpm.business.event.prepayment.local.constant.EventPrepaymentConstant.*;
import static com.biz.crm.tpm.business.event.prepayment.local.enums.PayInAdvanceEnum.CUSTOMER;

/**
 * 活动预付(EventPrepaymentEntity)服务实现类
 *
 * @author youjun
 * @date 2022年11月15日 19:46
 */
@Service("eventPrepaymentService")
@Slf4j
public class EventPrepaymentServiceImpl implements EventPrepaymentService {

    @Autowired(required = false)
    private EventPrepaymentRepository eventPrepaymentRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;
    @Autowired(required = false)
    private CustomerPrepaymentService customerPrepaymentService;
    @Autowired(required = false)
    private PrepaidBySupplierService prepaidBySupplierService;
    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required = false)
    private CustomerPrepaymentRepository customerPrepaymentRepository;
    @Autowired(required = false)
    private MaterialInformationRepository materialInformationRepository;
    @Autowired(required = false)
    private MaterialInformationService materialInformationService;
    @Autowired(required = false)
    private MaterialProcurementService materialProcurementService;
    @Autowired(required = false)
    private MaterialProcurementRepository materialProcurementRepository;
    @Autowired(required = false)
    private PrepaidBySupplierRepository prepaidBySupplierRepository;
    @Autowired(required =false)
    private SupplierVoService supplierVoService;
    @Autowired(required = false)
    private PaymentDetailRepository paymentDetailRepository;
    @Autowired(required = false)
    private LoginUserService loginUserService;
    @Autowired
    private SapSdApiService sapSdApiService;
    @Autowired
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Value("${rocketmq.environment}")
    private String rocketmqEnvironment;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private GeneralExpensesService generalExpensesService;



    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param eventPrepaymentDto 实体对象
     * @return
     */
    @Override
    public Page<EventPrepaymentVo> findByPrepayments(Pageable pageable, EventPrepaymentDto eventPrepaymentDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(eventPrepaymentDto)) {
            eventPrepaymentDto = new EventPrepaymentDto();
        }
        return this.eventPrepaymentRepository.findByPrepayments(pageable,eventPrepaymentDto);
    }

    /**
     * 新增数据
     * @param eventPrepaymentDto 实体对象
     * @return 新增结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public EventPrepaymentVo create(EventPrepaymentDto eventPrepaymentDto) {
        createValidate(eventPrepaymentDto);
        checkPrepaidAmount(eventPrepaymentDto);
        AbstractCrmUserIdentity loginDetails = loginUserService.getAbstractLoginUser();
        // 确认组织机构信息
        Object orgCodeObject = loginDetails.invokeFieldValue("orgCode");
        Object orgNameObject = loginDetails.invokeFieldValue("orgName");
        eventPrepaymentDto.setOrgCode(orgCodeObject == null ? null : orgCodeObject.toString());
        eventPrepaymentDto.setOrgName(orgNameObject == null ? null : orgNameObject.toString());
        eventPrepaymentDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        eventPrepaymentDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        eventPrepaymentDto.setTenantCode(TenantUtils.getTenantCode());
        eventPrepaymentDto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
//        String upAccountCode = this.generateCodeService.generateCode(AUDIT_UP_ACCOUNT_DETAIL_PREFIX, 1, 8, 0, TimeUnit.DAYS).get(0);
//        eventPrepaymentDto.setUpAccountCode(upAccountCode);
//        String ruleCode = StringUtils.join(EVENT_PREPAYMENT_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        String eventPrepaymentCode = generateCodeService.generateCode(EVENT_PREPAYMENT_CODE, 1,5, 2, TimeUnit.DAYS).get(0);
        Validate.notBlank(eventPrepaymentCode,"预付编号生成失败");
        eventPrepaymentDto.setPrepaidCoding(eventPrepaymentCode);
        //客户预付
        if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
            if(BusinessUnitEnum.ONLINE.getCode().equals(eventPrepaymentDto.getBusinessUnitCode())){
                prepaidBySupplierService.create(eventPrepaymentDto.getPrepaidBySupplier(), eventPrepaymentCode);
            } else {
                customerPrepaymentService.create(eventPrepaymentDto.getCustomerPrepayment(), eventPrepaymentDto);
            }
            //活动预付
        } else if (eventPrepaymentDto.getPrepaymentType().equals(CUSTOMER.getCode())){
            if (eventPrepaymentDto.getCustomerPrepayment()!=null && eventPrepaymentDto.getCustomerPrepayment().size()>0) {
                customerPrepaymentService.create(eventPrepaymentDto.getCustomerPrepayment(), eventPrepaymentDto);
            }
            if (eventPrepaymentDto.getMaterialInformation()!=null && eventPrepaymentDto.getMaterialInformation().size()>0){
                materialInformationService.create(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
            }
            //电商预付
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())){
            if (eventPrepaymentDto.getPrepaidBySupplier()!=null && eventPrepaymentDto.getPrepaidBySupplier().size()>0) {
                prepaidBySupplierService.create(eventPrepaymentDto.getPrepaidBySupplier(), eventPrepaymentCode);
            }
            if (eventPrepaymentDto.getMaterialInformation()!=null && eventPrepaymentDto.getMaterialInformation().size()>0){
                materialInformationService.create(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
            }
            //供应商物料预付
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())){
            if (eventPrepaymentDto.getMaterialProcurement()!=null && eventPrepaymentDto.getMaterialProcurement().size()>0) {
                materialProcurementService.create(eventPrepaymentDto.getMaterialProcurement(), eventPrepaymentCode);
            }
            if (eventPrepaymentDto.getMaterialInformation()!=null && eventPrepaymentDto.getMaterialInformation().size()>0){
                materialInformationService.create(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
            }
        }
        //保存
        EventPrepaymentEntity eventPrepaymentEntity = this.nebulaToolkitService.copyObjectByWhiteList(eventPrepaymentDto, EventPrepaymentEntity.class, LinkedHashSet.class, ArrayList.class);
        this.eventPrepaymentRepository.saveOrUpdate(eventPrepaymentEntity);
        eventPrepaymentDto.setId(eventPrepaymentEntity.getId());
        // 日志新增
        EventPrepaymentLogEventDto logEventDto = new EventPrepaymentLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(eventPrepaymentDto);
        SerializableBiConsumer<EventPrepaymentLogEventListener, EventPrepaymentLogEventDto> onCreate =
                EventPrepaymentLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, EventPrepaymentLogEventListener.class, onCreate);
        //返回新增数据
        return this.nebulaToolkitService.copyObjectByWhiteList(eventPrepaymentDto,EventPrepaymentVo.class,LinkedHashSet.class, ArrayList.class);
    }

    /**
     * 删除数据
     * @param ids 主键结合
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "删除数据时，主键集合不能为空！");
        List<EventPrepaymentEntity> eventPrepaymentEntities = this.eventPrepaymentRepository.listByIds(ids);
        Validate.notEmpty(eventPrepaymentEntities, "根据提供的主键集合信息，未能获取到相应数据");
        //只能删除【待提交】、【驳回】、【追回】状态的方案
        for (EventPrepaymentEntity entity : eventPrepaymentEntities) {
            if (!ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) && !ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus())
                    && !ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus())) {
                throw new RuntimeException("[" + entity.getPrepaidCoding() + "]未处于【待提交】、【驳回】、【追回】状态，不能删除！");
            }
        }
        eventPrepaymentEntities.forEach(pre->{
            //客户预付
            if (pre.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())){
                UpdateWrapper<CustomerPrepaymentEntity> wrapper = new UpdateWrapper<>();
                wrapper.eq("prepaid_coding",pre.getPrepaidCoding()).set("del_flag", DelFlagStatusEnum.DELETE.getCode());
                this.customerPrepaymentRepository.update(wrapper);
                //活动预付
            } else if (pre.getPrepaymentType().equals(CUSTOMER.getCode())){
                UpdateWrapper<CustomerPrepaymentEntity> wrapper = new UpdateWrapper<>();
                wrapper.eq("prepaid_coding",pre.getPrepaidCoding()).set("del_flag", DelFlagStatusEnum.DELETE.getCode());
                this.customerPrepaymentRepository.update(wrapper);
                UpdateWrapper<MaterialInformationEntity> queryWrapper = new UpdateWrapper<>();
                queryWrapper.eq("prepaid_coding",pre.getPrepaidCoding()).set("del_flag", DelFlagStatusEnum.DELETE.getCode());
                this.materialInformationRepository.update(queryWrapper);
                paymentDetailRepository.lambdaUpdate()
                        .eq(PaymentDetailEntity::getPrepaidCoding, pre.getPrepaidCoding())
                        .set(PaymentDetailEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
                //电商预付
            } else if (pre.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())){
                UpdateWrapper<PrepaidBySupplierEntity> wrapper = new UpdateWrapper<>();
                wrapper.eq("prepaid_coding",pre.getPrepaidCoding()).set("del_flag", DelFlagStatusEnum.DELETE.getCode());
                this.prepaidBySupplierRepository.update(wrapper);
                UpdateWrapper<MaterialInformationEntity> queryWrapper = new UpdateWrapper<>();
                queryWrapper.eq("prepaid_coding",pre.getPrepaidCoding()).set("del_flag", DelFlagStatusEnum.DELETE.getCode());
                this.materialInformationRepository.update(queryWrapper);
                paymentDetailRepository.lambdaUpdate()
                        .eq(PaymentDetailEntity::getPrepaidCoding, pre.getPrepaidCoding())
                        .set(PaymentDetailEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
                //供应商物料预付
            } else if (pre.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())){
                UpdateWrapper<MaterialProcurementEntity> wrapper = new UpdateWrapper<>();
                wrapper.eq("prepaid_coding",pre.getPrepaidCoding()).set("del_flag", DelFlagStatusEnum.DELETE.getCode());
                this.materialProcurementRepository.update(wrapper);
                UpdateWrapper<MaterialInformationEntity> queryWrapper = new UpdateWrapper<>();
                queryWrapper.eq("prepaid_coding",pre.getPrepaidCoding()).set("del_flag", DelFlagStatusEnum.DELETE.getCode());
                this.materialInformationRepository.update(queryWrapper);
                paymentDetailRepository.lambdaUpdate()
                        .eq(PaymentDetailEntity::getPrepaidCoding, pre.getPrepaidCoding())
                        .set(PaymentDetailEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
            }
        });
        this.eventPrepaymentRepository.lambdaUpdate()
                .in(EventPrepaymentEntity::getId, ids)
                .set(EventPrepaymentEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
        //删除业务日志
        Collection<EventPrepaymentDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(eventPrepaymentEntities,
                EventPrepaymentEntity.class, EventPrepaymentDto.class, HashSet.class, ArrayList.class);
        SerializableBiConsumer<EventPrepaymentLogEventListener, EventPrepaymentLogEventDto> onDelete =
                EventPrepaymentLogEventListener::onDelete;
        for (EventPrepaymentDto dto : dtoList) {
            EventPrepaymentLogEventDto logEventDto = new EventPrepaymentLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish(logEventDto, EventPrepaymentLogEventListener.class, onDelete);
        }
    }
    /**
     * 修改数据
     * @param eventPrepaymentDto 实体对象
     * @return 修改结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public EventPrepaymentVo update(EventPrepaymentDto eventPrepaymentDto) {
        checkPrepaidAmount(eventPrepaymentDto);
        EventPrepaymentVo eventPrepaymentVo = findByPrepaidCoding(eventPrepaymentDto.getPrepaidCoding());
        Validate.notNull(eventPrepaymentVo, "修改数据不存在，请检查！");
        eventPrepaymentDto.setTenantCode(TenantUtils.getTenantCode());
        //客户预付
        if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
            if (StringUtils.equals(eventPrepaymentDto.getBusinessUnitCode(),BusinessUnitEnum.ONLINE.getCode())){
                this.prepaidBySupplierService.update(eventPrepaymentDto.getPrepaidBySupplier(), eventPrepaymentDto.getPrepaidCoding());
            }else {
                customerPrepaymentService.update(eventPrepaymentDto.getCustomerPrepayment(), eventPrepaymentDto);
            }
            //活动预付
        } else if (eventPrepaymentDto.getPrepaymentType().equals(CUSTOMER.getCode())) {
            customerPrepaymentService.update(eventPrepaymentDto.getCustomerPrepayment(), eventPrepaymentDto);
            this.materialInformationService.update(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
            //电商预付
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())) {
            this.prepaidBySupplierService.update(eventPrepaymentDto.getPrepaidBySupplier(), eventPrepaymentDto.getPrepaidCoding());
            this.materialInformationService.update(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
            //供应商物料预付
        } else if (eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())) {
            this.materialProcurementService.update(eventPrepaymentDto.getMaterialProcurement(), eventPrepaymentDto.getPrepaidCoding());
            this.materialInformationService.update(eventPrepaymentDto.getMaterialInformation(), eventPrepaymentDto);
        }
        EventPrepaymentEntity eventPrepaymentEntity = this.nebulaToolkitService.copyObjectByWhiteList(eventPrepaymentDto, EventPrepaymentEntity.class, LinkedHashSet.class, ArrayList.class);
        this.eventPrepaymentRepository.saveOrUpdate(eventPrepaymentEntity);
        // 日志新增
        EventPrepaymentDto dto = this.nebulaToolkitService.copyObjectByWhiteList(eventPrepaymentVo, EventPrepaymentDto.class, LinkedHashSet.class, ArrayList.class);
        EventPrepaymentLogEventDto logEventDto = new EventPrepaymentLogEventDto();
        logEventDto.setOriginal(dto);
        logEventDto.setNewest(eventPrepaymentDto);
        SerializableBiConsumer<EventPrepaymentLogEventListener, EventPrepaymentLogEventDto> onUpdate =
                EventPrepaymentLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, EventPrepaymentLogEventListener.class, onUpdate);
        return eventPrepaymentVo;
    }

    /**
     * 通过主键查询单条数据
     *
     * @param code 主键
     * @return 单条数据
     */
    @Override
    public EventPrepaymentVo findByPrepaidCoding(String code) {
        EventPrepaymentEntity eventPrepaymentEntity = this.eventPrepaymentRepository.findByCode(code);
        if (eventPrepaymentEntity == null) {
            return null;
        }
        EventPrepaymentVo eventPrepaymentVo = nebulaToolkitService.copyObjectByWhiteList(eventPrepaymentEntity, EventPrepaymentVo.class, LinkedHashSet.class, ArrayList.class);
        //客户预付
        if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
            if(BusinessUnitEnum.ONLINE.getCode().equals(eventPrepaymentVo.getBusinessUnitCode())){
                List<PrepaidBySupplierVo> byPrepaid = prepaidBySupplierService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setPrepaidBySupplier(byPrepaid);
            } else {
                List<CustomerPrepaymentVo> byPrepaid = customerPrepaymentService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setCustomerPrepayment(byPrepaid);
            }
            //活动预付
        } else if (eventPrepaymentVo.getPrepaymentType().equals(CUSTOMER.getCode())) {
            List<CustomerPrepaymentVo> byPrepaid = customerPrepaymentService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setCustomerPrepayment(byPrepaid);
            List<MaterialInformationVo> prepaid = materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setMaterialInformation(prepaid);
            //电商预付
        } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())) {
            List<PrepaidBySupplierVo> byPrepaid = prepaidBySupplierService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setPrepaidBySupplier(byPrepaid);
            List<MaterialInformationVo> prepaid = materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setMaterialInformation(prepaid);
            //供应商物料预付
        } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())) {
            List<MaterialProcurementVo> byPrepaid = materialProcurementService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setMaterialProcurement(byPrepaid);
            List<MaterialInformationVo> prepaid = materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
            eventPrepaymentVo.setMaterialInformation(prepaid);
        }
        return eventPrepaymentVo;
    }

    /**
     * 通过主键查询批量数据
     *
     * @param ids 主键
     * @return 批量数据
     */
    @Override
    public List<EventPrepaymentVo> findByIds(List<String> ids) {
        List<EventPrepaymentEntity> entities = this.eventPrepaymentRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
//        EventPrepaymentVo eventPrepaymentVo = nebulaToolkitService.copyObjectByWhiteList(eventPrepaymentEntity, EventPrepaymentVo.class, LinkedHashSet.class, ArrayList.class);
        Collection<EventPrepaymentVo> eventPrepaymentVos = this.nebulaToolkitService.copyCollectionByWhiteList(entities, EventPrepaymentEntity.class, EventPrepaymentVo.class, HashSet.class, ArrayList.class);
        List<EventPrepaymentVo> eventPrepaymentVoList = new ArrayList<>();
        for (EventPrepaymentVo eventPrepaymentVo : eventPrepaymentVos) {
            //客户预付
            if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
                List<CustomerPrepaymentVo> byPrepaid = customerPrepaymentService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setCustomerPrepayment(byPrepaid);
                //活动预付
            } else if (eventPrepaymentVo.getPrepaymentType().equals(CUSTOMER.getCode())) {
                List<CustomerPrepaymentVo> byPrepaid = customerPrepaymentService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setCustomerPrepayment(byPrepaid);
                List<MaterialInformationVo> prepaid = materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setMaterialInformation(prepaid);
                //电商预付
            } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())) {
                List<PrepaidBySupplierVo> byPrepaid = prepaidBySupplierService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setPrepaidBySupplier(byPrepaid);
                List<MaterialInformationVo> prepaid = materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setMaterialInformation(prepaid);
                //供应商物料预付
            } else if (eventPrepaymentVo.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())) {
                List<MaterialProcurementVo> byPrepaid = materialProcurementService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setMaterialProcurement(byPrepaid);
                List<MaterialInformationVo> prepaid = materialInformationService.findByPrepaid(eventPrepaymentVo.getPrepaidCoding());
                eventPrepaymentVo.setMaterialInformation(prepaid);
            }
            eventPrepaymentVoList.add(eventPrepaymentVo);
        }
        return eventPrepaymentVoList;
    }
    /**
     * 保存并提交审批
     *
     * @param dto 实体对象
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void submitAndSetPass(EventPrepaymentSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        EventPrepaymentDto eventPrepaymentDto = nebulaToolkitService.copyObjectByWhiteList(dto, EventPrepaymentDto.class, HashSet.class, ArrayList.class);
        Validate.isTrue(Objects.nonNull(processBusiness),"流程参数不能为空");
        Validate.isTrue(Objects.nonNull(eventPrepaymentDto),"活动预付的数据不能为空");
        eventPrepaymentDto.setCustomerPrepayment(dto.getCustomerPrepayment());
        eventPrepaymentDto.setPrepaidBySupplier(dto.getPrepaidBySupplier());
        eventPrepaymentDto.setMaterialProcurement(dto.getMaterialProcurement());
        eventPrepaymentDto.setMaterialInformation(dto.getMaterialInformation());
        if (StringUtils.isNotBlank(eventPrepaymentDto.getId())) {
            update(eventPrepaymentDto);
        } else {
            create(eventPrepaymentDto);
        }
        EventPrepaymentEntity entity = eventPrepaymentRepository.getById(eventPrepaymentDto.getId());
        Validate.notNull(entity, "未找到对应的活动预付");
        eventPrepaymentDto = nebulaToolkitService.copyObjectByWhiteList(entity, EventPrepaymentDto.class, HashSet.class, ArrayList.class);
        adjustSubmit(eventPrepaymentDto, dto.getProcessBusiness());
    }

    /**
     * 提交审批
     *
     * @param dto 实体对象
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void submit(EventPrepaymentSubmitDto dto) {
        Validate.isTrue(Objects.nonNull(dto.getProcessBusiness()),"流程参数不能为空");
        EventPrepaymentEntity entity = eventPrepaymentRepository.getById(dto.getId());
        Validate.notNull(entity, "未找到对应的促销规划");
        EventPrepaymentDto eventPrepaymentDto = nebulaToolkitService.copyObjectByWhiteList(entity, EventPrepaymentDto.class, HashSet.class, ArrayList.class);
        adjustSubmit(eventPrepaymentDto, dto.getProcessBusiness());
    }

    /**
     * 获取促销规划数据
     * @param
     * @return
     */
    @Override
    public List<PrepaidBySupplierVo> promotionPlan(List<GeneralExpensesVo> promotionPlanDtos) {
        List<PrepaidBySupplierVo> arrayList = new ArrayList<>();
        promotionPlanDtos.forEach(pre -> {
            PrepaidBySupplierVo prepaidBySupplierVo = new PrepaidBySupplierVo();
            prepaidBySupplierVo.setSalesOrgCode(pre.getSalesOrgCode());
            prepaidBySupplierVo.setPlatformCode(pre.getPlatformCode());
            prepaidBySupplierVo.setCustomer(pre.getCustomerName());
            prepaidBySupplierVo.setCustomerCode(pre.getCustomerCode());
            prepaidBySupplierVo.setCommerceChannel(pre.getChannelCode());
            prepaidBySupplierVo.setRequestedAmount(pre.getApplyAmount());
            prepaidBySupplierVo.setPlanningDetailsNo(pre.getExpensesCode());
            //todo 获取促销规划明细
//            prepaidBySupplierVo.setSalesProgress("目前没数据");
//            TpmDaySalesSpliceVo salesSpliceVo = new TpmDaySalesSpliceVo();
//            salesSpliceVo.setActivityForm(pre.getActivityFormCode());
//            salesSpliceVo.setCustomer(pre.getCustomerCode());
//            salesSpliceVo.setChannel(pre.getChannelCode());
//            salesSpliceVo.setGoodsCode(pre.getProductCode());
//            salesSpliceVo.setStartDate(pre.getStartDate());
//            salesSpliceVo.setEndDate(pre.getEndDate());
//            prepaidBySupplierVo.setGmv(String.format("%.0f", tpmDaySalesSpliceService.getGmv(salesSpliceVo)));
            arrayList.add(prepaidBySupplierVo);
        });
        return arrayList;
    }
    /**
     * 获取供应商数据
     * @param
     * @return
     */
    @Override
    public List<MaterialInformationVo> getSuppliers(List<CommercePrepaymentDto> commercePrepaymentDtos) {
        List<MaterialInformationVo> arrayList = new ArrayList<>();
        commercePrepaymentDtos.forEach(com->{
            MaterialInformationVo materialInformationVo = this.nebulaToolkitService.copyObjectByWhiteList(com, MaterialInformationVo.class, HashSet.class, ArrayList.class);
            materialInformationVo.setAccountName(com.getSupplierName());
            arrayList.add(materialInformationVo);
        });
        return arrayList;
    }
    /**
     * 提交供应商采购单数据
     * @param
     * @return
     */
    @Override
    public List<MaterialInformationVo> savePurchase(List<PurchaseOrderDto> dtoList) {
        Assert.notEmpty(dtoList,"采购单不能为空!");
        List<MaterialInformationVo> arrayList = new ArrayList<>();
        Map<String,PurchaseOrderDto> supplierCodesMap = dtoList.stream()
                .filter(k -> StringUtils.isNotEmpty(k.getSupplierCode()))
                .collect(Collectors.toMap(PurchaseOrderDto::getSupplierCode, v -> v, (newValue, oldValue) -> newValue));
        if(CollectionUtil.isEmpty(supplierCodesMap)){
            return arrayList;
        }
        List<SupplierVo> byConditions = supplierVoService.findBySupplierCodes(new ArrayList<>(supplierCodesMap.keySet()));
        if(CollectionUtil.isEmpty(byConditions)){
            return arrayList;
        }
        Map<String, SupplierVo> supplierVoMap = byConditions.stream()
                .filter(k -> StringUtils.isNotEmpty(k.getSupplierCode()))
                .collect(Collectors.toMap(SupplierVo::getSupplierCode, v -> v, (newValue, oldValue) -> newValue));

        //接收前端参数
        supplierCodesMap.forEach((supplierCode, vo) -> {
            //获取对应供应商数据
            SupplierVo by = supplierVoMap.get(supplierCode);
            if (Objects.nonNull(by)) {
                MaterialInformationVo materialInformationVo = this.nebulaToolkitService.copyObjectByWhiteList(by, MaterialInformationVo.class, HashSet.class, ArrayList.class);
                materialInformationVo.setAccountName(by.getSupplierName());
                arrayList.add(materialInformationVo);
            }
        });
        return arrayList;
    }

    @Override
    public void syncEventPrePaymentPushData(String body) {
        EventPrepaymentVo eventPrepaymentVo = JsonUtils.json2Obj(body, EventPrepaymentVo.class);
        PayInAdvanceEnum payInAdvanceEnum = PayInAdvanceEnum.codeToEnum(eventPrepaymentVo.getPrepaymentType());
        switch (payInAdvanceEnum){
            case ACTIVITY:
                //折扣预付，付给费用池
                log.info("【活动预付】费用池上账");
                this.eventPrePaymentPayFeePool(eventPrepaymentVo);
                break;
            case CUSTOMER:
            case SUPPLIER:
            case MATERIAL:
                //非折扣预付，付给供应商的CE
                log.info("【活动预付】推送CE");
                EventPrepaymentEntity entity = new EventPrepaymentEntity();
                entity.setId(eventPrepaymentVo.getId());
                Boolean isSuccess = this.eventPrePaymentPushToCe(eventPrepaymentVo);
                if (isSuccess){
                    entity.setCeCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                }else {
                    entity.setCeCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                }
                this.eventPrepaymentRepository.updateById(entity);
                break;
            default:
                throw new IllegalArgumentException("不合法的预付类型【"+payInAdvanceEnum+"");

        }
    }

    @Override
    public void eventPrePaymentHeadCallback(AuditCostPostingCallbackDto dto) {
        log.info("活动预付管理 总公司回调【{}】",JSON.toJSONString(dto));
        List<AuditCostPostingCallbackDataDto> data = dto.getData();
        if(!CollectionUtils.isEmpty(data)){
            Map<String, AuditCostPostingCallbackDataDto> map = data.stream().collect(Collectors.toMap(AuditCostPostingCallbackDataDto::getCamp_id, Function.identity()));
            Set<String> auditUpAccountDetailCodeSet = data.stream().map(AuditCostPostingCallbackDataDto::getCamp_id).collect(Collectors.toSet());
//            if (!campId.startsWith(AUDIT_UP_ACCOUNT_DETAIL_PREFIX)){
//                return;
//            }
            //判断是否电商折扣预付
            List<PrepaidBySupplierEntity> prepaidBySupplierEntities = this.prepaidBySupplierRepository.lambdaQuery()
                    .in(PrepaidBySupplierEntity::getUpAccountCode, auditUpAccountDetailCodeSet)
                    .eq(PrepaidBySupplierEntity::getTenantCode, TenantUtils.getTenantCode())
                    .eq(PrepaidBySupplierEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .list();
            if (!CollectionUtils.isEmpty(prepaidBySupplierEntities)){
                List<PrepaidBySupplierEntity> prepaidBySupplierUpdateList = new ArrayList<>();
                int failCount = 0;
                for (PrepaidBySupplierEntity entity : prepaidBySupplierEntities) {
                    PrepaidBySupplierEntity supplierEntity = new PrepaidBySupplierEntity();
                    supplierEntity.setId(entity.getId());
                    AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = map.get(entity.getUpAccountCode());
                    if(SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        supplierEntity.setSapCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    }else {
                        supplierEntity.setSapCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                        failCount += 1;
                    }
                    prepaidBySupplierUpdateList.add(entity);
                }
                this.prepaidBySupplierRepository.updateBatchById(prepaidBySupplierUpdateList);
                PrepaidBySupplierEntity supplierEntity = prepaidBySupplierEntities.get(0);
                EventPrepaymentEntity one = this.eventPrepaymentRepository.lambdaQuery()
                        .eq(EventPrepaymentEntity::getTenantCode, TenantUtils.getTenantCode())
                        .eq(EventPrepaymentEntity::getPrepaidCoding, supplierEntity.getPrepaidCoding())
                        .one();
                if (failCount == 0){
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_SUCCESS.getDesc());
                }else if (failCount == data.size()){
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_FAIL.getDesc());
                }else {
                    one.setSapTransferCommitStatus(CommitStatusEnum.PART_SUCCESS.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.PART_SUCCESS.getDesc());
                }
                this.eventPrepaymentRepository.updateById(one);
            }else {
                // 判断是否其他类型的预付
                List<CustomerPrepaymentEntity> customerPrepaymentEntities = this.customerPrepaymentRepository.lambdaQuery()
                        .in(CustomerPrepaymentEntity::getUpAccountCode, auditUpAccountDetailCodeSet)
                        .eq(CustomerPrepaymentEntity::getTenantCode, TenantUtils.getTenantCode())
                        .eq(CustomerPrepaymentEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                        .list();
                if (CollectionUtils.isEmpty(customerPrepaymentEntities)){
                    return;
                }

                List<CustomerPrepaymentEntity> customerPrepaymentUpdateList = new ArrayList<>();
                int failCount = 0;
                for (CustomerPrepaymentEntity entity : customerPrepaymentEntities) {
                    CustomerPrepaymentEntity customerPrepaymentEntity = new CustomerPrepaymentEntity();
                    customerPrepaymentEntity.setId(entity.getId());
                    AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = map.get(entity.getUpAccountCode());
                    if(SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        customerPrepaymentEntity.setSapCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    }else {
                        customerPrepaymentEntity.setSapCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                        failCount += 1;
                    }
                    customerPrepaymentUpdateList.add(entity);
                }
                CustomerPrepaymentEntity prepaymentEntity = customerPrepaymentEntities.get(0);
                EventPrepaymentEntity one = this.eventPrepaymentRepository.lambdaQuery()
                        .eq(EventPrepaymentEntity::getTenantCode, TenantUtils.getTenantCode())
                        .eq(EventPrepaymentEntity::getPrepaidCoding, prepaymentEntity.getPrepaidCoding())
                        .one();
                if (failCount == 0){
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_SUCCESS.getDesc());
                }else if (failCount == data.size()){
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_FAIL.getDesc());
                }else {
                    one.setSapTransferCommitStatus(CommitStatusEnum.PART_SUCCESS.getCode());
                    one.setSapTransferCommitMessage(CommitStatusEnum.PART_SUCCESS.getDesc());
                }
                this.eventPrepaymentRepository.updateById(one);
            }
            //根据返回消息更新状态
//            Map<String, AuditCostPostingCallbackDataDto> map = data.stream().collect(Collectors.toMap(AuditCostPostingCallbackDataDto::getCamp_id, Function.identity()));
//            Set<String> auditUpAccountDetailCodeSet = data.stream().map(AuditCostPostingCallbackDataDto::getCamp_id).collect(Collectors.toSet());
//            List<EventPrepaymentEntity> eventPrepaymentEntities = this.eventPrepaymentRepository.findByUpAccountCodes(new ArrayList<>(auditUpAccountDetailCodeSet));
//            List<EventPrepaymentEntity> listUpdate = new ArrayList<>();
//            for (EventPrepaymentEntity eventPrepaymentEntity : eventPrepaymentEntities) {
//                EventPrepaymentEntity entity = new EventPrepaymentEntity();
//                entity.setId(eventPrepaymentEntity.getId());
//                AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = map.get(eventPrepaymentEntity.getPrepaidCoding());
//                if(SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
//                    entity.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
//                    entity.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_SUCCESS.getDesc());
//                }else {
//                    entity.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
//                    entity.setSapTransferCommitMessage(auditCostPostingCallbackDataDto.getMessage());
//                }
//                listUpdate.add(entity);
//            }
//            this.eventPrepaymentRepository.updateBatchById(listUpdate);
        }

    }

    @Override
    public void eventPrePaymentSonCallback(SonAuditCostPostingCallbackDto dto) {
        log.info("活动预付管理 分子公司回调【{}】",JSON.toJSONString(dto));

        List<SonAuditCostPostingCallbackDataDto> data = dto.getData();
        if(!CollectionUtils.isEmpty(data)){
            String zftpmhxd = data.get(0).getZftpmhxd();
            if (!zftpmhxd.startsWith(AUDIT_CUSTOMER_PREPAYMENT_DETAIL_PREFIX)){
                return;
            }
            //根据返回消息更新状态
            Map<String, SonAuditCostPostingCallbackDataDto> map = data.stream().collect(Collectors.toMap(SonAuditCostPostingCallbackDataDto::getZftpmhxd, Function.identity()));
            Set<String> auditUpAccountDetailCodeSet = data.stream().map(SonAuditCostPostingCallbackDataDto::getZftpmhxd).collect(Collectors.toSet());
            List<CustomerPrepaymentEntity> customerPrepaymentEntities = this.customerPrepaymentRepository.lambdaQuery()
                    .eq(CustomerPrepaymentEntity::getTenantCode, TenantUtils.getTenantCode())
                    .eq(CustomerPrepaymentEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .in(CustomerPrepaymentEntity::getCustomerPrepaymentDetailCode, auditUpAccountDetailCodeSet)
                    .list();
            List<CustomerPrepaymentEntity> listUpdate = new ArrayList<>();
            int failCount = 0;
            for (CustomerPrepaymentEntity customerPrepaymentEntity : customerPrepaymentEntities) {
                CustomerPrepaymentEntity entity = new CustomerPrepaymentEntity();
                entity.setId(customerPrepaymentEntity.getId());
                SonAuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = map.get(customerPrepaymentEntity.getCustomerPrepaymentDetailCode());
                if(SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                    entity.setSapCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                }else {
                    entity.setSapCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    failCount += 1;
                }
                listUpdate.add(entity);
            }
            this.customerPrepaymentRepository.updateBatchById(listUpdate);
            CustomerPrepaymentEntity prepaymentEntity = customerPrepaymentEntities.get(0);
            EventPrepaymentEntity one = this.eventPrepaymentRepository.lambdaQuery()
                    .eq(EventPrepaymentEntity::getTenantCode, TenantUtils.getTenantCode())
                    .eq(EventPrepaymentEntity::getPrepaidCoding, prepaymentEntity.getPrepaidCoding())
                    .one();
            if (failCount == 0){
                one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_SUCCESS.getDesc());
            }else if (failCount == data.size()){
                one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_FAIL.getDesc());
            }else {
                one.setSapTransferCommitStatus(CommitStatusEnum.PART_SUCCESS.getCode());
                one.setSapTransferCommitMessage(CommitStatusEnum.PART_SUCCESS.getDesc());
            }
            this.eventPrepaymentRepository.updateById(one);
        }
    }

    @Override
    public void queryPaymentReceiptECStatus(PaymentReceiptQueryStatusDto paymentReceiptQueryStatusDto) {
        //异步推送数据
        MqMessageVo mqMessage = new MqMessageVo();
        //数据
        mqMessage.setMsgBody(JsonUtils.obj2JsonString(paymentReceiptQueryStatusDto));
        //MQ标签
        mqMessage.setTag(EventPrepaymentConstant.TPM_EVENT_PRE_PAYMENT_QUERY_DATA_TAG);
        mqMessage.setTopic(EventPrepaymentConstant.TPM_EVENT_PRE_PAYMENT_QUERY_DATA_TOPIC.concat(rocketmqEnvironment));
        rocketMqProducer.sendMqMsg(mqMessage);
    }

    @Override
    public void syncQueryPaymentReceiptECStatus(String body) {
        PaymentReceiptQueryStatusDto queryStatusDto = JSONObject.parseObject(body, PaymentReceiptQueryStatusDto.class);

        if (Objects.isNull(queryStatusDto)){
            return;
        }
        //查询CE
        Result<PaymentReceiptStatusResultVo> paymentReceiptStatusResultVoResult = this.sapSdApiService.queryPaymentReceiptStatus(queryStatusDto);
        log.info("活动预付异步查询CE状态结果：【{}】",JSON.toJSONString(paymentReceiptStatusResultVoResult));

        Validate.isTrue(Objects.nonNull(paymentReceiptStatusResultVoResult),"查询CE状态失败");
        PaymentReceiptStatusResultVo result = paymentReceiptStatusResultVoResult.getResult();
        List<EventPrepaymentStatusDetailVo> vos = JSONObject.parseArray(JSON.toJSONString(result.getDetails()), EventPrepaymentStatusDetailVo.class);
        log.info("查询CE状态获取信息：【{}】",JSON.toJSONString(vos));
        Validate.isTrue(!CollectionUtils.isEmpty(vos),"未查询到数据");
        List<String> codes = vos.stream().map(o -> o.getProcessInstanceId()).collect(Collectors.toList());
        LambdaQueryWrapper<EventPrepaymentEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(EventPrepaymentEntity::getPrepaidCoding,codes).eq(EventPrepaymentEntity::getTenantCode,TenantUtils.getTenantCode());
        List<EventPrepaymentEntity> paymentReceipts = eventPrepaymentRepository.getBaseMapper().selectList(wrapper);
        Map<String, EventPrepaymentEntity> map = paymentReceipts.stream().collect(Collectors.toMap(EventPrepaymentEntity::getPrepaidCoding, Function.identity()));
        for (EventPrepaymentStatusDetailVo vo : vos) {
            EventPrepaymentEntity entity = map.get(vo.getProcessInstanceId());
            if (Objects.nonNull(entity)){
                this.constructPaymentReceipt(entity,vo);
            }
        }
        this.eventPrepaymentRepository.updateBatchById(paymentReceipts);
    }

    @Override
    @Transactional
    public Map<String, String> pushEventPrepaymentToCEHandle(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择数据");
        List<EventPrepaymentVo> eventPrepaymentVoList = this.findByIds(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(eventPrepaymentVoList), "预付单不存在");

        Map<String,String> failMap = new HashMap<>();
        for (EventPrepaymentVo eventPrepaymentVo : eventPrepaymentVoList) {
            try {
                //验证单据是否审批通过
                if (!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), eventPrepaymentVo.getProcessStatus())) {
                    failMap.put(eventPrepaymentVo.getPrepaidCoding(), "未审批通过");
                    continue;
                }
                if (StringUtils.equals(PayInAdvanceEnum.ACTIVITY.getCode(), eventPrepaymentVo.getPrepaymentType())) {
                    failMap.put(eventPrepaymentVo.getPrepaidCoding(), "折扣预付不推送CE");
                    continue;
                }
                if (StringUtils.equals(CommitStatusEnum.COMMIT_SUCCESS.getCode(), eventPrepaymentVo.getCeCommitStatus())) {
                    failMap.put(eventPrepaymentVo.getPrepaidCoding(), "不需要推送");
                    continue;
                }
                //推送CE
                log.info("手动推送CE 参数【{}】", JSON.toJSONString(eventPrepaymentVo));
                Boolean isSuccess = this.eventPrePaymentPushToCe(eventPrepaymentVo);
                if (isSuccess) {
                    eventPrepaymentVo.setCeCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    //业务日志
                    EventPrepaymentDto eventPrepaymentDto = this.nebulaToolkitService.copyObjectByWhiteList(eventPrepaymentVo, EventPrepaymentDto.class, null, null);
                    EventPrepaymentLogEventDto logEventDto = new EventPrepaymentLogEventDto();
                    logEventDto.setOriginal(eventPrepaymentDto);
                    eventPrepaymentDto.setCeCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    logEventDto.setNewest(eventPrepaymentDto);
                    SerializableBiConsumer<EventPrepaymentLogEventListener, EventPrepaymentLogEventDto> onUpdate =
                            EventPrepaymentLogEventListener::onUpdate;
                    this.nebulaNetEventClient.publish(logEventDto, EventPrepaymentLogEventListener.class, onUpdate);
                }
            } catch (Exception e) {
                log.error("", e);
                failMap.put(eventPrepaymentVo.getPrepaidCoding(), "推送CE异常!");
            }
        }
        Collection<EventPrepaymentEntity> entities = this.nebulaToolkitService.copyCollectionByWhiteList(eventPrepaymentVoList, EventPrepaymentVo.class, EventPrepaymentEntity.class, HashSet.class, ArrayList.class);
        this.eventPrepaymentRepository.updateBatchById(entities);
        return failMap;
    }

    @Override
    public Map<String, String> pushEventPrepaymentToSAPHandle(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择数据");
        List<EventPrepaymentVo> eventPrepaymentVoList = this.findByIds(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(eventPrepaymentVoList), "预付单不存在");

        Map<String,String> failMap = new HashMap<>();
        for (EventPrepaymentVo eventPrepaymentVo : eventPrepaymentVoList) {
            if (!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), eventPrepaymentVo.getProcessStatus())){
                failMap.put(eventPrepaymentVo.getPrepaidCoding(),"未审批通过");
                continue;
            }
            if (!StringUtils.equals(PayInAdvanceEnum.ACTIVITY.getCode(),eventPrepaymentVo.getPrepaymentType())){
                failMap.put(eventPrepaymentVo.getPrepaidCoding(),"只推送折扣预付数据");
                continue;
            }
            if (StringUtils.equals(CommitStatusEnum.COMMIT_SUCCESS.getCode(),eventPrepaymentVo.getCeCommitStatus())){
                failMap.put(eventPrepaymentVo.getPrepaidCoding(),"不需要推送");
                continue;
            }

            //推送折扣上账
            log.info("活动预付管理手动推送折扣上账 参数:【{}】",JSON.toJSONString(eventPrepaymentVo));
            this.eventPrePaymentPayFeePool(eventPrepaymentVo);
        }
        return failMap;
    }

    @Override
    public List<CustomerPrepaymentVo> findTotalPrepaidAmountByDetailPlanItemList(TotalPrepaidAmountDto dto) {
        if(StringUtils.isNotEmpty(dto.getPrepaymentType()) && !CollectionUtils.isEmpty(dto.getDetailPlanItemCodeList())){
            //客户预付
            if (dto.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
                if(BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())){
                    List<PrepaidBySupplierVo> voList = prepaidBySupplierService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
                    List<CustomerPrepaymentVo> result = new ArrayList<>();
                    for(PrepaidBySupplierVo vo : voList){
                        CustomerPrepaymentVo customerPrepaymentVo = new CustomerPrepaymentVo();
                        customerPrepaymentVo.setDetailPlanItemCode(vo.getPlanningDetailsNo());
                        customerPrepaymentVo.setPrepaidAmountApplied(vo.getPrepaidAmountApplied());
                        result.add(customerPrepaymentVo);
                    }
                    return result;
                } else {
                    return customerPrepaymentService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
                }
                //活动预付
            } else if (dto.getPrepaymentType().equals(CUSTOMER.getCode())){
                return customerPrepaymentService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
                //电商预付
            } else if (dto.getPrepaymentType().equals(PayInAdvanceEnum.SUPPLIER.getCode())){
                List<PrepaidBySupplierVo> voList = prepaidBySupplierService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
                List<CustomerPrepaymentVo> result = new ArrayList<>();
                for(PrepaidBySupplierVo vo : voList){
                    CustomerPrepaymentVo customerPrepaymentVo = new CustomerPrepaymentVo();
                    customerPrepaymentVo.setDetailPlanItemCode(vo.getPlanningDetailsNo());
                    customerPrepaymentVo.setPrepaidAmountApplied(vo.getPrepaidAmountApplied());
                    result.add(customerPrepaymentVo);
                }
                return result;
                //供应商物料预付
            } else if (dto.getPrepaymentType().equals(PayInAdvanceEnum.MATERIAL.getCode())){
                List<MaterialProcurementVo> byPrepaid = materialProcurementService.findTotalPrepaidAmountByDetailPlanItemList(dto.getDetailPlanItemCodeList(), ProcessStatusEnum.PASS.getDictCode());
                List<CustomerPrepaymentVo> result = new ArrayList<>();
                for(MaterialProcurementVo vo : byPrepaid){
                    CustomerPrepaymentVo customerPrepaymentVo = new CustomerPrepaymentVo();
                    customerPrepaymentVo.setDetailPlanItemCode(vo.getCode());
                    customerPrepaymentVo.setPrepaidAmountApplied(vo.getPrepaidAmountApplied());
                    result.add(customerPrepaymentVo);
                }
                return result;
            }
        }
        return new ArrayList<>();
    }

    @Override
    public List<CustomerPrepaymentVo> findActivityPrepaymentByDetailPlanItemCodes(List<String> detailPlanItemCodes) {
        if(CollectionUtils.isEmpty(detailPlanItemCodes)){
            return Lists.newArrayList();
        }
        return this.eventPrepaymentRepository.findActivityPrepaymentByDetailPlanItemCodes(detailPlanItemCodes);
    }

    @Override
    public List<String> findProcessDateByActivityDetailCodes(String detailPlanItemCode) {

        if(StringUtils.isEmpty(detailPlanItemCode)){
            return Lists.newArrayList();
        }
        List<Date> processDate = this.eventPrepaymentRepository.findProcessDateByActivityDetailCodes(detailPlanItemCode);
        if(CollectionUtils.isEmpty(processDate)){
            return Lists.newArrayList();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return processDate.stream().map(df::format).collect(Collectors.toList());
    }

    private void constructPaymentReceipt(EventPrepaymentEntity receipt, EventPrepaymentStatusDetailVo vo){
        receipt.setCeProcessStatus(vo.getProcessStatus());
        receipt.setEasOrderId(vo.getEasOrderId());
        receipt.setFlowId(vo.getFlowId());
        receipt.setPayAccountCode(vo.getPayAccountCode());
        receipt.setEasCode(vo.getEasCode());
        receipt.setEasDesc(vo.getEasDesc());
        receipt.setEasMessage(vo.getEasMsg());
        receipt.setPaySuccessDate(vo.getPaySuccessDate());
        receipt.setSapVoucherNo(vo.getFkVoucherNo());
    }


    /**
     * 推送活动预付单到CE
     * @param eventPrepaymentVo
     */
    private Boolean eventPrePaymentPushToCe(EventPrepaymentVo eventPrepaymentVo){
        log.info("【活动预付】推送CE eventPrePaymentPushToCe 参数【{}】",JSON.toJSONString(eventPrepaymentVo));

//        //推送付款单到sap
        PaymentReceiptApplyDto paymentReceiptApplyDto = new PaymentReceiptApplyDto();

        //抬头构建
        PaymentReceiptHeadDto headDto = new PaymentReceiptHeadDto();
        //        //数据来源 固定4
        headDto.setDataFrom(DATA_FROM);
        headDto.setIsStartProcess(BooleanEnum.FALSE.getCapital());
        headDto.setOutDocument(eventPrepaymentVo.getPrepaidCoding());
        headDto.setBukrs(eventPrepaymentVo.getCompanyCode());
        //业务大类
        headDto.setTitle(TITLE);
        //利润中心
        String profitCenterCode = eventPrepaymentVo.getProfitCenterCode();
        if(StringUtils.isNotEmpty(profitCenterCode)&&profitCenterCode.startsWith(PROFIT_CENTER_PREFIX)){
            profitCenterCode = profitCenterCode.replace(PROFIT_CENTER_PREFIX, "");
        }
        headDto.setPrctr(profitCenterCode);
        //业务细类
        String expItm = eventPrepaymentVo.getBusinessExpItem();
        if (StringUtils.isNotBlank(expItm)){
            String[] split = expItm.split("--");
            expItm = split[1];
        }
        headDto.setExpItem(expItm);

        headDto.setExpItemTxt(eventPrepaymentVo.getBusinessExpItem());
        //交易货币
        headDto.setCurrency(eventPrepaymentVo.getTradeCurrency());
        headDto.setRate(new BigDecimal(eventPrepaymentVo.getExchangeRate()).setScale(2,BigDecimal.ROUND_DOWN));
        //经办人工号
        headDto.setCreatedBy(eventPrepaymentVo.getOperatorWorkNo());
        //报账人工号
        headDto.setApplicantNo(eventPrepaymentVo.getOperatorWorkNo());
        //付款方式
        headDto.setPayType(eventPrepaymentVo.getPaymentMethod());
        //审核部门
        headDto.setUseamtDept(eventPrepaymentVo.getAuditDepart());
        headDto.setApprAmount(eventPrepaymentVo.getCurrentAmount());
        //是否有合同
        headDto.setHasContract(eventPrepaymentVo.getWhetherContract());
        //合同编码
        headDto.setDescription(eventPrepaymentVo.getExpenseContent());

        paymentReceiptApplyDto.setHead(headDto);

        //活动明细数据
//        List<CustomerPrepaymentVo> customerPrepayment = eventPrepaymentVo.getCustomerPrepayment();

        //供应商信息
        List<MaterialInformationVo> materialInformation = eventPrepaymentVo.getMaterialInformation();

        //费用明细列表
        List<PaymentReceiptFeeDetailDto> fees = new ArrayList<>();

        //付款明细列表
        List<PaymentReceiptDetailDto> details = new ArrayList<>();

        if (!CollectionUtils.isEmpty(materialInformation)){
            for (int i = 0; i < materialInformation.size(); i++) {
                PaymentReceiptFeeDetailDto paymentReceiptFeeDetailDto = new PaymentReceiptFeeDetailDto();
                MaterialInformationVo materialInformationVo = materialInformation.get(i);
                paymentReceiptFeeDetailDto.setSeq(i + 1);
                paymentReceiptFeeDetailDto.setReserve(materialInformationVo.getId());
                paymentReceiptFeeDetailDto.setAccountType(ACCOUNT_TYPE);
                paymentReceiptFeeDetailDto.setLifnr(materialInformationVo.getSupplierCode());
                paymentReceiptFeeDetailDto.setLifnrTxt(materialInformationVo.getSupplierName());
                paymentReceiptFeeDetailDto.setBankl(materialInformationVo.getUnionPayBankCard());
                paymentReceiptFeeDetailDto.setBanka(materialInformationVo.getBankAccount());
                paymentReceiptFeeDetailDto.setBankn(materialInformationVo.getBankCard());
                paymentReceiptFeeDetailDto.setKoinh(materialInformationVo.getAccountName());
                paymentReceiptFeeDetailDto.setPayAmount(materialInformationVo.getPrepaidAmount() == null ? BigDecimal.ZERO : materialInformationVo.getPrepaidAmount());
                paymentReceiptFeeDetailDto.setHopePayDate(materialInformationVo.getExpectedDate() == null ? null : DateUtil.formatDate(materialInformationVo.getExpectedDate()));
                paymentReceiptFeeDetailDto.setContract(materialInformationVo.getContractNo());
                paymentReceiptFeeDetailDto.setContractName(materialInformationVo.getContractName());
//                paymentReceiptFeeDetailDto.setBanpiaots(Integer.valueOf(materialInformationVo.getTerm()));
                fees.add(paymentReceiptFeeDetailDto);

                PaymentReceiptDetailDto paymentReceiptDetailDto = new PaymentReceiptDetailDto();
                paymentReceiptDetailDto.setSeq(i + 1);
                paymentReceiptDetailDto.setReserve(materialInformationVo.getId());
                paymentReceiptDetailDto.setPaymentDesc(materialInformationVo.getPaymentDigest());
                paymentReceiptDetailDto.setPaymentDescTxt(materialInformationVo.getPaymentDigest());
                paymentReceiptDetailDto.setAmount(materialInformationVo.getPrepaidAmount() == null ? BigDecimal.ZERO : materialInformationVo.getPrepaidAmount());
                //利润中心
                String profitCenterCodeDetail = materialInformationVo.getProfitCenter();
                if(StringUtils.isNotEmpty(profitCenterCodeDetail) && profitCenterCodeDetail.startsWith(PROFIT_CENTER_PREFIX)){
                    profitCenterCodeDetail = profitCenterCodeDetail.replace(PROFIT_CENTER_PREFIX, "");
                }
                paymentReceiptDetailDto.setPrctr(profitCenterCodeDetail);
                paymentReceiptDetailDto.setReason(materialInformationVo.getReasonCode());
                paymentReceiptDetailDto.setReasonTxt(materialInformationVo.getReasonName());
                paymentReceiptDetailDto.setFundOutputProject(materialInformationVo.getCapitalOutflowProject());
                paymentReceiptDetailDto.setFundOutputProjectTxt(materialInformationVo.getCapitalOutflowProjectName());
                details.add(paymentReceiptDetailDto);
            }
        }
        paymentReceiptApplyDto.setFees(fees);
        paymentReceiptApplyDto.setDetails(details);

        log.info("活动预付管理推送CE接口开始 参数【{}】", JSON.toJSONString(paymentReceiptApplyDto));
        Result<PaymentReceiptResultVo> receiptResultVoResult = sapSdApiService.pushPaymentReceipt(paymentReceiptApplyDto);
        log.info("活动预付管理推送CE接口结束 响应【{}】",JSON.toJSONString(receiptResultVoResult));
        if (receiptResultVoResult.isSuccess()) {
            PaymentReceiptResultVo result = receiptResultVoResult.getResult();
            if (StringUtils.equals(result.getMsgCode(), RequestCERespCodeEnum.SUCCESS.getCode())){
                log.info("推送CE接口成功");
                Optional<String> stringOptional = Optional.ofNullable(receiptResultVoResult.getResult()).map(x -> x.getProcessInstanceId());
                stringOptional.ifPresent(x -> {
                    eventPrepaymentVo.setReturnDocCode(x);
                    this.eventPrepaymentRepository.lambdaUpdate()
                            .eq(EventPrepaymentEntity::getId,eventPrepaymentVo.getId())
                            .set(EventPrepaymentEntity::getReturnDocCode,x)
                            .update();
                });
                return Boolean.TRUE;
            }else {
                log.info("推送CE接口失败");
            }
        }
        return Boolean.FALSE;
    }

    /**
     * 活动预付上账费用池
     */
    private void eventPrePaymentPayFeePool(EventPrepaymentVo vo) {
        log.info("活动预付上账费用池 【{}】", JSON.toJSONString(vo));
        Assert.hasLength(vo.getBusinessUnitCode(), "活动预付[" + vo.getPrepaidCoding() + "]业务单元为空!");
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum(vo.getBusinessUnitCode());
        Assert.notNull(businessUnitEnum, "业务单元[" + vo.getBusinessUnitCode() + "]不合法!");
        switch (businessUnitEnum) {
            //子公司
            case SON_COMPANY:
                //垂直
            case VERTICAL:
                this.auditUpAccountSonCompany(vo);
                break;
            //主体
            case HEADQUARTERS:
                //电商
            case ONLINE:
                this.auditUpAccountHeadquarters(vo);
                break;
            default:
                throw new IllegalArgumentException("不支持的操作类型【" + businessUnitEnum + "】，请检查");
        }
    }

    /**
     * 调用总公司上账接口
     * @param eventPrepaymentVo
     */
    private void auditUpAccountHeadquarters(EventPrepaymentVo eventPrepaymentVo){
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum(eventPrepaymentVo.getBusinessUnitCode());
        switch (businessUnitEnum){
            case HEADQUARTERS:
                this.headUpAccount(eventPrepaymentVo);
                break;
            case ONLINE:
                this.onlineUpAccount(eventPrepaymentVo);
                break;
            default:
                throw new IllegalArgumentException("不支持的操作类型【" + businessUnitEnum + "】，请检查");
        }
    }

    /**
     * 总公司接口主体上账
     * @param eventPrepaymentVo
     */
    private void headUpAccount(EventPrepaymentVo eventPrepaymentVo){
        log.info("活动预付主体上账 【主体】");
//            主体
        AuditFeeUpAccountDto auditFeeUpAccountDto = new AuditFeeUpAccountDto();
        AuditFeeUpAccountDto.MessageHeader messageHeader = new AuditFeeUpAccountDto.MessageHeader();
        //抬头
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE(EventPrepaymentConstant.AUDIT_FEE_UP_ACCOUNT);
        messageHeader.setSENDER(SENDER);
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER(RECEIVER);

        List<CustomerPrepaymentVo> customerPrepayment = eventPrepaymentVo.getCustomerPrepayment();
        List<String> customerCodes = customerPrepayment.stream().map(o -> o.getCustomerCode()).collect(Collectors.toList());
        //(客户编码)
        Map<String, CustomerVo> customerVoMap = new HashMap<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(customerCodes)) {
            List<CustomerVo> customerVoList = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodes));
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }

        auditFeeUpAccountDto.setMessageHeader(messageHeader);

        List<AuditFeeUpAccountDto.Item1> item1List = new ArrayList<>();

        for (CustomerPrepaymentVo customerPrepaymentVo : customerPrepayment) {
            AuditFeeUpAccountDto.Item1 item1 = new AuditFeeUpAccountDto.Item1();
            CustomerVo customerVo = customerVoMap.get(customerPrepaymentVo.getCustomerCode());
            if (Objects.isNull(customerVo)){
                this.eventPrepaymentRepository.lambdaUpdate()
                        .eq(EventPrepaymentEntity::getPrepaidCoding,eventPrepaymentVo.getPrepaidCoding())
                        .set(EventPrepaymentEntity::getSapTransferCommitMessage,"未查询到客户编码【"+customerPrepaymentVo.getCustomerCode()+"】的信息")
                        .set(EventPrepaymentEntity::getSapTransferCommitStatus,CommitStatusEnum.COMMIT_FAIL.getCode())
                        .update();
                return;
            }
            item1.setKUNNR(customerVo.getErpCode());
            item1.setCAMP_ID(customerPrepaymentVo.getUpAccountCode());
            //物料
            item1.setMATNR(customerPrepaymentVo.getProductCode());
            // 批复类型
            item1.setZFLAG(ZFLAG);
            // 客户所属销售部门
            item1.setVKBUR(customerVo.getSalesRegionErpCode());
            // 客户所属销售机构
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            // 起始日期
//            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            try {
                item1.setZFQSRQ(DateUtil.format(sdf.parse(customerPrepaymentVo.getActivityBeginDate()),"yyyyMMdd"));
                item1.setZFJSRQ(DateUtil.format(sdf.parse(customerPrepaymentVo.getActivityEndDate()),"yyyyMMdd"));
            } catch (ParseException e) {
                e.printStackTrace();
            }
//
//            item1.setZFQSRQ(sdf.format(customerPrepaymentVo.getActivityBeginDate()));
//            // 结束日期
//            item1.setZFJSRQ(sdf.format(customerPrepaymentVo.getActivityEndDate()));
            //条件类型
            item1.setKSCHL(null);
            // 金额
            item1.setDMBTR(customerPrepaymentVo.getPrepaidAmount().toPlainString());
            // 货币码
            item1.setWAERS(WAERS);
            //单据类型
            ActivityFormVo activityFormVo = activityFormService.findOneByCode(customerPrepaymentVo.getActivityFormCode());
            if (Objects.isNull(activityFormVo)){
                this.eventPrepaymentRepository.lambdaUpdate()
                        .eq(EventPrepaymentEntity::getPrepaidCoding,eventPrepaymentVo.getPrepaidCoding())
                        .set(EventPrepaymentEntity::getSapTransferCommitMessage,"活动形式编码【"+customerPrepaymentVo.getActivityFormCode()+"】未找到")
                        .set(EventPrepaymentEntity::getSapTransferCommitStatus,CommitStatusEnum.COMMIT_FAIL.getCode())
                        .update();
                return;
            }
            item1.setCAMP_DES(activityFormVo.getSapCode());
            //销售组
            item1.setVKGRP(customerVo.getSalesOrgErpCode());

            item1List.add(item1);
        }

        auditFeeUpAccountDto.setITEM1(item1List);
        sapSdApiService.auditFeeUpAccount(auditFeeUpAccountDto);
    }

    /**
     * 总公司接口电商上账
     * @param eventPrepaymentVo
     */
    private void onlineUpAccount(EventPrepaymentVo eventPrepaymentVo){
        log.info("活动预付电商上账 【主体】");
//            主体
        AuditFeeUpAccountDto auditFeeUpAccountDto = new AuditFeeUpAccountDto();
        AuditFeeUpAccountDto.MessageHeader messageHeader = new AuditFeeUpAccountDto.MessageHeader();
        //抬头
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE(EventPrepaymentConstant.AUDIT_FEE_UP_ACCOUNT);
        messageHeader.setSENDER(SENDER);
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER(RECEIVER);

        auditFeeUpAccountDto.setMessageHeader(messageHeader);


        List<PrepaidBySupplierVo> prepaidBySupplierVos = eventPrepaymentVo.getPrepaidBySupplier();

        List<String> customerCodes = prepaidBySupplierVos.stream().map(o -> o.getCustomerCode()).collect(Collectors.toList());
        //(客户编码)
        Map<String, CustomerVo> customerVoMap = new HashMap<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(customerCodes)) {
            List<CustomerVo> customerVoList = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodes));
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }

        List<String> detailCodes = prepaidBySupplierVos.stream().map(o -> o.getPlanningDetailsNo()).collect(Collectors.toList());
        List<GeneralExpensesDto> generalExpensesDtos = this.generalExpensesService.findByDetailCodeList(detailCodes);
        Map<String, GeneralExpensesDto> generalExpensesDtoMap = generalExpensesDtos
                .stream()
                .collect(Collectors.toMap(GeneralExpensesDto::getExpensesCode, Function.identity()));

        List<AuditFeeUpAccountDto.Item1> item1List = new ArrayList<>();

        for (PrepaidBySupplierVo prepaidBySupplierVo : prepaidBySupplierVos) {
            AuditFeeUpAccountDto.Item1 item1 = new AuditFeeUpAccountDto.Item1();
            CustomerVo customerVo = customerVoMap.get(prepaidBySupplierVo.getCustomerCode());
            GeneralExpensesDto generalExpensesDto = generalExpensesDtoMap.get(prepaidBySupplierVo.getPlanningDetailsNo());
            if (Objects.isNull(customerVo)){
                this.eventPrepaymentRepository.lambdaUpdate()
                        .eq(EventPrepaymentEntity::getPrepaidCoding,eventPrepaymentVo.getPrepaidCoding())
                        .set(EventPrepaymentEntity::getSapTransferCommitMessage,"未查询到客户编码【"+prepaidBySupplierVo.getCustomerCode()+"】的信息")
                        .set(EventPrepaymentEntity::getSapTransferCommitStatus,CommitStatusEnum.COMMIT_FAIL.getCode())
                        .update();
                return;
            }
            item1.setKUNNR(customerVo.getErpCode());
            item1.setCAMP_ID(prepaidBySupplierVo.getUpAccountCode());
            //物料
            item1.setMATNR(generalExpensesDto.getProductCode());
            // 批复类型
            item1.setZFLAG(ZFLAG);
            // 客户所属销售部门
            item1.setVKBUR(customerVo.getSalesRegionErpCode());
            // 客户所属销售机构
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            // 起始日期
            item1.setZFQSRQ(generalExpensesDto.getStartDate() == null ? null : DateUtil.format(generalExpensesDto.getStartDate(),"yyyyMMdd"));
            //            结束日期
            item1.setZFJSRQ(generalExpensesDto.getEndDate() == null ? null : DateUtil.format(generalExpensesDto.getEndDate(),"yyyyMMdd"));
            //条件类型
            item1.setKSCHL(null);
            // 金额
            item1.setDMBTR(prepaidBySupplierVo.getPrepaidAmount().toPlainString());
            // 货币码
            item1.setWAERS(WAERS);
            //单据类型
            ActivityFormVo activityFormVo = activityFormService.findOneByCode(generalExpensesDto.getActivityFormCode());
            if (Objects.isNull(activityFormVo)){
                this.eventPrepaymentRepository.lambdaUpdate()
                        .eq(EventPrepaymentEntity::getPrepaidCoding,eventPrepaymentVo.getPrepaidCoding())
                        .set(EventPrepaymentEntity::getSapTransferCommitMessage,"活动形式编码【"+generalExpensesDto.getActivityFormCode()+"】未找到")
                        .set(EventPrepaymentEntity::getSapTransferCommitStatus,CommitStatusEnum.COMMIT_FAIL.getCode())
                        .update();
                return;
            }
            item1.setCAMP_DES(activityFormVo.getSapCode());
            //销售组
            item1.setVKGRP(customerVo.getSalesOrgErpCode());

            item1List.add(item1);
        }

        auditFeeUpAccountDto.setITEM1(item1List);
        sapSdApiService.auditFeeUpAccount(auditFeeUpAccountDto);
    }

    /**
     * 分子公司上账
     * @param eventPrepaymentVo
     */
    private void auditUpAccountSonCompany(EventPrepaymentVo eventPrepaymentVo){
        log.info("活动预付上账 【分子公司】");
        //分子公司
        AuditFeeUpAccountSonCompanyDto auditFeeUpAccountSonCompanyDto = new AuditFeeUpAccountSonCompanyDto();
        AuditFeeUpAccountSonCompanyDto.MessageHeader messageHeader = new AuditFeeUpAccountSonCompanyDto.MessageHeader();
        //抬头
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE(EventPrepaymentConstant.AUDIT_FEE_UP_ACCOUNT_SON);
        messageHeader.setSENDER(SENDER);
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER(RECEIVER);
        auditFeeUpAccountSonCompanyDto.setMessageHeader(messageHeader);

        List<CustomerPrepaymentVo> customerPrepayment = eventPrepaymentVo.getCustomerPrepayment();
        List<String> customerCodes = customerPrepayment.stream().map(CustomerPrepaymentVo::getCustomerCode).collect(Collectors.toList());
        //(客户编码)
        Map<String, CustomerVo> customerVoMap = new HashMap<>();
        if(CollectionUtil.isNotEmpty(customerCodes)) {
            if (StringUtils.equals(eventPrepaymentVo.getBusinessUnitCode(),BusinessUnitEnum.SON_COMPANY.getCode())){
                List<CustomerVo> customerMdgCodes = customerVoService.findByCustomerMdgCodes(new ArrayList<>(customerCodes));
                Map<String, List<CustomerVo>> customerVoListMap = customerMdgCodes.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
                for (CustomerPrepaymentVo prepaymentVo : customerPrepayment) {
                    List<CustomerVo> customerVos = customerVoListMap.get(prepaymentVo.getCustomerCode());
                    if (CollectionUtil.isEmpty(customerVos)){
                        continue;
                    }
                    log.info("查询到的客户[{}]信息【{}】",prepaymentVo.getCustomerCode(),JSON.toJSONString(customerVos));
                    List<CustomerVo> customerVo = customerVos.stream().filter(o -> StringUtils.equals(o.getCustomerChannelCode(), prepaymentVo.getChannelCode())
                            && StringUtils.equals(o.getBusinessFormatCode(), eventPrepaymentVo.getBusinessFormatCode())
                            && StringUtils.equals(o.getSalesInstitutionCode(), prepaymentVo.getSalesOrgCode())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(customerVo)){
                        continue;
                    }
                    customerVoMap.put(prepaymentVo.getCustomerCode(),customerVo.get(0));
                }
            }else {
                List<CustomerVo> customerVoList = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodes));
                customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            }
        }


        List<AuditFeeUpAccountSonCompanyDto.Item1> item1List = new ArrayList<>();
        List<DictDataVo> dictDataVoList = dictDataVoService.findByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_FORMAT);
        Map<String, DictDataVo> dictDataVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(dictDataVoList)) {
            dictDataVoMap.putAll(dictDataVoList.stream().filter(k -> StringUtils.isNotEmpty(k.getDictCode()))
                    .collect(Collectors.toMap(DictDataVo::getDictCode, v -> v, (newValue, oldValue) -> newValue)));
        }

        List<String> activityFormCodeList = customerPrepayment.stream()
                .filter(k->StringUtils.isNotEmpty(k.getActivityFormCode()))
                .map(CustomerPrepaymentVo::getActivityFormCode)
                .distinct().collect(Collectors.toList());

        Map<String, ActivityFormVo> activityFormVoMap = Maps.newHashMap();
        if(CollectionUtil.isNotEmpty(activityFormCodeList)){
            List<ActivityFormVo> activityFormVoList = activityFormService.findByCodes(activityFormCodeList);
            if (CollectionUtil.isNotEmpty(activityFormVoList)){
                activityFormVoMap.putAll(activityFormVoList.stream()
                        .filter(k -> StringUtils.isNotEmpty(k.getActivityFormCode()))
                        .collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, v -> v, (newValue, oldValue) -> newValue)));
            }

        }


        for (CustomerPrepaymentVo item : customerPrepayment) {
            AuditFeeUpAccountSonCompanyDto.Item1 item1 = new AuditFeeUpAccountSonCompanyDto.Item1();
            // TPM核销单号
            item1.setZFTPMHXD(item.getCustomerPrepaymentDetailCode());
            // 核销单类型
            item1.setZFHXDLX(ZFHXDLX);
            //获取客户信息
            CustomerVo customerVo = customerVoMap.get(item.getCustomerCode());

            if (Objects.isNull(customerVo)){
                String errorMsg = "未查询到客户编码【"+item.getCustomerCode()+"】的信息";
                this.eventPrepaymentRepository.updateSapTransferCommitMessage(eventPrepaymentVo,errorMsg);
                return;
            }

            //客户编号
            item1.setKUNNR(customerVo.getErpCode());
            //原始金额
            item1.setZFAMT1(item.getPrepaidAmount() == null ? "0" : item.getPrepaidAmount().abs().toPlainString());

            Calendar now = Calendar.getInstance();
            // 财年
            item1.setGJAHR(String.valueOf(now.get(Calendar.YEAR)));
            // 会计期间
            item1.setMONAT(String.valueOf(now.get(Calendar.MONTH)+1));

            //客户所属销售机构
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            //分销渠道
            item1.setVTWEG(customerVo.getCustomerChannelCode());

            // 促销活动行项目号
            if(BusinessUnitEnum.VERTICAL.getCode().equals(eventPrepaymentVo.getBusinessUnitCode())) {
                // 促销活动号
                item1.setZFCXHD(item.getActivityDetailItemCode());
                item1.setZFCXHDI(item.getActivityDetailItemCode() + "0001");
            }else if(BusinessUnitEnum.SON_COMPANY.getCode().equals(eventPrepaymentVo.getBusinessUnitCode())){
                // 促销活动号
                item1.setZFCXHD(StringUtils.substring(item.getActivityDetailItemCode(),0,item.getActivityDetailItemCode().length()-4));
                item1.setZFCXHDI(item.getActivityDetailItemCode());
            }
            ActivityFormVo activityFormVo = activityFormVoMap.get(item.getActivityFormCode());
            if (Objects.isNull(activityFormVo)) {
                String errorMsg = "活动形式编码【" + item.getActivityFormCode() + "】未找到";
                this.eventPrepaymentRepository.updateSapTransferCommitMessage(eventPrepaymentVo, errorMsg);
                return;
            }
            // 促销形式
            item1.setZFCXXS(activityFormVo.getSapCode());
            //活动起始日
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            try {
                item1.setZFHDBEGIN(DateUtil.format(sdf.parse(item.getActivityBeginDate()),"yyyyMMdd"));
                item1.setZFHDEND(DateUtil.format(sdf.parse(item.getActivityEndDate()),"yyyyMMdd"));
            } catch (ParseException e) {
                e.printStackTrace();
            }

            //活动结束日
            DictDataVo businessFormatCodeVo = dictDataVoMap.get(eventPrepaymentVo.getBusinessFormatCode());
            if (Objects.isNull(businessFormatCodeVo)) {
                String errorMsg = "未查询到业态【" + eventPrepaymentVo.getBusinessFormatCode() + "】的数据字典";
                this.eventPrepaymentRepository.updateSapTransferCommitMessage(eventPrepaymentVo, errorMsg);
                return;
            }
            Map<String, String> extendMap = businessFormatCodeVo.getExtendMap();
            if (extendMap != null) {
                String zfyt = extendMap.get(DictTypeCodeConstant.MDM_BUSINESS_FORMAT_ZFYT);
                // 业态
                item1.setZFYT(zfyt);
            }
            // 考核月份
            item1.setZKHYF(null);
            //考核项目描述
            item1.setZKHMS(null);
            //物料编号
            item1.setMATNR(null);
            //品牌
            item1.setZFPP(null);
            //品类
            item1.setZFPL(null);
            // 品项
            item1.setZFPX(null);
            // 活动方案描述
            item1.setZFHDLD(null);
            //门店
            item1.setZFMED(null);

            item1List.add(item1);

        }
        auditFeeUpAccountSonCompanyDto.setITEM1(item1List);
        sapSdApiService.auditFeeUpAccountSonCompany(auditFeeUpAccountSonCompanyDto);
    }



    /**
     * 活动预付对接审批流
     *
     * @param dto
     * @return String
     * @author xaioyoujun
     * @date 2022/11/18 14:36
     **/
    private void adjustSubmit(EventPrepaymentDto dto, ProcessBusinessDto processBusiness) {
        processBusiness.setBusinessNo(dto.getPrepaidCoding());
        JSONObject jsonObject = JsonUtils.toJSONObject(dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode(EventPrepaymentConstant.EVENT_PREPAYMENT_PROCESS);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);

        EventPrepaymentEntity entity = new EventPrepaymentEntity();
        entity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        entity.setProcessInstanceId(processBusinessVo.getProcessNo());
        entity.setId(dto.getId());
        this.eventPrepaymentRepository.updateById(entity);

    }
    /**
     *新增验证
     * @param eventPrepaymentDto 实体对象
     */
    private void createValidate(EventPrepaymentDto eventPrepaymentDto) {
        Validate.notNull(eventPrepaymentDto, "对象信息不能为空！");
        Validate.notBlank(eventPrepaymentDto.getBusinessFormatCode(), "业态，不能为空！");
        Validate.notBlank(eventPrepaymentDto.getBusinessUnitCode(), "业务单元，不能为空！");
        Validate.notBlank(eventPrepaymentDto.getPrepaymentType(), "预付类型，不能为空！");
        Validate.notBlank(eventPrepaymentDto.getPrepaymentName(), "预付名称，不能为空！");
        Validate.notNull(eventPrepaymentDto.getPrepaymentDate(), "预付年月，不能为空！");
        //折扣预付不需要校验
        if (!eventPrepaymentDto.getPrepaymentType().equals(PayInAdvanceEnum.ACTIVITY.getCode())) {
            Validate.notBlank(eventPrepaymentDto.getCompanyCode(), "公司编码，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getBusinessTitle(), "业务大类，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getProfitCenter(), "利润中心，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getBusinessExpItem(), "业务细类，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getTradeCurrency(), "交易货币，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getExchangeRate(), "汇率，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getOperatorWorkNo(), "经办人工号，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getReimburserWorkNo(), "报账人工号，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getPaymentMethod(), "付款方式，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getAuditDepart(), "FSSC审核部门，不能为空！");
            Validate.notBlank(eventPrepaymentDto.getExpenseContent(), "开支内容，不能为空！");
        }
    }

    private void checkPrepaidAmount(EventPrepaymentDto eventPrepaymentDto) {
        //1027879  当活动预付管理中本次预付金额输入为负数时，自动变为0
        if (!CollectionUtils.isEmpty(eventPrepaymentDto.getCustomerPrepayment())) {
            for (CustomerPrepaymentDto customerPrepaymentDto : eventPrepaymentDto.getCustomerPrepayment()) {
                if (Objects.isNull(customerPrepaymentDto.getPrepaidAmount())) {
                    continue;
                }
                if (customerPrepaymentDto.getPrepaidAmount().compareTo(BigDecimal.ZERO) < 0) {
                    customerPrepaymentDto.setPrepaidAmount(BigDecimal.ZERO);
                }
            }
        }
    }
}
