package com.biz.crm.tpm.business.event.prepayment.local.service.internal;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.event.prepayment.local.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.event.prepayment.local.constant.EventPrepaymentConstant;
import com.biz.crm.tpm.business.event.prepayment.local.entity.CustomerPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.entity.MaterialInformationEntity;
import com.biz.crm.tpm.business.event.prepayment.local.entity.PaymentDetailEntity;
import com.biz.crm.tpm.business.event.prepayment.local.repository.MaterialInformationRepository;
import com.biz.crm.tpm.business.event.prepayment.local.repository.PaymentDetailRepository;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.CustomerPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.MaterialInformationDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.log.MaterialInformationLogEventDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.MaterialInformationLogEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.MaterialInformationService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.MaterialInformationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 供应商数据(PrepaidCustomerEntity)服务实现类
 *
 * @author xiaoyoujun
 * @date 2022年11月30日
 */
@Service("prepaidCustomerService")
public class MaterialInformationServiceImpl implements MaterialInformationService {

    @Autowired(required = false)
    private MaterialInformationRepository materialInformationRepository;

    @Autowired(required = false)
    private PaymentDetailRepository paymentDetailRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Resource
    private DictToolkitService dictToolkitService;


    /**
     * 新增数据
     * @param list 实体对象
     * @return 新增结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void create(List<MaterialInformationDto> list, EventPrepaymentDto dto) {
        Validate.notNull(dto, "对象不能为空!");
        Validate.notEmpty(list, "明细不能为空!");
        list.forEach(item -> {
            if (YesOrNoEnum.YES.getCode().equals(dto.getWhetherContract())) {
                Validate.notBlank(item.getContractNo(), "合同必填");
            }
        });
        List<String> codeList = generateCodeService.generateCode(EventPrepaymentConstant.MATERIAL_INFORMATION_CODE, list.size(), 5, 2, TimeUnit.DAYS);
        for (int i = 0; i < list.size(); i++) {
            list.get(i).setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            list.get(i).setTenantCode(TenantUtils.getTenantCode());
            list.get(i).setPrepaidCoding(dto.getPrepaidCoding());
            list.get(i).setPayCode(codeList.get(i));
        }
        //保存
        Collection<PaymentDetailEntity> paymentDetailEntities = this.nebulaToolkitService.copyCollectionByWhiteList(list, MaterialInformationDto.class, PaymentDetailEntity.class, LinkedHashSet.class, ArrayList.class);
        Map<String, String> causeCode = dictToolkitService.findMapByDictTypeCode(DictTypeCodeConstant.TPM_CAUSE_CODE);
        Map<String, String> outFlowItem = dictToolkitService.findMapByDictTypeCode(DictTypeCodeConstant.TPM_OUTFLOW_IEM);
        for (PaymentDetailEntity paymentDetailEntity : paymentDetailEntities) {
            paymentDetailEntity.setReasonName(causeCode.get(paymentDetailEntity.getReasonCode()));
            paymentDetailEntity.setCapitalOutflowProjectName(outFlowItem.get(paymentDetailEntity.getCapitalOutflowProject()));
        }
        Collection<MaterialInformationEntity> entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, MaterialInformationDto.class, MaterialInformationEntity.class, LinkedHashSet.class, ArrayList.class);
        this.materialInformationRepository.saveBatch(entities);
        this.paymentDetailRepository.saveBatch(paymentDetailEntities);
    }

    /**
     * 删除数据
     * @param ids 主键结合
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "删除数据时，主键集合不能为空！");
        List<MaterialInformationEntity> prepaidCustomerEntities = this.materialInformationRepository.listByIds(ids);
        Validate.notEmpty(prepaidCustomerEntities, "根据提供的主键集合信息，未能获取到相应数据");
        this.materialInformationRepository.removeByIds(ids);

        //删除业务日志
        Collection<MaterialInformationDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(prepaidCustomerEntities,
                MaterialInformationEntity.class, MaterialInformationDto.class, HashSet.class, ArrayList.class);
        SerializableBiConsumer<MaterialInformationLogEventListener, MaterialInformationLogEventDto> onDelete =
                MaterialInformationLogEventListener::onDelete;
        for (MaterialInformationDto dto : dtoList) {
            MaterialInformationLogEventDto logEventDto = new MaterialInformationLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish(logEventDto, MaterialInformationLogEventListener.class, onDelete);
        }
    }
    /**
     * 修改数据
     * @param list 实体对象
     * @return 修改结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(List<MaterialInformationDto> list, EventPrepaymentDto eventPrepaymentDto) {
        List<String> codeListDto = list.stream().filter(e -> e.getPayCode() != null).map(e -> e.getPayCode()).collect(Collectors.toList());
        List<MaterialInformationDto> newListDto = list.stream().filter(e -> StringUtils.isBlank(e.getPayCode())).collect(Collectors.toList());
        //删除
        materialInformationRepository.deleteByIdNotInList(codeListDto, eventPrepaymentDto.getPrepaidCoding());
        paymentDetailRepository.deleteByIdNotInList(codeListDto, eventPrepaymentDto.getPrepaidCoding());
        //新增
        if (!CollectionUtils.isEmpty(newListDto)) {
//            String ruleCode = StringUtils.join(EventPrepaymentConstant.MATERIAL_INFORMATION_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
            List<String> codeList = generateCodeService.generateCode(EventPrepaymentConstant.MATERIAL_INFORMATION_CODE, newListDto.size(), 5, 2, TimeUnit.DAYS);
            for (int i = 0; i < newListDto.size(); i++) {
                newListDto.get(i).setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                newListDto.get(i).setTenantCode(TenantUtils.getTenantCode());
                newListDto.get(i).setPrepaidCoding(eventPrepaymentDto.getPrepaidCoding());
                newListDto.get(i).setPayCode(codeList.get(i));
                if (YesOrNoEnum.YES.getCode().equals(eventPrepaymentDto.getWhetherContract())) {
                    Validate.notBlank(list.get(i).getContractNo(), "合同必填");
                }
            }
            list.removeAll(newListDto);
            Collection<PaymentDetailEntity> paymentDetailEntities = this.nebulaToolkitService.copyCollectionByWhiteList(newListDto, MaterialInformationDto.class, PaymentDetailEntity.class, LinkedHashSet.class, ArrayList.class);
            Collection<MaterialInformationEntity> entities = this.nebulaToolkitService.copyCollectionByWhiteList(newListDto, MaterialInformationDto.class, MaterialInformationEntity.class, LinkedHashSet.class, ArrayList.class);
            materialInformationRepository.saveBatch(entities);
            paymentDetailRepository.saveBatch(paymentDetailEntities);
        }

        if (!CollectionUtils.isEmpty(list)) {
            //修改
            Collection<MaterialInformationEntity> entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, MaterialInformationDto.class, MaterialInformationEntity.class, LinkedHashSet.class, ArrayList.class);
            entities.forEach(e -> {
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setPrepaidCoding(eventPrepaymentDto.getPrepaidCoding());
                if (YesOrNoEnum.YES.getCode().equals(eventPrepaymentDto.getWhetherContract())) {
                    Validate.notBlank(e.getContractNo(), "合同必填");
                }
            });
            materialInformationRepository.saveOrUpdateBatch(entities);
            paymentDetailRepository.updateList(list);
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public MaterialInformationVo findById(String id) {
        MaterialInformationEntity prepaidCustomerEntity = this.materialInformationRepository.getById(id);
        if (prepaidCustomerEntity==null){
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(prepaidCustomerEntity, MaterialInformationVo.class,LinkedHashSet.class, ArrayList.class);
    }
    /**
     * 通过预付编码查询单条数据
     *
     * @param prepaidCoding 预付编码
     * @return 单条数据
     */
    @Override
    public MaterialInformationVo findByPrepaidCoding(String prepaidCoding) {
        QueryWrapper<MaterialInformationEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("prepaid_coding",prepaidCoding);
        MaterialInformationEntity prepaidCustomerEntity = materialInformationRepository.getOne(wrapper);
        return this.nebulaToolkitService.copyObjectByWhiteList(prepaidCustomerEntity, MaterialInformationVo.class,LinkedHashSet.class, ArrayList.class);

    }

    /**
     * 通过预付编码查询多条数据
     *
     * @param prepaid 预付编码
     * @return 多条数据
     */
    @Override
    public List<MaterialInformationVo> findByPrepaid(String prepaid) {
        QueryWrapper<MaterialInformationEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("prepaid_coding",prepaid);
        List<MaterialInformationEntity> list = materialInformationRepository.list(wrapper);
        List<PaymentDetailEntity> listPd = paymentDetailRepository.lambdaQuery().eq(PaymentDetailEntity::getPrepaidCoding, prepaid).list();
        Collection<MaterialInformationVo> prepaidCustomerVos = nebulaToolkitService.copyCollectionByWhiteList(list, MaterialInformationEntity.class, MaterialInformationVo.class, LinkedHashSet.class, ArrayList.class);
        prepaidCustomerVos.forEach(e -> {
            for (PaymentDetailEntity pd : listPd) {
                if (e.getPayCode().equals(pd.getPayCode())) {
                    e.setCapitalOutflowProject(pd.getCapitalOutflowProject());
                    e.setPaymentDigest(pd.getPaymentDigest());
                    e.setProfitCenter(pd.getProfitCenter());
                    e.setReasonCode(pd.getReasonCode());
                    break;
                }
            }
        });
        return new ArrayList<>(prepaidCustomerVos);
    }
}
