package com.biz.crm.tpm.business.event.prepayment.local.service.internal;


import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.tpm.business.event.prepayment.local.entity.CustomerPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.entity.PrepaidBySupplierEntity;
import com.biz.crm.tpm.business.event.prepayment.local.repository.PrepaidBySupplierRepository;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.CustomerPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.PrepaidBySupplierDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.log.PrepaidBySupplierLogEventDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.PrepaidBySupplierLogEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.PrepaidBySupplierService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.PrepaidBySupplierVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.biz.crm.tpm.business.event.prepayment.local.constant.EventPrepaymentConstant.AUDIT_UP_ACCOUNT_DETAIL_PREFIX;

/**
 * 促销规划数据(PrepaidBySupplierEntity)服务实现类
 *
 * @author xiaoyoujun
 * @date 2022年11月18日 10:12
 */
@Service("prepaidBySupplierService")
public class PrepaidBySupplierServiceImpl implements PrepaidBySupplierService {

    @Autowired(required = false)
    private PrepaidBySupplierRepository prepaidBySupplierRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;


    /**
     * 新增数据
     * @param list 实体对象
     * @return 新增结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void create(List<PrepaidBySupplierDto> list, String code) {
        //校验是否有活动明细已申请预付，但是状态仍未审批通过
        List<String> detailPlanItemCodeList = list.stream().map(PrepaidBySupplierDto::getPlanningDetailsNo).collect(Collectors.toList());
        //获取客户的MDG编码
        Map<String, CustomerVo> customerVoMap = Maps.newHashMap();
        Set<String> customerCodeSet = list.stream().filter(e -> StringUtils.isNotBlank(e.getCustomerCode())).map(PrepaidBySupplierDto::getCustomerCode).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(customerCodeSet)) {
            List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (CollectionUtil.isNotEmpty(customerVos)) {
                customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            }
        }
        List<PrepaidBySupplierEntity> existEntityList = this.prepaidBySupplierRepository.findByPlanningDetailsNoListAndProcessStatus(detailPlanItemCodeList, ProcessStatusEnum.PASS.getDictCode());
        if (!CollectionUtils.isEmpty(existEntityList)) {
            throw new UnsupportedOperationException("已下促销规划明细存在未审批通过的预付数据：" + JSON.toJSONString(existEntityList.stream().map(PrepaidBySupplierEntity::getPlanningDetailsNo).collect(Collectors.toList())));
        }
        String detailCode = this.generateCodeService.generateCode(AUDIT_UP_ACCOUNT_DETAIL_PREFIX, 1, 9, 0, TimeUnit.DAYS).get(0);
        Map<String, CustomerVo> finalCustomerVoMap = customerVoMap;
        list.forEach(e -> {
//            if(e.getPrepaidAmountApplied().add(e.getPrepaidAmount()).compareTo(e.getRequestedAmount()) > 0){
//                throw new UnsupportedOperationException("【本次预付金额】应小于【申请金额】与【已预付金额】的差");
//            }
            if (StringUtils.isNotBlank(e.getCustomerCode())) {
                CustomerVo customerVo = finalCustomerVoMap.get(e.getCustomerCode());
                Validate.notNull(customerVo, "未找到客户编码【"+ e.getCustomerCode() +"】所对应的客户数据");
                e.setCustomerMdgCode(customerVo.getErpCode());
            }
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
            e.setPrepaidCoding(code);
            e.setUpAccountCode(detailCode);
            //获取明细编码已有预付数据，计算已预付金额
            List<PrepaidBySupplierEntity> hasPrepaidList = prepaidBySupplierRepository.findByPlanningDetailsNo(e.getPlanningDetailsNo());
            if(!CollectionUtils.isEmpty(hasPrepaidList)){
                e.setPrepaidAmountApplied(hasPrepaidList.stream().map(PrepaidBySupplierEntity::getPrepaidAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        });
        //保存
        Collection<PrepaidBySupplierEntity> entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, PrepaidBySupplierDto.class, PrepaidBySupplierEntity.class, LinkedHashSet.class, ArrayList.class);
        this.prepaidBySupplierRepository.saveOrUpdateBatch(entities);
    }

    /**
     * 删除数据
     * @param ids 主键结合
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "删除数据时，主键集合不能为空！");
        List<PrepaidBySupplierEntity> prepaidBySupplierEntities = this.prepaidBySupplierRepository.listByIds(ids);
        Validate.notEmpty(prepaidBySupplierEntities, "根据提供的主键集合信息，未能获取到相应数据");
        this.prepaidBySupplierRepository.removeByIds(ids);

        //删除业务日志
        Collection<PrepaidBySupplierDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(prepaidBySupplierEntities,
                PrepaidBySupplierEntity.class, PrepaidBySupplierDto.class, HashSet.class, ArrayList.class);
        SerializableBiConsumer<PrepaidBySupplierLogEventListener, PrepaidBySupplierLogEventDto> onDelete =
                PrepaidBySupplierLogEventListener::onDelete;
        for (PrepaidBySupplierDto dto : dtoList) {
            PrepaidBySupplierLogEventDto logEventDto = new PrepaidBySupplierLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish(logEventDto, PrepaidBySupplierLogEventListener.class, onDelete);
        }
    }
    /**
     * 修改数据
     * @param list 实体对象
     * @return 修改结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(List<PrepaidBySupplierDto> list, String code) {
        List<String> idListDto = list.stream().filter(e -> e.getId() != null).map(e -> e.getId()).collect(Collectors.toList());
        //获取客户的MDG编码
        Map<String, CustomerVo> customerVoMap = null;
        Set<String> customerCodeSet = list.stream().filter(e -> StringUtils.isNotBlank(e.getCustomerCode())).map(PrepaidBySupplierDto::getCustomerCode).collect(Collectors.toSet());
        List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodeSet));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(customerVos)) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        //删除
        prepaidBySupplierRepository.deleteByIdNotInList(idListDto, code);
        if (!CollectionUtils.isEmpty(list)) {
            //保存
            Collection<PrepaidBySupplierEntity> entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, PrepaidBySupplierDto.class, PrepaidBySupplierEntity.class, LinkedHashSet.class, ArrayList.class);
            Map<String, CustomerVo> finalCustomerVoMap = customerVoMap;
            entities.forEach(e -> {
//                if(e.getPrepaidAmountApplied().add(e.getPrepaidAmount()).compareTo(e.getRequestedAmount()) > 0){
//                    throw new UnsupportedOperationException("【本次预付金额】应小于【申请金额】与【已预付金额】的差");
//                }
                if (StringUtils.isNotBlank(e.getCustomerCode())) {
                    CustomerVo customerVo = finalCustomerVoMap.get(e.getCustomerCode());
                    Validate.notNull(customerVo, "未找到客户编码【"+ e.getCustomerCode() +"】所对应的客户数据");
                    e.setCustomerMdgCode(customerVo.getErpCode());
                }
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setPrepaidCoding(code);
            });
            this.prepaidBySupplierRepository.saveOrUpdateBatch(entities);
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public PrepaidBySupplierVo findById(String id) {
        PrepaidBySupplierEntity prepaidBySupplierEntity = this.prepaidBySupplierRepository.getById(id);
        if (prepaidBySupplierEntity==null){
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(prepaidBySupplierEntity,PrepaidBySupplierVo.class,LinkedHashSet.class, ArrayList.class);
    }
    /**
     * 通过预付编码查询单条数据
     *
     * @param prepaidCoding 预付编码
     * @return 单条数据
     */
    @Override
    public PrepaidBySupplierVo findByPrepaidCoding(String prepaidCoding) {
        QueryWrapper<PrepaidBySupplierEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("prepaid_coding",prepaidCoding);
        PrepaidBySupplierEntity prepaidBySupplierEntity = prepaidBySupplierRepository.getOne(wrapper);
        return this.nebulaToolkitService.copyObjectByWhiteList(prepaidBySupplierEntity, PrepaidBySupplierVo.class,LinkedHashSet.class, ArrayList.class);

    }

    /**
     * 通过预付编码查询多条数据
     *
     * @param prepaid 预付编码
     * @return 多条数据
     */
    @Override
    public List<PrepaidBySupplierVo> findByPrepaid(String prepaid) {
        QueryWrapper<PrepaidBySupplierEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("prepaid_coding",prepaid);
        List<PrepaidBySupplierEntity> list = prepaidBySupplierRepository.list(wrapper);
        Collection<PrepaidBySupplierVo> prepaidBySupplierVos = nebulaToolkitService.copyCollectionByWhiteList(list, PrepaidBySupplierEntity.class, PrepaidBySupplierVo.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(prepaidBySupplierVos);
    }

    @Override
    public List<PrepaidBySupplierVo> findTotalPrepaidAmountByDetailPlanItemList(List<String> detailPlanItemCodeList, String processCode) {
        return this.prepaidBySupplierRepository.findTotalPrepaidAmountByDetailPlanItemList(detailPlanItemCodeList, processCode);
    }
}
