package com.biz.crm.tpm.business.event.prepayment.local.service.notifier;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.MaterialProcurementDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.log.MaterialProcurementLogEventDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.MaterialProcurementLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 业务单元事件通知
 *
 * @author: xiaoyoujun
 * @version: v1.0.0
 * @date: 2022.11.26 16:26
 */
@Component
public class MaterialProcurementLogEventListenerImpl implements MaterialProcurementLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;


    /**
     * 创建
     *
     * @param dto
     */
    @Override
    public void onCreate(MaterialProcurementLogEventDto dto) {
        // 新对象
        MaterialProcurementDto newest = dto.getNewest();
        // 旧对象
        MaterialProcurementDto original = dto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 删除
     *
     * @param dto
     */
    @Override
    public void onDelete(MaterialProcurementLogEventDto dto) {
        // 新对象
        MaterialProcurementDto newest = dto.getNewest();
        // 旧对象
        MaterialProcurementDto original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 更新
     *
     * @param dto
     */
    @Override
    public void onUpdate(MaterialProcurementLogEventDto dto) {
        // 新对象
        MaterialProcurementDto newest = dto.getNewest();
        // 旧对象
        MaterialProcurementDto original = dto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
