package com.biz.crm.tpm.business.event.prepayment.local.workFlowListener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.event.prepayment.local.constant.EventPrepaymentConstant;
import com.biz.crm.tpm.business.event.prepayment.local.entity.EventPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.repository.EventPrepaymentRepository;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.EventPerpaymentEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.EventPrepaymentService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 活动预付流程回调
 *
 * @author: yaoyongming
 * @date: 2022/12/26 11:29
 */
@Component
@Slf4j
public class EventPrepaymentProcessCallBackListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private EventPrepaymentRepository eventPrepaymentRepository;

    @Autowired
    private EventPrepaymentService eventPrepaymentService;

    @Autowired(required = false)
    private List<EventPerpaymentEventListener> eventListeners;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    /**
     * 获取流程业务编号(默认为空)
     */
    @Override
    public String getBusinessCode() {
        return EventPrepaymentConstant.EVENT_PREPAYMENT_PROCESS;
    }

    /**
     * 当流程开始后触发该事件
     *
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        String processStatus = dto.getProcessStatus();
        EventPrepaymentEntity one = eventPrepaymentRepository.lambdaQuery()
                .eq(EventPrepaymentEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(EventPrepaymentEntity::getPrepaidCoding, dto.getBusinessNo())
                .one();
        //校验回调实例
        Validate.notNull(one, "促销规划审批流程回调失败，未查询到当前实例");
        EventPrepaymentVo eventPrepaymentVo = this.eventPrepaymentService.findByPrepaidCoding(one.getPrepaidCoding());
        eventPrepaymentVo.setProcessStatus(processStatus);
        //审批通过
        one.setProcessStatus(processStatus);
        log.info("活动预付流程结束 参数【{}】", JSON.toJSONString(dto));
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            //异步推送数据
            Date dateNow = new Date();
            MqMessageVo mqMessage = new MqMessageVo();
            one.setProcessDate(dateNow);
            eventPrepaymentVo.setProcessDate(dateNow);
            //数据
            mqMessage.setMsgBody(JsonUtils.obj2JsonString(eventPrepaymentVo));
            //MQ标签
            mqMessage.setTag(EventPrepaymentConstant.TPM_EVENT_PRE_PAYMENT_PUSH_DATA_TAG);
            mqMessage.setTopic(EventPrepaymentConstant.TPM_EVENT_PRE_PAYMENT_PUSH_DATA_TOPIC.concat(RocketMqUtil.mqEnvironment()));
            rocketMqProducer.sendMqMsg(mqMessage, 10);

        }
        this.eventPrepaymentRepository.updateById(one);
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (EventPerpaymentEventListener listener : eventListeners) {
                listener.onUpdateProcessStatus(processStatus, Lists.newArrayList(eventPrepaymentVo));
            }
        }
    }
}
