/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.event.prepayment.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptQueryStatusDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.CommercePrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentSubmitDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.PurchaseOrderDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.TotalPrepaidAmountDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.EventPrepaymentService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.CustomerPrepaymentVo;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/event/prepayment"})
@Api(tags={"\u6d3b\u52a8\u9884\u4ed8\u7ba1\u7406"})
public class EventPrepaymentController {
    private static final Logger log = LoggerFactory.getLogger(EventPrepaymentController.class);
    @Autowired(required=false)
    private EventPrepaymentService eventPrepaymentService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByPrepayments"})
    public Result<Page<EventPrepaymentVo>> findByPrepayments(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="eventPrepaymentDto", value="\u6d3b\u52a8\u9884\u4ed8") EventPrepaymentDto eventPrepaymentDto) {
        try {
            Page page = this.eventPrepaymentService.findByPrepayments(pageable, eventPrepaymentDto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping(value={"create"})
    public Result<EventPrepaymentVo> create(@ApiParam(name="eventPrepaymentDto", value="\u6d3b\u52a8\u9884\u4ed8\u7ba1\u7406") @RequestBody EventPrepaymentDto eventPrepaymentDto) {
        try {
            EventPrepaymentVo eventPrepaymentVo = this.eventPrepaymentService.create(eventPrepaymentDto);
            return Result.ok((Object)eventPrepaymentVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping(value={"delete"})
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.eventPrepaymentService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<EventPrepaymentVo> update(@ApiParam(name="eventPrepaymentDto", value="\u6d3b\u52a8\u9884\u4ed8") @RequestBody EventPrepaymentDto eventPrepaymentDto) {
        try {
            EventPrepaymentVo update = this.eventPrepaymentService.update(eventPrepaymentDto);
            return Result.ok((Object)update);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{prepaidCoding}"})
    public Result<EventPrepaymentVo> findById(@PathVariable @ApiParam(name="prepaidCoding", value="\u9884\u4ed8\u7f16\u7801", required=true) String prepaidCoding) {
        try {
            EventPrepaymentVo eventPrepaymentVo = this.eventPrepaymentService.findByPrepaidCoding(prepaidCoding);
            return Result.ok((Object)eventPrepaymentVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"submit"})
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279")
    public Result<?> submit(@RequestBody EventPrepaymentSubmitDto eventPrepaymentSubmitDto) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            Validate.notNull((Object)eventPrepaymentSubmitDto.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01", (Object[])new Object[0]);
            lockKey = "event_prepayment:lock:approve:" + eventPrepaymentSubmitDto.getId();
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 3L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.eventPrepaymentService.submit(eventPrepaymentSubmitDto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"submitAndSetPass"})
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u63d0\u4ea4\u5ba1\u6279")
    public Result<?> submitAndSetPass(@RequestBody EventPrepaymentSubmitDto eventPrepaymentSubmitDto) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            if (StringUtils.isNotBlank((CharSequence)eventPrepaymentSubmitDto.getId())) {
                lockKey = "event_prepayment:lock:approve:" + eventPrepaymentSubmitDto.getId();
                lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 3L);
                Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            this.eventPrepaymentService.submitAndSetPass(eventPrepaymentSubmitDto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    @PostMapping(value={"promotionPlan"})
    @ApiOperation(value="\u83b7\u53d6\u4fc3\u9500\u89c4\u5212\u6570\u636e")
    public Result<?> promotionPlan(@RequestBody List<GeneralExpensesVo> promotionPlanDtos) {
        try {
            List prepaidBySupplierVos = this.eventPrepaymentService.promotionPlan(promotionPlanDtos);
            return Result.ok((Object)prepaidBySupplierVos);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"getSuppliers"})
    @ApiOperation(value="\u83b7\u53d6\u4f9b\u5e94\u5546\u6570\u636e")
    public Result<?> getSuppliers(@RequestBody List<CommercePrepaymentDto> commercePrepaymentDtos) {
        try {
            List commercePrepaymentVos = this.eventPrepaymentService.getSuppliers(commercePrepaymentDtos);
            return Result.ok((Object)commercePrepaymentVos);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"savePurchase"})
    @ApiOperation(value="\u63d0\u4ea4\u91c7\u8d2d\u5355\u6570\u636e")
    public Result<?> savePurchase(@RequestBody List<PurchaseOrderDto> purchaseOrderDtos) {
        try {
            List purchaseVos = this.eventPrepaymentService.savePurchase(purchaseOrderDtos);
            return Result.ok((Object)purchaseVos);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u624b\u52a8\u63a8\u9001CE")
    @PostMapping(value={"/pushEventPrepaymentToCEHandle"})
    public Result<?> pushEventPrepaymentToCEHandle(@ApiParam(name="ids", value="\u9884\u4ed8\u5355ID") @RequestBody List<String> ids) {
        boolean lockSuccess = false;
        try {
            Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
            lockSuccess = this.redisLockService.batchLock("EVENT:PREPAYMENT:PUSH:REDIS:LOCK:", ids, TimeUnit.MINUTES, 10);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            Map map = this.eventPrepaymentService.pushEventPrepaymentToCEHandle(ids);
            if (Objects.nonNull(map) && !map.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    sb.append("[").append((String)entry.getKey()).append("]:").append((String)entry.getValue()).append("\n");
                }
                Result result = Result.error((String)sb.toString());
                return result;
            }
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("EVENT:PREPAYMENT:PUSH:REDIS:LOCK:", ids);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u624b\u52a8\u63a8\u9001\u6298\u6263\u4e0a\u8d26")
    @PostMapping(value={"/pushEventPrepaymentToSAPHandle"})
    public Result<?> pushEventPrepaymentToSAPHandle(@ApiParam(name="id", value="\u9884\u4ed8\u5355ID") @RequestBody List<String> ids) {
        boolean lockSuccess = false;
        try {
            Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
            lockSuccess = this.redisLockService.batchLock("EVENT:PREPAYMENT:PUSH:REDIS:LOCK:", ids, TimeUnit.MINUTES, 10);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            Map map = this.eventPrepaymentService.pushEventPrepaymentToSAPHandle(ids);
            if (Objects.nonNull(map) && !map.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    sb.append("[").append((String)entry.getKey()).append("]:").append((String)entry.getValue()).append("\n");
                }
                Result result = Result.error((String)sb.toString());
                return result;
            }
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("EVENT:PREPAYMENT:PUSH:REDIS:LOCK:", ids);
            }
        }
    }

    @ApiOperation(value="\u67e5\u8be2CE\u72b6\u6001")
    @PostMapping(value={"/queryPaymentReceiptECStatus"})
    public Result<?> queryPaymentReceiptECStatus(@ApiParam(name="paymentReceiptQueryStatusDto", value="\u8bf7\u6c42\u53c2\u6570") @RequestBody PaymentReceiptQueryStatusDto paymentReceiptQueryStatusDto) {
        try {
            this.eventPrepaymentService.queryPaymentReceiptECStatus(paymentReceiptQueryStatusDto);
            return Result.ok((String)"\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u5df2\u9884\u4ed8\u91d1\u989d\u6570\u636e")
    @PostMapping(value={"findTotalPrepaidAmountByDetailPlanItemList"})
    public Result<List<CustomerPrepaymentVo>> findTotalPrepaidAmountByDetailPlanItemList(@RequestBody TotalPrepaidAmountDto dto) {
        try {
            return Result.ok((Object)this.eventPrepaymentService.findTotalPrepaidAmountByDetailPlanItemList(dto));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)e.getMessage());
        }
    }
}

