/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.event.prepayment.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.event.prepayment.local.entity.CustomerPrepaymentEntity;
import com.biz.crm.tpm.business.event.prepayment.local.enums.PayInAdvanceEnum;
import com.biz.crm.tpm.business.event.prepayment.local.repository.CustomerPrepaymentRepository;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.CustomerPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.log.CustomerPrepaymentLogEventDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.CustomerPrepaymentLogEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.CustomerPrepaymentService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.CustomerPrepaymentVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="customerPrepaymentService")
public class CustomerPrepaymentServiceImpl
implements CustomerPrepaymentService {
    @Autowired(required=false)
    private CustomerPrepaymentRepository customerPrepaymentRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    @Transactional(rollbackFor={Exception.class})
    public void create(List<CustomerPrepaymentDto> list, EventPrepaymentDto dto) {
        List<CustomerPrepaymentEntity> existEntityList;
        List customerVos;
        Validate.notNull((Object)dto, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notEmpty(list, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<String> detailPlanItemCodeList = list.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getActivityDetailItemCode())).map(CustomerPrepaymentDto::getActivityDetailItemCode).collect(Collectors.toList());
        Validate.notEmpty(detailPlanItemCodeList, (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Map<Object, Object> customerVoMap = Maps.newHashMap();
        Set customerCodeSet = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCustomerCode())).map(CustomerPrepaymentDto::getCustomerCode).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(customerCodeSet) && CollectionUtil.isNotEmpty((Collection)(customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (newValue, oldValue) -> newValue));
        }
        if (!CollectionUtils.isEmpty(existEntityList = this.customerPrepaymentRepository.findByActivityDetailItemCodeListAndProcessStatus(detailPlanItemCodeList, ProcessStatusEnum.PASS.getDictCode()))) {
            throw new UnsupportedOperationException("\u5df2\u4e0b\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u9884\u4ed8\u6570\u636e\uff1a" + JSON.toJSONString(existEntityList.stream().map(CustomerPrepaymentEntity::getActivityDetailItemCode).collect(Collectors.toList())));
        }
        ArrayList salesOrgCodeList = new ArrayList();
        HashMap finalCustomerVoMap = customerVoMap;
        list.forEach(e -> {
            Validate.notEmpty((CharSequence)e.getActivityDetailItemCode(), (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notNull((Object)e.getPrepaidAmount(), (String)"\u672c\u6b21\u9884\u4ed8\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)e.getActivityOrgCode())) {
                e.setSalesOrgCode(e.getActivityOrgCode());
                e.setSalesOrgName(e.getActivityOrgName());
            }
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
            e.setPrepaidCoding(dto.getPrepaidCoding());
            if (PayInAdvanceEnum.CUSTOMER.getCode().equals(dto.getPrepaymentType())) {
                Validate.notNull((Object)e.getFeeAmount(), (String)"\u7533\u8bf7\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
                Validate.isTrue((e.getFeeAmount().compareTo(e.getPrepaidAmount()) >= 0 ? 1 : 0) != 0, (String)"\u672c\u6b21\u9884\u4ed8\u91d1\u989d\u5fc5\u987b\u2264\u7533\u8bf7\u91d1\u989d", (Object[])new Object[0]);
            }
            if (StringUtils.isNotBlank((CharSequence)e.getCustomerCode()) && !BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
                CustomerVo customerVo = (CustomerVo)finalCustomerVoMap.get(e.getCustomerCode());
                Validate.notNull((Object)customerVo, (String)("\u672a\u627e\u5230\u5ba2\u6237\u7f16\u7801\u3010" + e.getCustomerCode() + "\u3011\u6240\u5bf9\u5e94\u7684\u5ba2\u6237\u6570\u636e"), (Object[])new Object[0]);
                e.setCustomerMdgCode(customerVo.getErpCode());
            }
            if (StringUtils.isEmpty((CharSequence)e.getSalesOrgName()) && StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCode())) {
                salesOrgCodeList.add(e.getSalesOrgCode());
            }
        });
        Set activityDetailItemCodeSet = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getActivityDetailItemCode())).map(CustomerPrepaymentDto::getActivityDetailItemCode).collect(Collectors.toSet());
        List<CustomerPrepaymentEntity> hasPrepaidList = this.customerPrepaymentRepository.findByActivityDetailItemCode(new ArrayList<String>(activityDetailItemCodeSet));
        Map<Object, Object> prepaidAmountMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(hasPrepaidList)) {
            prepaidAmountMap = hasPrepaidList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getActivityDetailItemCode())).filter(k -> Objects.nonNull(k.getPrepaidAmount())).collect(Collectors.groupingBy(CustomerPrepaymentEntity::getActivityDetailItemCode, Collectors.reducing(BigDecimal.ZERO, CustomerPrepaymentEntity::getPrepaidAmount, BigDecimal::add)));
        }
        int number = list.size();
        Map salesMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(salesOrgCodeList)) {
            salesMap = this.salesOrgVoService.findNameBySalesOrgCodes(Lists.partition(salesOrgCodeList, (int)800));
        }
        List detailCodeList = this.generateCodeService.generateCode("CP", number, Integer.valueOf(6), 2L, TimeUnit.DAYS);
        List upAccountCodeList = this.generateCodeService.generateCode("Y", number, Integer.valueOf(9), 0L, TimeUnit.DAYS);
        for (int i = 0; i < list.size(); ++i) {
            CustomerPrepaymentDto dto1 = list.get(i);
            list.get(i).setCustomerPrepaymentDetailCode((String)detailCodeList.get(i));
            list.get(i).setUpAccountCode((String)upAccountCodeList.get(i));
            list.get(i).setPrepaidAmountApplied(prepaidAmountMap.getOrDefault(dto1.getActivityDetailItemCode(), BigDecimal.ZERO));
            if (!StringUtils.isEmpty((CharSequence)dto1.getSalesOrgName()) || !StringUtils.isNotEmpty((CharSequence)dto1.getSalesOrgCode())) continue;
            list.get(i).setSalesOrgName((String)salesMap.get(dto1.getSalesOrgCode()));
        }
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, CustomerPrepaymentDto.class, CustomerPrepaymentEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.customerPrepaymentRepository.saveOrUpdateBatch(entities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List customerPrepaymentEntities = this.customerPrepaymentRepository.listByIds(ids);
        Validate.notEmpty((Collection)customerPrepaymentEntities, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        this.customerPrepaymentRepository.removeByIds(ids);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)customerPrepaymentEntities, CustomerPrepaymentEntity.class, CustomerPrepaymentDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = CustomerPrepaymentLogEventListener::onDelete;
        for (CustomerPrepaymentDto dto : dtoList) {
            CustomerPrepaymentLogEventDto logEventDto = new CustomerPrepaymentLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CustomerPrepaymentLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(List<CustomerPrepaymentDto> list, EventPrepaymentDto dto) {
        List<String> idListDto = list.stream().filter(e -> e.getId() != null).map(e -> e.getId()).collect(Collectors.toList());
        Map customerVoMap = null;
        Set customerCodeSet = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCustomerCode())).map(CustomerPrepaymentDto::getCustomerCode).collect(Collectors.toSet());
        List customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerVos)) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        for (CustomerPrepaymentDto customerPrepaymentDto : list) {
            if (!StringUtils.isNotEmpty((CharSequence)customerPrepaymentDto.getActivityOrgCode())) continue;
            customerPrepaymentDto.setSalesOrgCode(customerPrepaymentDto.getActivityOrgCode());
            customerPrepaymentDto.setSalesOrgName(customerPrepaymentDto.getActivityOrgName());
        }
        this.customerPrepaymentRepository.deleteByIdNotInList(idListDto, dto.getPrepaidCoding());
        if (!CollectionUtils.isEmpty(list)) {
            Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, CustomerPrepaymentDto.class, CustomerPrepaymentEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            Map finalCustomerVoMap = customerVoMap;
            entities.forEach(e -> {
                Validate.notNull((Object)e.getPrepaidAmount(), (String)"\u672c\u6b21\u9884\u4ed8\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setPrepaidCoding(dto.getPrepaidCoding());
                if (dto.getPrepaymentType().equals(PayInAdvanceEnum.CUSTOMER.getCode())) {
                    Validate.notNull((Object)e.getFeeAmount(), (String)"\u7533\u8bf7\u91d1\u989d\u5fc5\u586b", (Object[])new Object[0]);
                    Validate.isTrue((e.getFeeAmount().compareTo(e.getPrepaidAmount()) >= 0 ? 1 : 0) != 0, (String)"\u672c\u6b21\u9884\u4ed8\u91d1\u989d\u5fc5\u987b\u2264\u7533\u8bf7\u91d1\u989d", (Object[])new Object[0]);
                }
                if (StringUtils.isNotBlank((CharSequence)e.getCustomerCode())) {
                    CustomerVo customerVo = (CustomerVo)finalCustomerVoMap.get(e.getCustomerCode());
                    Validate.notNull((Object)customerVo, (String)("\u672a\u627e\u5230\u5ba2\u6237\u7f16\u7801\u3010" + e.getCustomerCode() + "\u3011\u6240\u5bf9\u5e94\u7684\u5ba2\u6237\u6570\u636e"), (Object[])new Object[0]);
                    e.setCustomerMdgCode(customerVo.getErpCode());
                }
            });
            for (CustomerPrepaymentEntity entity : entities) {
                SalesOrgVo salesOrgVo;
                if (!StringUtils.isEmpty((CharSequence)entity.getSalesOrgName()) || !StringUtils.isNotEmpty((CharSequence)entity.getSalesOrgCode()) || (salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(entity.getSalesOrgCode())) == null) continue;
                entity.setSalesOrgName(salesOrgVo.getSalesOrgName());
            }
            this.customerPrepaymentRepository.saveOrUpdateBatch(entities);
        }
    }

    public CustomerPrepaymentVo findById(String id) {
        CustomerPrepaymentEntity customerPrepaymentEntity = (CustomerPrepaymentEntity)((Object)this.customerPrepaymentRepository.getById((Serializable)((Object)id)));
        if (customerPrepaymentEntity == null) {
            return null;
        }
        CustomerPrepaymentVo vo = (CustomerPrepaymentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerPrepaymentEntity, CustomerPrepaymentVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        vo.setActivityOrgCode(vo.getSalesOrgCode());
        vo.setActivityOrgName(vo.getSalesOrgName());
        return vo;
    }

    public CustomerPrepaymentVo findByPrepaidCoding(String prepaidCoding) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prepaid_coding", (Object)prepaidCoding);
        CustomerPrepaymentEntity customerPrepaymentEntity = (CustomerPrepaymentEntity)((Object)this.customerPrepaymentRepository.getOne((Wrapper)wrapper));
        return (CustomerPrepaymentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerPrepaymentEntity, CustomerPrepaymentVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<CustomerPrepaymentVo> findByPrepaid(String prepaid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prepaid_coding", (Object)prepaid);
        List list = this.customerPrepaymentRepository.list((Wrapper)wrapper);
        ArrayList<CustomerPrepaymentVo> customerPrepaymentVos = new ArrayList<CustomerPrepaymentVo>(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, CustomerPrepaymentEntity.class, CustomerPrepaymentVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        if (!CollectionUtils.isEmpty(customerPrepaymentVos)) {
            for (CustomerPrepaymentVo customerPrepaymentVo : customerPrepaymentVos) {
                customerPrepaymentVo.setActivityOrgCode(customerPrepaymentVo.getSalesOrgCode());
                customerPrepaymentVo.setActivityOrgName(customerPrepaymentVo.getSalesOrgName());
            }
        }
        return customerPrepaymentVos;
    }

    public List<CustomerPrepaymentVo> findTotalPrepaidAmountByDetailPlanItemList(List<String> detailPlanItemCodeList, String processStatus) {
        return this.customerPrepaymentRepository.findTotalPrepaidAmountByDetailPlanItemList(detailPlanItemCodeList, processStatus);
    }
}

