/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.event.prepayment.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.event.prepayment.local.entity.MaterialInformationEntity;
import com.biz.crm.tpm.business.event.prepayment.local.entity.PaymentDetailEntity;
import com.biz.crm.tpm.business.event.prepayment.local.repository.MaterialInformationRepository;
import com.biz.crm.tpm.business.event.prepayment.local.repository.PaymentDetailRepository;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.EventPrepaymentDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.MaterialInformationDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.log.MaterialInformationLogEventDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.MaterialInformationLogEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.MaterialInformationService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.MaterialInformationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="prepaidCustomerService")
public class MaterialInformationServiceImpl
implements MaterialInformationService {
    @Autowired(required=false)
    private MaterialInformationRepository materialInformationRepository;
    @Autowired(required=false)
    private PaymentDetailRepository paymentDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Resource
    private DictToolkitService dictToolkitService;

    @Transactional(rollbackFor={Exception.class})
    public void create(List<MaterialInformationDto> list, EventPrepaymentDto dto) {
        Validate.notNull((Object)dto, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notEmpty(list, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        list.forEach(item -> {
            if (YesOrNoEnum.YES.getCode().equals(dto.getWhetherContract())) {
                Validate.notBlank((CharSequence)item.getContractNo(), (String)"\u5408\u540c\u5fc5\u586b", (Object[])new Object[0]);
            }
        });
        List codeList = this.generateCodeService.generateCode("MI", list.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            list.get(i).setTenantCode(TenantUtils.getTenantCode());
            list.get(i).setPrepaidCoding(dto.getPrepaidCoding());
            list.get(i).setPayCode((String)codeList.get(i));
        }
        Collection paymentDetailEntities = this.nebulaToolkitService.copyCollectionByWhiteList(list, MaterialInformationDto.class, PaymentDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Map causeCode = this.dictToolkitService.findMapByDictTypeCode("tpm_cause_code");
        Map outFlowItem = this.dictToolkitService.findMapByDictTypeCode("tpm_outflow_item");
        for (PaymentDetailEntity paymentDetailEntity : paymentDetailEntities) {
            paymentDetailEntity.setReasonName((String)causeCode.get(paymentDetailEntity.getReasonCode()));
            paymentDetailEntity.setCapitalOutflowProjectName((String)outFlowItem.get(paymentDetailEntity.getCapitalOutflowProject()));
        }
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, MaterialInformationDto.class, MaterialInformationEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.materialInformationRepository.saveBatch(entities);
        this.paymentDetailRepository.saveBatch(paymentDetailEntities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List prepaidCustomerEntities = this.materialInformationRepository.listByIds(ids);
        Validate.notEmpty((Collection)prepaidCustomerEntities, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        this.materialInformationRepository.removeByIds(ids);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)prepaidCustomerEntities, MaterialInformationEntity.class, MaterialInformationDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = MaterialInformationLogEventListener::onDelete;
        for (MaterialInformationDto dto : dtoList) {
            MaterialInformationLogEventDto logEventDto = new MaterialInformationLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MaterialInformationLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(List<MaterialInformationDto> list, EventPrepaymentDto eventPrepaymentDto) {
        List<String> codeListDto = list.stream().filter(e -> e.getPayCode() != null).map(e -> e.getPayCode()).collect(Collectors.toList());
        List newListDto = list.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getPayCode())).collect(Collectors.toList());
        this.materialInformationRepository.deleteByIdNotInList(codeListDto, eventPrepaymentDto.getPrepaidCoding());
        this.paymentDetailRepository.deleteByIdNotInList(codeListDto, eventPrepaymentDto.getPrepaidCoding());
        if (!CollectionUtils.isEmpty(newListDto)) {
            List codeList = this.generateCodeService.generateCode("MI", newListDto.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
            for (int i = 0; i < newListDto.size(); ++i) {
                ((MaterialInformationDto)newListDto.get(i)).setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                ((MaterialInformationDto)newListDto.get(i)).setTenantCode(TenantUtils.getTenantCode());
                ((MaterialInformationDto)newListDto.get(i)).setPrepaidCoding(eventPrepaymentDto.getPrepaidCoding());
                ((MaterialInformationDto)newListDto.get(i)).setPayCode((String)codeList.get(i));
                if (!YesOrNoEnum.YES.getCode().equals(eventPrepaymentDto.getWhetherContract())) continue;
                Validate.notBlank((CharSequence)list.get(i).getContractNo(), (String)"\u5408\u540c\u5fc5\u586b", (Object[])new Object[0]);
            }
            list.removeAll(newListDto);
            Collection paymentDetailEntities = this.nebulaToolkitService.copyCollectionByWhiteList(newListDto, MaterialInformationDto.class, PaymentDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(newListDto, MaterialInformationDto.class, MaterialInformationEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.materialInformationRepository.saveBatch(entities);
            this.paymentDetailRepository.saveBatch(paymentDetailEntities);
        }
        if (!CollectionUtils.isEmpty(list)) {
            Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, MaterialInformationDto.class, MaterialInformationEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            entities.forEach(e -> {
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setPrepaidCoding(eventPrepaymentDto.getPrepaidCoding());
                if (YesOrNoEnum.YES.getCode().equals(eventPrepaymentDto.getWhetherContract())) {
                    Validate.notBlank((CharSequence)e.getContractNo(), (String)"\u5408\u540c\u5fc5\u586b", (Object[])new Object[0]);
                }
            });
            this.materialInformationRepository.saveOrUpdateBatch(entities);
            this.paymentDetailRepository.updateList(list);
        }
    }

    public MaterialInformationVo findById(String id) {
        MaterialInformationEntity prepaidCustomerEntity = (MaterialInformationEntity)((Object)this.materialInformationRepository.getById((Serializable)((Object)id)));
        if (prepaidCustomerEntity == null) {
            return null;
        }
        return (MaterialInformationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepaidCustomerEntity, MaterialInformationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public MaterialInformationVo findByPrepaidCoding(String prepaidCoding) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prepaid_coding", (Object)prepaidCoding);
        MaterialInformationEntity prepaidCustomerEntity = (MaterialInformationEntity)((Object)this.materialInformationRepository.getOne((Wrapper)wrapper));
        return (MaterialInformationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepaidCustomerEntity, MaterialInformationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<MaterialInformationVo> findByPrepaid(String prepaid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prepaid_coding", (Object)prepaid);
        List list = this.materialInformationRepository.list((Wrapper)wrapper);
        List listPd = ((LambdaQueryChainWrapper)this.paymentDetailRepository.lambdaQuery().eq(PaymentDetailEntity::getPrepaidCoding, (Object)prepaid)).list();
        Collection prepaidCustomerVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, MaterialInformationEntity.class, MaterialInformationVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        prepaidCustomerVos.forEach(e -> {
            for (PaymentDetailEntity pd : listPd) {
                if (!e.getPayCode().equals(pd.getPayCode())) continue;
                e.setCapitalOutflowProject(pd.getCapitalOutflowProject());
                e.setPaymentDigest(pd.getPaymentDigest());
                e.setProfitCenter(pd.getProfitCenter());
                e.setReasonCode(pd.getReasonCode());
                break;
            }
        });
        return new ArrayList<MaterialInformationVo>(prepaidCustomerVos);
    }
}

