/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.event.prepayment.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.tpm.business.event.prepayment.local.entity.PrepaidBySupplierEntity;
import com.biz.crm.tpm.business.event.prepayment.local.repository.PrepaidBySupplierRepository;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.PrepaidBySupplierDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.dto.log.PrepaidBySupplierLogEventDto;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.PrepaidBySupplierLogEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.service.PrepaidBySupplierService;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.PrepaidBySupplierVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="prepaidBySupplierService")
public class PrepaidBySupplierServiceImpl
implements PrepaidBySupplierService {
    @Autowired(required=false)
    private PrepaidBySupplierRepository prepaidBySupplierRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    @Transactional(rollbackFor={Exception.class})
    public void create(List<PrepaidBySupplierDto> list, String code) {
        List<PrepaidBySupplierEntity> existEntityList;
        List customerVos;
        List<String> detailPlanItemCodeList = list.stream().map(PrepaidBySupplierDto::getPlanningDetailsNo).collect(Collectors.toList());
        Map<Object, Object> customerVoMap = Maps.newHashMap();
        Set customerCodeSet = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCustomerCode())).map(PrepaidBySupplierDto::getCustomerCode).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(customerCodeSet) && CollectionUtil.isNotEmpty((Collection)(customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty(existEntityList = this.prepaidBySupplierRepository.findByPlanningDetailsNoListAndProcessStatus(detailPlanItemCodeList, ProcessStatusEnum.PASS.getDictCode()))) {
            throw new UnsupportedOperationException("\u5df2\u4e0b\u4fc3\u9500\u89c4\u5212\u660e\u7ec6\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u9884\u4ed8\u6570\u636e\uff1a" + JSON.toJSONString(existEntityList.stream().map(PrepaidBySupplierEntity::getPlanningDetailsNo).collect(Collectors.toList())));
        }
        String detailCode = (String)this.generateCodeService.generateCode("Y", 1, Integer.valueOf(9), 0L, TimeUnit.DAYS).get(0);
        Map<Object, Object> finalCustomerVoMap = customerVoMap;
        list.forEach(e -> {
            if (StringUtils.isNotBlank((CharSequence)e.getCustomerCode())) {
                CustomerVo customerVo = (CustomerVo)finalCustomerVoMap.get(e.getCustomerCode());
                Validate.notNull((Object)customerVo, (String)("\u672a\u627e\u5230\u5ba2\u6237\u7f16\u7801\u3010" + e.getCustomerCode() + "\u3011\u6240\u5bf9\u5e94\u7684\u5ba2\u6237\u6570\u636e"), (Object[])new Object[0]);
                e.setCustomerMdgCode(customerVo.getErpCode());
            }
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setTenantCode(TenantUtils.getTenantCode());
            e.setPrepaidCoding(code);
            e.setUpAccountCode(detailCode);
            List<PrepaidBySupplierEntity> hasPrepaidList = this.prepaidBySupplierRepository.findByPlanningDetailsNo(e.getPlanningDetailsNo());
            if (!CollectionUtils.isEmpty(hasPrepaidList)) {
                e.setPrepaidAmountApplied(hasPrepaidList.stream().map(PrepaidBySupplierEntity::getPrepaidAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        });
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, PrepaidBySupplierDto.class, PrepaidBySupplierEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.prepaidBySupplierRepository.saveOrUpdateBatch(entities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List prepaidBySupplierEntities = this.prepaidBySupplierRepository.listByIds(ids);
        Validate.notEmpty((Collection)prepaidBySupplierEntities, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        this.prepaidBySupplierRepository.removeByIds(ids);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)prepaidBySupplierEntities, PrepaidBySupplierEntity.class, PrepaidBySupplierDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = PrepaidBySupplierLogEventListener::onDelete;
        for (PrepaidBySupplierDto dto : dtoList) {
            PrepaidBySupplierLogEventDto logEventDto = new PrepaidBySupplierLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PrepaidBySupplierLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(List<PrepaidBySupplierDto> list, String code) {
        List<String> idListDto = list.stream().filter(e -> e.getId() != null).map(e -> e.getId()).collect(Collectors.toList());
        Map customerVoMap = null;
        Set customerCodeSet = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getCustomerCode())).map(PrepaidBySupplierDto::getCustomerCode).collect(Collectors.toSet());
        List customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerVos)) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        this.prepaidBySupplierRepository.deleteByIdNotInList(idListDto, code);
        if (!CollectionUtils.isEmpty(list)) {
            Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(list, PrepaidBySupplierDto.class, PrepaidBySupplierEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            Map finalCustomerVoMap = customerVoMap;
            entities.forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)e.getCustomerCode())) {
                    CustomerVo customerVo = (CustomerVo)finalCustomerVoMap.get(e.getCustomerCode());
                    Validate.notNull((Object)customerVo, (String)("\u672a\u627e\u5230\u5ba2\u6237\u7f16\u7801\u3010" + e.getCustomerCode() + "\u3011\u6240\u5bf9\u5e94\u7684\u5ba2\u6237\u6570\u636e"), (Object[])new Object[0]);
                    e.setCustomerMdgCode(customerVo.getErpCode());
                }
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                e.setTenantCode(TenantUtils.getTenantCode());
                e.setPrepaidCoding(code);
            });
            this.prepaidBySupplierRepository.saveOrUpdateBatch(entities);
        }
    }

    public PrepaidBySupplierVo findById(String id) {
        PrepaidBySupplierEntity prepaidBySupplierEntity = (PrepaidBySupplierEntity)((Object)this.prepaidBySupplierRepository.getById((Serializable)((Object)id)));
        if (prepaidBySupplierEntity == null) {
            return null;
        }
        return (PrepaidBySupplierVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepaidBySupplierEntity, PrepaidBySupplierVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public PrepaidBySupplierVo findByPrepaidCoding(String prepaidCoding) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prepaid_coding", (Object)prepaidCoding);
        PrepaidBySupplierEntity prepaidBySupplierEntity = (PrepaidBySupplierEntity)((Object)this.prepaidBySupplierRepository.getOne((Wrapper)wrapper));
        return (PrepaidBySupplierVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepaidBySupplierEntity, PrepaidBySupplierVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<PrepaidBySupplierVo> findByPrepaid(String prepaid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"prepaid_coding", (Object)prepaid);
        List list = this.prepaidBySupplierRepository.list((Wrapper)wrapper);
        Collection prepaidBySupplierVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, PrepaidBySupplierEntity.class, PrepaidBySupplierVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<PrepaidBySupplierVo>(prepaidBySupplierVos);
    }

    public List<PrepaidBySupplierVo> findTotalPrepaidAmountByDetailPlanItemList(List<String> detailPlanItemCodeList, String processCode) {
        return this.prepaidBySupplierRepository.findTotalPrepaidAmountByDetailPlanItemList(detailPlanItemCodeList, processCode);
    }
}

