package com.biz.crm.tpm.business.expense.initiation.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 费用立项明细dto
 *
 * @author: yaoyongming
 * @date: 2022/11/7 10:43
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ExpenseInitiationDetailDto", description = "费用立项明细dto")
public class ExpenseInitiationDetailDto extends TenantFlagOpDto {

    /**
     * 费用立项编码
     */
    @ApiModelProperty("费用立项编码")
    private String expenseInitiationCode;

    /**
     * 费用立项明细编码
     */
    @ApiModelProperty("费用立项明细编码")
    private String expenseInitiationDetailCode;

    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    /**
     * 预计销售金额（元）
     */
    @ApiModelProperty("预计销售金额（元）")
    private BigDecimal estimatedAmount;

    /**
     * 预计ROI
     */
    @ApiModelProperty("预计ROI")
    private BigDecimal estimatedRoi;

    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    private String materialCode;

    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    private String materialName;

    /**
     * 物料发放形式
     */
    @ApiModelProperty("物料发放形式")
    private String materialDistribution;

    /**
     * 单价
     */
    @ApiModelProperty("单价")
    private BigDecimal price;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private BigDecimal quantity;

    /**
     * 预计短信价格
     */
    @ApiModelProperty("预计短信价格")
    private BigDecimal estimatedSmPrice;

    /**
     * 发送数量
     */
    @ApiModelProperty("发送数量")
    private BigDecimal smQuantity;

    /**
     * 会员拉新数量
     */
    @ApiModelProperty("会员拉新数量")
    private BigDecimal memberRecruitmentQuantity;

    /**
     * 预计直播销售金额（元）
     */
    @ApiModelProperty("预计直播销售金额（元）")
    private BigDecimal estimatedLiveAmount;

    /**
     * 直播佣金（元）
     */
    @ApiModelProperty("直播佣金（元）")
    private BigDecimal liveCommission;

    /**
     * 佣金（元）
     */
    @ApiModelProperty("佣金（元）")
    private BigDecimal commission;

    /**
     * 坑位费
     */
    @ApiModelProperty("坑位费")
    private BigDecimal pitFee;
}
