package com.biz.crm.tpm.business.expense.initiation.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationDto;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationSubmitDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 费用立项实体类(ExpenseInitiation)表服务接口
 *
 * @author yaoyongming
 * @since 2022-11-05 17:47:36
 */
public interface ExpenseInitiationService {

    /**
     * 分页查询数据
     *
     * @param pageable          分页对象
     * @param expenseInitiation 实体对象
     * @return
     */
    Page<ExpenseInitiationDto> findByConditions(Pageable pageable, ExpenseInitiationDto expenseInitiation);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    ExpenseInitiationDto findById(String id);

    /**
     * 新增数据
     *
     * @param expenseInitiation 实体对象
     * @return 新增结果
     */
    void create(ExpenseInitiationDto expenseInitiation);

    /**
     * 修改新据
     *
     * @param expenseInitiation 实体对象
     * @return 修改结果
     */
    void update(ExpenseInitiationDto expenseInitiation);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 下拉列表
     *
     * @param pageable
     * @param dto
     * @return
     */
    List<ExpenseInitiationDto> getList(Pageable pageable,ExpenseInitiationDto dto);

    /**
     * 促销规划查看费用立项
     *
     * @param pageable
     * @param code
     * @return
     */
    Page<ExpenseInitiationDto> findByPromotionPlanCode(Pageable pageable, String code);

    /**
     * 保存并提交审批
     *
     * @param expenseInitiationSubmitDto 实体对象
     * @return
     */
    void submitAndSetPass(ExpenseInitiationSubmitDto expenseInitiationSubmitDto);

    /**
     * 提交工作流
     *
     * @param expenseInitiationSubmitDto
     */
    void submitApproval(ExpenseInitiationSubmitDto expenseInitiationSubmitDto);

    /**
     * 驳回追回
     *
     * @param expenseInitiation
     */
    void rejectRecover(ExpenseInitiationDto expenseInitiation);
}

