package com.biz.crm.tpm.business.marketing.strategy.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 营销策略(MarketingStrategy)
 *
 * @author wanghaojia
 * @since 2022-11-05 15:57:30
 */
@ApiModel(value = "MarketingStrategy", description = "营销策略")
@TableName("tpm_marketing_strategy")
@Getter
@Setter
@Entity(name = "tpm_marketing_strategy")
@org.hibernate.annotations.Table(appliesTo = "tpm_marketing_strategy", comment = "营销策略")
@Table(
    name = "tpm_marketing_strategy",
    indexes = {
        @Index(name = "marketing_strategy_inx1", columnList = "strategy_code,", unique = true)
    }
)
public class MarketingStrategy extends TenantFlagOpEntity {
    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    @Column(name = "strategy_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '策略编码'")
    private String strategyCode;
    /**
     * 策略名称
     */
    @ApiModelProperty("策略名称")
    @Column(name = "strategy_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '策略名称'")
    private String strategyName;
    /**
     * 策略标识
     */
    @ApiModelProperty("策略标识")
    @Column(name = "strategy_sign", nullable = true, length = 11, columnDefinition = "int(11) COMMENT '策略标识'")
    private Integer strategySign;
    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessUnitCode;
    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门编码")
    @Column(name = "attr_org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '归属部门编码'")
    private String attrOrgCode;
    /**
     * 归属部门名称
     */
    @ApiModelProperty("归属部门名称")
    @Column(name = "attr_org_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '归属部门名称'")
    private String attrOrgName;
    /**
     * 策略主题
     */
    @ApiModelProperty("策略主题")
    @Column(name = "strategy_title", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '策略主题'")
    private String strategyTitle;
    /**
     * 策略类型
     */
    @ApiModelProperty("策略类型,数据字典：marketing_strategy_type")
    @Column(name = "strategy_type", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '策略类型'")
    private String strategyType;
    /**
     * 费用金额（元）
     */
    @ApiModelProperty("费用金额（元）")
    @Column(name = "fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '费用金额（元）'")
    private BigDecimal feeAmount;
    /**
     * 已使用金额（元）
     */
    @ApiModelProperty("已使用金额（元）")
    @Column(name = "used_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '已使用金额（元）'")
    private BigDecimal usedAmount;
    /**
     * 已关闭金额（元）
     */
    @ApiModelProperty("已关闭金额（元）")
    @Column(name = "close_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '已关闭金额（元）'")
    private BigDecimal closeAmount;
    /**
     * 策略描述
     */
    @ApiModelProperty("策略描述")
    @Column(name = "strategy_desc", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '策略描述'")
    private String strategyDesc;

    /**
     * 策略年度
     */
    @Column(name = "strategy_year", nullable = true, length = 4, columnDefinition = "varchar(4) COMMENT '策略年度'")
    private String strategyYear;

    /**
     * 策略开始月份
     */
    @Column(name = "begin_strategy_year_month", nullable = true, length = 19, columnDefinition = "varchar(19) COMMENT '策略开始月份'")
    private String beginStrategyYearMonth;

    /**
     * 策略结束月份
     */
    @Column(name = "end_strategy_year_month", nullable = true, length = 19, columnDefinition = "varchar(19) COMMENT '策略结束月份'")
    private String endStrategyYearMonth;

    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    @Column(name = "process_no", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '流程编号'")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @Column(name = "process_status", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '审批状态'")
    private String processStatus;

    /**
     * 是否跨月策略
     */
    @ApiModelProperty(name = "是否跨月策略", notes = "")
    @Column(name = "is_cross_month", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否跨月策略，   Y是N否'")
    private String isCrossMonth;

    @ApiModelProperty("是否已校验 Y:已校验，N:未校验")
    private String isValidate;

    /**
     * 是否完全承接
     */
    @ApiModelProperty("是否完全承接")
    @Column(name = "full_accept", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '是否完全承接'")
    private String fullAccept;

    /**
     * 策略状态
     */
    @ApiModelProperty("策略状态")
    @Column(name = "strategy_status", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '策略状态'")
    private String strategyStatus;

}

