package com.biz.crm.tpm.business.marketing.strategy.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.math.BigDecimal;

/**
 * 营销策略(MarketingStrategy)-预算
 *
 * @author wanghaojia
 * @since 2022-11-03 18:24:04
 */
@ApiModel(value = "MarketingStrategyBudget", description = "营销策略-预算")
@TableName("tpm_marketing_strategy_budget")
@Getter
@Setter
@Entity(name = "tpm_marketing_strategy_budget")
@org.hibernate.annotations.Table(appliesTo = "tpm_marketing_strategy_budget", comment = "营销策略-预算")
@Table(
    name = "tpm_marketing_strategy_budget",
    indexes = {
        @Index(name = "marketing_strategy_budget_inx1", columnList = "strategy_code,", unique = false),
        @Index(name = "marketing_strategy_budget_inx2", columnList = "strategy_item_code,", unique = false),
        @Index(name = "marketing_strategy_budget_inx3", columnList = "month_budget_code,", unique = false),
    }
)
public class MarketingStrategyBudget extends TenantFlagOpEntity {

    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    @Column(name = "strategy_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '策略编码'")
    private String strategyCode;

    /**
     * 策略明细编码
     */
    @ApiModelProperty("策略明细编码")
    @Column(name = "strategy_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '策略明细编码'")
    private String strategyItemCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    @Column(name = "month_budget_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String monthBudgetCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '预算项目名称'")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "fee_belong_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归口[数据字典:tpm_fee_belong] '")
    private String feeBelongCode;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    @Column(name = "after_freeze_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '冻结后可用金额'")
    private BigDecimal afterFreezeAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    @Column(name = "used_strategy_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已使用策略金额 '")
    private BigDecimal usedStrategyAmount;

    /**
     * 本次使用金额
     */
    @ApiModelProperty(value = "本次使用金额", notes = "")
    @Column(name = "use_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本次使用金额'")
    private BigDecimal useAmount;

    /**
     * 已占用金额
     */
    @ApiModelProperty(value = "已占用金额", notes = "")
    @Column(name = "used_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '已占用金额'")
    private BigDecimal usedAmount;

}

