package com.biz.crm.tpm.business.marketing.strategy.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 营销策略(MarketingStrategy)
 *
 * @author wanghaojia
 * @since 2022-11-03 18:24:04
 */
@ApiModel(value = "MarketingStrategyItem", description = "营销策略明细")
@TableName("tpm_marketing_strategy_item")
@Getter
@Setter
@Entity(name = "tpm_marketing_strategy_item")
@org.hibernate.annotations.Table(appliesTo = "tpm_marketing_strategy_item", comment = "营销策略明细")
@Table(
    name = "tpm_marketing_strategy_item",
    indexes = {
        @Index(name = "marketing_strategy_item_inx1", columnList = "strategy_code,", unique = false),
        @Index(name = "marketing_strategy_item_inx2", columnList = "strategy_item_code,", unique = true),
    }
)
public class MarketingStrategyItem extends TenantFlagOpEntity {

    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    @Column(name = "strategy_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '策略编码'")
    private String strategyCode;

    /**
     * 策略名称
     */
    @ApiModelProperty("策略名称")
    @Column(name = "strategy_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '策略名称'")
    private String strategyName;
    /**
     * 策略主题
     */
    @ApiModelProperty("策略主题")
    @Column(name = "strategy_title", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '策略主题'")
    private String strategyTitle;
    /**
     * 策略描述
     */
    @ApiModelProperty("策略描述")
    @Column(name = "strategy_desc", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '策略描述'")
    private String strategyDesc;

    /**
     * 策略明细编码
     */
    @ApiModelProperty("策略明细编码")
    @Column(name = "strategy_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '策略明细编码'")
    private String strategyItemCode;
    /**
     * 策略标识
     */
    @ApiModelProperty("策略标识")
    @Column(name = "strategy_sign", nullable = true, length = 11, columnDefinition = "int(11) COMMENT '策略标识'")
    private Integer strategySign;
    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    @Column(name = "strategy_org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '区域编码'")
    private String strategyOrgCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域erp编码")
    @Column(name = "strategy_org_erp_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '区域erp编码'")
    private String strategyOrgErpCode;

    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @Column(name = "strategy_org_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String strategyOrgName;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    @Column(name = "first_channel_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '一级管理渠道'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '一级管理渠道'")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @Column(name = "second_channel_code", nullable = true, length = 32, columnDefinition = "varchar(512) COMMENT '二级管理渠道'")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name", nullable = true, length = 128, columnDefinition = "varchar(2000) COMMENT '二级管理渠道名称'")
    private String secondChannelName;

    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    @Column(name = "distribution_channel_name", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道名称'")
    private String distributionChannelName;

    /**
     * 系统
     */
    @ApiModelProperty("系统/零售商")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '系统'")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("系统/零售商名称")
    @Column(name = "system_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '系统/零售商名称'")
    private String systemName;
    /**
     * 策略年月
     */
    @ApiModelProperty("策略年月")
    @Column(name = "strategy_year_month", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '策略年月'")
    private String strategyYearMonth;
    /**
     * 策略开始年月
     */
    @ApiModelProperty("策略开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "begin_date", length = 20, columnDefinition = "datetime COMMENT '策略开始时间 '")
    private Date beginDate;
    /**
     * 策略结束年月
     */
    @ApiModelProperty("策略结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "end_date", length = 20, columnDefinition = "datetime COMMENT '策略结束时间 '")
    private Date endDate;
    /**
     * 预算编码
     */
    @ApiModelProperty(value = "总部预算编码", notes = "")
    @Column(name = "head_month_budget_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '总部预算编码'")
    private String headMonthBudgetCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "总部预算项目编码", notes = "")
    @Column(name = "head_budget_item_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '总部预算项目编码'")
    private String headBudgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "总部预算项目名称", notes = "")
    @Column(name = "head_budget_item_name", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '总部预算项目名称'")
    private String headBudgetItemName;

    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区公投预算编码", notes = "")
    @Column(name = "region_referendum_month_budget_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区公投预算编码'")
    private String regionReferendumMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区公投预算项目编码", notes = "")
    @Column(name = "region_referendum_budget_item_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区公投预算项目编码'")
    private String regionReferendumBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区公投预算项目名称", notes = "")
    @Column(name = "region_referendum_budget_item_name", nullable = true, length = 1024, columnDefinition = "varchar(255) COMMENT '大区公投预算项目名称'")
    private String regionReferendumBudgetItemName;

    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区自投预算编码", notes = "")
    @Column(name = "region_automatic_month_budget_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区自投预算编码'")
    private String regionAutomaticMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区自投预算项目编码", notes = "")
    @Column(name = "region_automatic_budget_item_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区自投预算项目编码'")
    private String regionAutomaticBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区自投预算项目名称", notes = "")
    @Column(name = "region_automatic_budget_item_name", nullable = true, length = 1024, columnDefinition = "varchar(255) COMMENT '大区自投预算项目名称'")
    private String regionAutomaticBudgetItemName;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    @Column(name = "month_budget_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String monthBudgetCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算项目编码'")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '预算项目名称'")
    private String budgetItemName;

    /**
     * 归口
     */
    @ApiModelProperty("归口")
    @Column(name = "fee_belong_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '归口'")
    private String feeBelongCode;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", nullable = true, length = 500, columnDefinition = "varchar(500) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 1000, columnDefinition = "varchar(4000) COMMENT '活动类型名称'")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 500, columnDefinition = "varchar(500) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 1000, columnDefinition = "varchar(4000) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;


    /**
     * 活动力度
     */
    @ApiModelProperty("活动力度")
    @Column(name = "activity_intensity", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动力度'")
    private String activityIntensity;
    /**
     * 活动场次
     */
    @ApiModelProperty("活动场次")
    @Column(name = "activity_number", nullable = true, length = 11, columnDefinition = "int(11) COMMENT '活动场次'")
    private Integer activityNumber;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    @Column(name = "quantity", nullable = true, length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer quantity;
    /**
     * 费用金额（元）
     */
    @ApiModelProperty("费用金额（元）")
    @Column(name = "fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '费用金额（元）'")
    private BigDecimal feeAmount;

    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额（元）")
    @Column(name = "head_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '总部承担金额（元）'")
    private BigDecimal headFeeAmount;

    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    @Column(name = "region_referendum_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区公投预算金额（元）'")
    private BigDecimal regionReferendumFeeAmount;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    @Column(name = "region_automatic_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区自投预算金额（元）'")
    private BigDecimal regionAutomaticFeeAmount;

    /**
     * 预算分摊规则
     */
    @ApiModelProperty("预算分摊规则")
    @Column(name = "budget_share_rule", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算分摊规则'")
    private String budgetShareRule;
    /**
     * 控制系数
     */
    @ApiModelProperty(value = "控制系数")
    @Column(name = "control_ratio", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '控制系数'")
    private BigDecimal controlRatio;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @Column(name = "region", length = 255, columnDefinition = "varchar(255) COMMENT '区域'")
    private String region;
    /**
     * 城市名称
     */
    @ApiModelProperty("城市名称")
    @Column(name = "city_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '城市名称 '")
    private String cityName;

    /**
     * 调整前版本号
     */
    @ApiModelProperty("调整前变更编码")
    @Column(name = "curr_modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '调整前版本号'")
    private String currModifyBusinessCode;

    /**
     * 是否变更过Y/N
     */
    @Column(name = "has_modify", nullable = true, length = 1, columnDefinition = "varchar(1) COMMENT '是否变更过Y/N'")
    private String hasModify;

    /**
     * 是否跨月策略
     */
    @ApiModelProperty(name = "是否跨月策略", notes = "")
    @Column(name = "is_cross_month", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否跨月策略，   Y是N否'")
    private String isCrossMonth;

    @ApiModelProperty(name = "模版编码", notes = "")
    @Column(name = "template_config_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '模版编码'")
    private String templateConfigCode;

    /**
     * 活动投入方向
     */
    @ApiModelProperty("活动投入方向")
    @Column(name = "activity_input_direction", nullable = true, length = 512, columnDefinition = "VARCHAR(512) COMMENT '活动投入方向'")
    private String activityInputDirection;

    /**
     * 费用类型
     */
    @ApiModelProperty("费用类型")
    @Column(name = "fee_type", nullable = true, length = 24, columnDefinition = "VARCHAR(32) COMMENT '费用类型'")
    private String feeType;

    /**
     * 销量目标
     */
    @ApiModelProperty("销量目标")
    @Column(name = "sales_goal_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '销量目标'")
    private BigDecimal salesGoalAmount;

    /**
     * 费效比
     */
    @ApiModelProperty("费效比")
    @Column(name = "cost_effectiveness_ratio", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '费效比'")
    private BigDecimal costEffectivenessRatio;


    /**
     * 是否关闭
     */
    @ApiModelProperty(name = "是否关闭", notes = "")
    @Column(name = "is_close", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否关闭，   Y是N否'")
    private String isClose;

}

