package com.biz.crm.tpm.business.marketing.strategy.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyContentExportVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/2/3 14:50
 * @description: 营销策略内容导出
 */
@Component
public class MarketStrategyContentExportProcess implements ExportProcess<MarketStrategyContentExportVo> {

    @Autowired(required = false)
    private MarketingStrategyItemService itemService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private MarketingStrategyItemService marketingStrategyItemService;
    @Autowired(required = false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;




    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        Integer total = itemService.getTotal((String) params.get("cacheKey"));
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        Page<MarketingStrategyItemVo> cachePage = marketingStrategyItemService.findCachePageList(pageable, itemDto, cacheKey);
        if (cachePage.getSize() == 0) {
            return new JSONArray();
        }
        Collection<MarketStrategyContentExportVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(cachePage.getRecords(), MarketingStrategyItemVo.class, MarketStrategyContentExportVo.class, LinkedHashSet.class, ArrayList.class);
        //调整
        adjustData(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos));
    }

    @Override
    public Class<MarketStrategyContentExportVo> findCrmExcelVoClass() {
        return MarketStrategyContentExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "TPM_MARKET_STRATEGY_CONTENT_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "营销策略内容导出";
    }

    /**
     * 调整数据
     *
     * @param data
     */
    private void adjustData(Collection<MarketStrategyContentExportVo> data) {
        //  获取系统
        Map<String, String> sysMap = this.customerRetailerVoService.getAllRetailerCode();
        //费用归口
        Map<String, String> feeMap = dictToolkitService.findMapByDictTypeCode(MarketingStrategyConstant.DICT_TPM_FEE_BELONG_US);
        for (MarketStrategyContentExportVo vo : data) {
            if (StringUtils.isNotBlank(vo.getSystemCode())) {
                vo.setSystemCode(sysMap.getOrDefault(vo.getSystemCode(), vo.getSystemCode()));
            }
            if (StringUtils.isNotBlank(vo.getFeeBelongCode())) {
                vo.setFeeBelongCode(feeMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
            }
        }
    }
}
